/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.ValidationPreferencesHelper;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;

public final class StructureObjectValidator
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final int STRUCTURE_OBJECT_ISSUE = 200;
    public static final int CUSTOMIZATION_ISSUE = 201;
    public static final int LOV_ISSUE = 202;
    public static final StructureObjectValidator INSTANCE = new StructureObjectValidator();
    private static boolean reduceErrorsToWarnings;
    private ValidationPreferencesHelper preferenceStore;

    private StructureObjectValidator() {
        this.reset();
        this.getValidationPreferencesHelper().getValidationPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void reset() {
        reduceErrorsToWarnings = this.getValidationPreferencesHelper().isReduceErrorsToWarnings();
    }

    public IStatus validate(IDataControlObject dataControlObject) {
        return dataControlObject != null ? this.validate(dataControlObject.getStructureObject()) : Status.OK_STATUS;
    }

    public IStatus validate(IStructureObject structureObject) {
        if (structureObject != null) {
            StructureObjectCustomization customization;
            IStatus status = this.basicValidate(structureObject);
            if (!status.isOK()) {
                return status;
            }
            MultiStatus multiStatus = new MultiStatus("oracle.eclipse.tools.adf.dtrt.v120102", 0, NLS.bind((String)Messages.structureObjectBeingValidated, (Object)structureObject.getId()), null);
            this.validate(multiStatus, structureObject);
            if (structureObject.isCustomized() && (customization = StructureUtil.getCustomization(structureObject)) != null) {
                this.validate(multiStatus, customization);
                StructureObjectCustomization.LOV lov = customization.getLOV();
                if (lov != null) {
                    this.validate(multiStatus, structureObject, null, lov);
                }
            }
            if (!multiStatus.isOK()) {
                return multiStatus;
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus validate(IStructureObject structureObject, StructureObjectCustomization.LOV lov) {
        if (lov != null) {
            if (structureObject == null || structureObject.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            MultiStatus multiStatus = new MultiStatus("oracle.eclipse.tools.adf.dtrt.v120102", 0, Messages.lovBeingValidated, null);
            this.validate(multiStatus, structureObject, null, lov);
            if (!multiStatus.isOK()) {
                return multiStatus;
            }
        }
        return Status.OK_STATUS;
    }

    IStatus validate(StructureObjectCustomization customization, StructureObjectCustomization.LOV lov) {
        if (lov != null) {
            if (customization == null || customization.isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            MultiStatus multiStatus = new MultiStatus("oracle.eclipse.tools.adf.dtrt.v120102", 0, Messages.lovBeingValidated, null);
            this.validate(multiStatus, null, customization, lov);
            if (!multiStatus.isOK()) {
                return multiStatus;
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus basicValidate(IStructureObject structureObject) {
        if (structureObject.isDisposed()) {
            return this.createErrorStatus(200, Messages.structureObjectIsDisposed, new String[0]);
        }
        if (DTRTUtil.isEmpty((String)structureObject.getId())) {
            return this.createErrorStatus(200, Messages.structureObjectEmptyId, new String[0]);
        }
        return Status.OK_STATUS;
    }

    private void validate(MultiStatus multiStatus, IStructureObject structureObject) {
        assert (multiStatus != null);
        String id = structureObject.getId();
        assert (!DTRTUtil.isEmpty((String)id));
        this.validate(multiStatus, structureObject.getURI() != null, 200, Messages.structureObjectNullURI, id);
        this.validate(multiStatus, !DTRTUtil.isEmpty((String)DTRTUtil.getLabel((IDescribable)structureObject)), 200, Messages.structureObjectEmptyLabel, id);
        this.validate(multiStatus, !DTRTUtil.isEmpty((String)DTRTUtil.getLabel((IDescriptor)structureObject.getTypeDescriptor())), 200, Messages.structureObjectEmptyType, id);
        if (!structureObject.canCustomize()) {
            this.validate(multiStatus, !structureObject.isCustomized() && StructureUtil.getCustomization(structureObject) == null && !StructureObjectCustomization.hasCustomization(structureObject), 200, Messages.structureObjectCannotBeCustomizedButIs, id);
        }
        this.validate(multiStatus, !structureObject.isCustomized() || StructureUtil.getCustomization(structureObject) != null, 200, Messages.structureObjectIsCustomizedButHasNoCustomizationObject, id);
        if (structureObject instanceof IStructureChild) {
            IStructureChild structureChild = (IStructureChild)structureObject;
            this.validate(multiStatus, structureChild.getKind() != null, 200, Messages.structureChildNullKind, id);
            this.validate(multiStatus, DTRTObjectUtil.getStructure((IStructureObject)structureChild) != null, 200, Messages.structureChildNotInStructure, id);
        }
    }

    private void validate(MultiStatus multiStatus, StructureObjectCustomization customization) {
        assert (multiStatus != null);
        this.validate(multiStatus, !customization.isDisposed(), 201, Messages.customizationIsDisposed, new String[0]);
        this.validate(multiStatus, customization.getStructureChildKind() != null, 201, Messages.customizationNullStructureChildKind, new String[0]);
        StructureObjectType structureObjectType = customization.getStructureObjectType();
        this.validate(multiStatus, structureObjectType != null, 201, Messages.customizationNullStructureObjectType, new String[0]);
        this.validate(multiStatus, customization.isEmpty() || !customization.getCustomizationFiles().isEmpty(), 201, Messages.customizationIsNotEmptyButHasNoFiles, new String[0]);
    }

    private void validate(MultiStatus multiStatus, IStructureObject structureObject, StructureObjectCustomization customization, StructureObjectCustomization.LOV lov) {
        assert (multiStatus != null);
        String lovName = lov.getName();
        this.validate(multiStatus, !DTRTUtil.isEmpty((String)lovName), 202, Messages.lovEmptyName, new String[0]);
        if (lovName != null) {
            IStatus status;
            if (customization == null) {
                customization = StructureUtil.getCustomization(structureObject);
            }
            if (customization != null && !(status = customization.isValidLOVName(lovName)).isOK()) {
                multiStatus.add(status);
            }
            this.validate(multiStatus, !DTRTUtil.isEmpty((String)lov.getViewAccessorName()), 202, Messages.lovEmptyViewAccessorName, lovName);
            String viewInstanceName = lov.getViewInstanceName();
            this.validate(multiStatus, StructureObjectCustomization.LOV.isValidViewInstanceName(viewInstanceName), 202, Messages.lovInvalidViewInstanceName, viewInstanceName, lovName);
            String validScheme = StructureObjectCustomization.LOV.isValidViewInstanceNameScheme(viewInstanceName);
            this.validate(multiStatus, validScheme == null, 202, Messages.lovInvalidViewInstanceScheme, lov.getViewInstanceName(), lovName, validScheme);
            this.validate(multiStatus, lov.getControlType() != null, 202, Messages.lovNullControlType, lovName);
            StructureObjectType structureObjectType = structureObject != null ? StructureObjectType.getStructureObjectType(structureObject) : (customization != null ? customization.getStructureObjectType() : null);
            this.validate(multiStatus, structureObjectType != StructureObjectType.ACCESSOR || !lov.getDisplayAttributeNames().isEmpty(), 202, Messages.lovNoDisplayAttsForAccessor, lovName);
        }
    }

    private void validate(MultiStatus multiStatus, boolean condition, int code, String message, String ... nlsBindings) {
        if (!condition) {
            multiStatus.add(this.createErrorStatus(code, message, nlsBindings));
        }
    }

    private IStatus createErrorStatus(int code, String message, String ... nlsBindings) {
        return new Status(reduceErrorsToWarnings ? 2 : 4, "oracle.eclipse.tools.adf.dtrt.v120102", code, NLS.bind((String)message, (Object[])nlsBindings), null);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        this.reset();
    }

    private ValidationPreferencesHelper getValidationPreferencesHelper() {
        if (this.preferenceStore == null) {
            this.preferenceStore = ValidationPreferencesHelper.createValidationPreferencesHelper();
        }
        return this.preferenceStore;
    }

    private static class Messages
    extends NLS {
        public static String structureObjectBeingValidated;
        public static String lovBeingValidated;
        public static String structureObjectIsDisposed;
        public static String structureObjectEmptyId;
        public static String structureObjectNullURI;
        public static String structureObjectEmptyLabel;
        public static String structureObjectEmptyType;
        public static String structureObjectCannotBeCustomizedButIs;
        public static String structureObjectIsCustomizedButHasNoCustomizationObject;
        public static String structureChildNullKind;
        public static String structureChildNotInStructure;
        public static String customizationIsDisposed;
        public static String customizationNullStructureChildKind;
        public static String customizationNullStructureObjectType;
        public static String customizationIsNotEmptyButHasNoFiles;
        public static String lovEmptyName;
        public static String lovEmptyViewAccessorName;
        public static String lovInvalidViewInstanceName;
        public static String lovInvalidViewInstanceScheme;
        public static String lovNoDisplayAttsForAccessor;
        public static String lovNullControlType;

        static {
            NLS.initializeMessages((String)StructureObjectValidator.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

