/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.adfdt.model.objects.BeanStructure;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.util.IOpenable;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.util.StructureSourceFactory;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;

final class StructureDefinitionStructure
extends NamedDefinitionStructureObject<StructureDefinition>
implements IStructure {
    private StructureProvider structureProvider;
    private IStructure.IStructureSource source;
    private String qualifiedName;
    private List<? extends IStructureChild> children;

    public StructureDefinitionStructure(StructureProvider structureProvider, StructureDefinition structureDefinition) {
        super(structureDefinition);
        if (structureProvider == null) {
            throw new IllegalArgumentException("structureProvider cannot be null");
        }
        this.structureProvider = structureProvider;
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            DTRTUtil.dispose(this.children);
            this.children = null;
        }
        this.source = null;
        this.structureProvider = null;
        super.dispose();
    }

    @Override
    public StructureProvider getStructureProvider() {
        return this.structureProvider;
    }

    @Override
    protected String computeNonEncodedURISegment() {
        StringBuilder sb = new StringBuilder();
        IResource resource = DTRTObjectUtil.getResource((IStructure.IStructureSource)this.getSource());
        if (resource != null) {
            sb.append(resource.getFullPath());
        } else {
            sb.append(this.getStructureProvider().getManager().getProject());
        }
        return sb.append('_').append(this.getQualifiedName()).toString();
    }

    public IStructureObject getParent() {
        return null;
    }

    public String getQualifiedName() {
        return this.qualifiedName == null ? (this.qualifiedName = StructureUtil.getSourceName((StructureDefinition)this.getNamedDefinition())) : this.qualifiedName;
    }

    public IStructure.IStructureSource getSource() {
        if (this.source == null) {
            BeanStructure beanStructure = StructureUtil.getBeanStructure((StructureDefinition)this.getNamedDefinition());
            if (beanStructure != null) {
                IFile file;
                IDTRTManager manager = this.getStructureProvider().getManager();
                if (manager.isAccessible(file = manager.getElementFile(beanStructure))) {
                    return StructureSourceFactory.createFileSource((IFile)file);
                }
                return null;
            }
            try {
                IType type = this.computeJavaElement();
                if (type != null) {
                    this.source = StructureSourceFactory.createTypeSource((IType)type);
                }
            }
            catch (Exception e) {
                DTRTvBundle.log(e);
            }
        }
        return this.source;
    }

    @Override
    protected String computeSourceTypeDescriptorLabel() {
        IStructure.IStructureSource source = this.getSource();
        return source instanceof IStructure.ITypeSource ? Messages.sourceTypeJava : (source != null ? Messages.sourceTypeBeanStructure : StructureUtil.ADF_STRUCTURE_DESCRIPTOR.getLabel());
    }

    @Override
    protected String doComputeLabel() {
        return this.getQualifiedName();
    }

    @Override
    protected String computeToolTipText() {
        String text = this.getQualifiedName();
        IStructure.IStructureSource source = this.getSource();
        IResource resource = DTRTObjectUtil.getResource((IStructure.IStructureSource)source);
        if (resource != null) {
            text = String.valueOf(text) + '\n' + resource.getFullPath().toString();
        } else if (source == null) {
            text = String.valueOf(text) + '\n' + StructureUtil.ADF_STRUCTURE_DESCRIPTOR.getLabel();
        }
        return text;
    }

    @Override
    protected ImageManager.IImageData computeImageData() {
        ImageManager.IImageData imageData = (ImageManager.IImageData)DTRTUtil.getAdapter((IAdaptable)this.getSource(), ImageManager.IImageData.class);
        return imageData != null ? imageData : super.computeImageData();
    }

    protected IType computeJavaElement() throws CoreException {
        return this.getStructureProvider().getManager().findType(this.getQualifiedName());
    }

    @Override
    protected final IFile getDeclarationFile() {
        if (!this.data.isDeclarationFileSet()) {
            IStructure.IStructureSource source = this.getSource();
            if (source != null && source.getResource() instanceof IFile) {
                this.data.setDeclarationFile((IFile)source.getResource());
            } else {
                this.data.setDeclarationFile(null);
            }
        }
        return this.data.getdeclarationFile();
    }

    @Override
    protected void computeOpenables(Set<IOpenable> set) {
        IJavaElement javaElement;
        if (this.getDeclarationFile() != null) {
            set.add(StructureUtil.createDeclarationOpenable(this.getDeclarationFile()));
        }
        if ((javaElement = this.getJavaElement()) != null) {
            set.add(StructureUtil.createJavaOpenable(javaElement));
        }
    }

    @Override
    protected void adjustOpenables(Set<IOpenable> openables) {
        IFile customizationFile = StructureObjectCustomization.getCustomizationFile(this);
        StructureUtil.handleCustomizationFiles(openables, customizationFile == null ? Collections.emptySet() : Collections.singleton(customizationFile));
    }

    public boolean canCustomize() {
        return false;
    }

    public boolean isCustomizationFile(IFile file) {
        return file != null && file.equals((Object)StructureObjectCustomization.getCustomizationFile(this));
    }

    @Override
    protected StructureObjectCustomization getCustomization() {
        return null;
    }

    public List<? extends IStructureChild> getChildren() {
        if (this.children == null) {
            ArrayList<IStructureChild> list = new ArrayList<IStructureChild>();
            StructureDefinition structureDefinition = (StructureDefinition)this.getNamedDefinition();
            StructureUtil.addOperationDefinitions(this, list, structureDefinition.getConstructorOperationDefinitions(), IStructureChild.StructureChildKind.INTRINSIC);
            StructureUtil.addAttributeDefinitions(this, list, structureDefinition.getAttributeDefinitions(), IStructureChild.StructureChildKind.INTRINSIC);
            StructureUtil.addAttributeDefinitions(this, list, structureDefinition.getAccessorDefinitions(), IStructureChild.StructureChildKind.INTRINSIC);
            StructureUtil.addBasicNamedDefinitions(this, list, structureDefinition.getCriteriaDefinitions(), IStructureChild.StructureChildKind.INTRINSIC);
            StructureUtil.addOperationDefinitions(this, list, structureDefinition.getOperationDefinitions(), IStructureChild.StructureChildKind.INTRINSIC);
            this.children = DTRTUtil.toUnmodifiablePrunedList(list);
        }
        return this.children;
    }
}

