/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.BaseStructureChild;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import org.eclipse.core.resources.IFile;

final class StructureChildFolder
extends BaseStructureChild {
    private BaseDescriptor typeDescriptor;
    private String label;
    private List<IStructureChild> children = new ArrayList<IStructureChild>();

    public StructureChildFolder(IStructureObject parent, String label) {
        super(parent);
        if (DTRTUtil.isEmpty((String)label)) {
            throw new IllegalArgumentException("label cannot be empty");
        }
        this.label = label;
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            DTRTUtil.dispose(this.children);
            this.children = null;
        }
        this.typeDescriptor = null;
        super.dispose();
    }

    @Override
    protected String computeNonEncodedURISegment() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + '_' + this.label;
    }

    public IDescriptor getTypeDescriptor() {
        if (this.typeDescriptor == null) {
            this.typeDescriptor = StructureUtil.getDescriptor(Messages.folder, null, null);
        }
        return this.typeDescriptor;
    }

    public IDescriptor getSourceTypeDescriptor() {
        return null;
    }

    public String getId() {
        return this.label;
    }

    public IStructureChild.StructureChildKind getKind() {
        return IStructureChild.StructureChildKind.CONTAINER;
    }

    @Override
    protected String computeLabel() {
        return this.label;
    }

    @Override
    protected String computeToolTipText() {
        return Messages.folder;
    }

    @Override
    protected ImageManager.IImageData computeImageData() {
        return ImageManager.getInstance().getWorkbenchSharedImageData("IMG_OBJ_FOLDER");
    }

    public boolean canCustomize() {
        return false;
    }

    public boolean isCustomized() {
        return false;
    }

    public boolean isCustomizationFile(IFile file) {
        return false;
    }

    public List<? extends IStructure> getReferencedStructures() {
        return Collections.emptyList();
    }

    public void addChild(IStructureChild child) {
        this.children.add(child);
    }

    public void addChildren(Collection<? extends IStructureChild> children) {
        this.children.addAll(children);
    }

    public void freeze() {
        this.children = DTRTUtil.toUnmodifiablePrunedList(this.children);
    }

    public List<? extends IStructureChild> getChildren() {
        return this.children;
    }
}

