/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import java.util.LinkedHashSet;
import java.util.Set;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.ui.util.IOpenable;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.BaseStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionKey;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionStructureObjectData;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectType;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.osgi.util.NLS;

abstract class NamedDefinitionStructureObject<T extends NamedDefinition>
extends BaseStructureObject {
    private T namedDefinition;
    protected NamedDefinitionStructureObjectData data;

    public NamedDefinitionStructureObject(T namedDefinition) {
        if (namedDefinition == null) {
            throw new IllegalArgumentException("namedDefinition cannot be null");
        }
        this.namedDefinition = namedDefinition;
    }

    protected final void initialize() {
        this.data = this.createData();
        assert (this.data != null);
    }

    protected NamedDefinitionStructureObjectData createData() {
        return this.getStructureProvider().getNameDefinitionStructureObjectData(this);
    }

    @Override
    public void dispose() {
        this.namedDefinition = null;
        this.data = null;
        super.dispose();
    }

    @Override
    protected String computeNonEncodedURISegment() {
        return NamedDefinitionKey.computeNonEncodedURISegment(this.getNamedDefinition());
    }

    public final StructureObjectType getStructureObjectType() {
        if (!this.data.isStructureObjectTypeSet()) {
            this.data.setStructureObjectType(StructureObjectType.getStructureObjectType(this.getNamedDefinition()));
        }
        return this.data.getStructureObjectType();
    }

    public final T getNamedDefinition() {
        return this.namedDefinition;
    }

    public final BaseDescriptor getTypeDescriptor() {
        if (!this.data.isTypeDescriptorSet()) {
            StructureObjectType structureObjectType = this.getStructureObjectType();
            if (structureObjectType != null) {
                this.data.setTypeDescriptor(structureObjectType.getDescriptor());
            } else {
                this.data.setTypeDescriptor(StructureUtil.getDescriptor(NLS.bind((String)Messages.unknownType, (Object)((Object)((Object)this)).getClass().getSimpleName()), null, null));
            }
        }
        return this.data.getTypeDescriptor();
    }

    public final IDescriptor getSourceTypeDescriptor() {
        if (!this.data.isSourceTypeDescriptorSet()) {
            String label = this.computeSourceTypeDescriptorLabel();
            this.data.setSourceTypeDescriptor(StructureUtil.getDescriptor(label, null, null));
        }
        return this.data.getSourceTypeDescriptor();
    }

    protected abstract String computeSourceTypeDescriptorLabel();

    public final String getId() {
        String name = this.getNamedDefinition().getName();
        if (name == null && this.getStructureObjectType() == StructureObjectType.OPERATION_RETURN && StructureObjectType.getStructureObjectType(this.getParent()) == StructureObjectType.CONSTRUCTOR) {
            name = DTRTUtil.getLabel((IDescribable)this);
        }
        return name;
    }

    @Override
    protected final String computeLabel() {
        if (!this.data.isLabelSet()) {
            String label = (String)this.getNamedDefinition().getProperty("DTRT_StructureObject_Label");
            if (label == null) {
                label = this.doComputeLabel();
            }
            this.data.setLabel(label);
        }
        return this.data.getLabel();
    }

    protected String doComputeLabel() {
        return this.getNamedDefinition().getName();
    }

    @Override
    protected ImageManager.IImageData computeImageData() {
        if (!this.data.isImageDataSet()) {
            StructureObjectType structureObjectType = this.getStructureObjectType();
            this.data.setImageData(structureObjectType != null ? structureObjectType.getImageData() : null);
        }
        return this.data.getImageData();
    }

    @Override
    protected final int getCompareCategory() {
        if (!this.data.isCompareCategorySet()) {
            this.data.setCompareCategory(this.computeCompareCategory());
        }
        return this.data.getCompareCategory();
    }

    protected int computeCompareCategory() {
        return this.getStructureObjectType().getCompareCategory();
    }

    @Override
    public final Object getAdapter(Class adapter) {
        if (!this.isDisposed() && adapter != null) {
            if (IJavaElement.class.isAssignableFrom(adapter)) {
                IJavaElement javaElement = this.getJavaElement();
                return javaElement != null && adapter.isInstance(javaElement) ? javaElement : null;
            }
            if (adapter == IOpenable.class) {
                IOpenable[] openables = this.getOpenables();
                return openables.length > 0 ? openables[0] : null;
            }
            if (adapter == IOpenable[].class) {
                IOpenable[] openables = this.getOpenables();
                return openables.length > 0 ? openables : null;
            }
        }
        return super.getAdapter(adapter);
    }

    public final IJavaElement getJavaElement() {
        if (!this.data.isJavaElementSet()) {
            try {
                this.data.setJavaElement(this.computeJavaElement());
            }
            catch (CoreException e) {
                DTRTvBundle.log(e);
            }
        }
        return this.data.getJavaElement();
    }

    protected final Set<IOpenable> getOpenableSet() {
        return this.data.getOpenables();
    }

    protected abstract IJavaElement computeJavaElement() throws CoreException;

    protected abstract IFile getDeclarationFile();

    public final IOpenable[] getOpenables() {
        if (!this.data.isOpenablesSet()) {
            LinkedHashSet<IOpenable> set = new LinkedHashSet<IOpenable>(5);
            this.computeOpenables(set);
            this.data.setOpenables(new LinkedHashSet<IOpenable>(set));
        }
        this.adjustOpenables(this.data.getOpenables());
        return this.data.getOpenables().toArray(new IOpenable[this.data.getOpenables().size()]);
    }

    protected void adjustOpenables(Set<IOpenable> openables) {
    }

    protected abstract void computeOpenables(Set<IOpenable> var1);

    public final boolean isCustomized() {
        return this.getCustomization() != null && !this.getCustomization().isEmpty();
    }

    protected abstract StructureObjectCustomization getCustomization();
}

