/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure;

import java.util.Set;
import oracle.binding.meta.NamedDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.util.IOpenable;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.NamedDefinitionStructureObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureObjectCustomization;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;

abstract class NamedDefinitionStructureChild<T extends NamedDefinition>
extends NamedDefinitionStructureObject<T>
implements IStructureChild {
    private IStructureObject parent;
    private IStructureChild.StructureChildKind kind;

    public NamedDefinitionStructureChild(IStructureObject parent, T namedDefinition, IStructureChild.StructureChildKind kind) {
        super(namedDefinition);
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (kind == null) {
            throw new IllegalArgumentException("kind cannot be null");
        }
        this.parent = parent;
        this.kind = kind;
    }

    @Override
    public void dispose() {
        this.parent = null;
        this.kind = null;
        super.dispose();
    }

    public final IStructureObject getParent() {
        return this.parent;
    }

    public final IStructureChild.StructureChildKind getKind() {
        return this.kind;
    }

    @Override
    protected final IJavaElement computeJavaElement() {
        IType type;
        IStructure structure;
        if (this.getKind() == IStructureChild.StructureChildKind.INTRINSIC && (structure = DTRTObjectUtil.getStructure((IStructureObject)this)) != null && (type = (IType)DTRTUtil.getAdapter((IAdaptable)structure, IType.class)) != null) {
            try {
                return this.computeJavaElement(type);
            }
            catch (CoreException e) {
                DTRTvBundle.log(e);
            }
        }
        return null;
    }

    protected abstract IJavaElement computeJavaElement(IType var1) throws CoreException;

    @Override
    protected final IFile getDeclarationFile() {
        if (!this.data.isDeclarationFileSet()) {
            IStructure rootStructure = DTRTObjectUtil.getStructure((IStructureObject)this);
            if (this.getKind() == IStructureChild.StructureChildKind.EXTRINSIC) {
                IFile customizationFile = StructureObjectCustomization.getCustomizationFile(rootStructure);
                this.data.setDeclarationFile(customizationFile);
            } else {
                IStructure.IStructureSource source = rootStructure.getSource();
                if (source != null && source.getResource() instanceof IFile) {
                    this.data.setDeclarationFile((IFile)source.getResource());
                }
            }
            if (!this.data.isDeclarationFileSet()) {
                this.data.setDeclarationFile(null);
            }
        }
        return this.data.getdeclarationFile();
    }

    @Override
    protected void computeOpenables(Set<IOpenable> set) {
        IJavaElement javaElement;
        if (this.getDeclarationFile() != null) {
            set.add(StructureUtil.createDeclarationOpenable(this.getDeclarationFile()));
        }
        if ((javaElement = this.getJavaElement()) != null) {
            set.add(StructureUtil.createJavaOpenable(javaElement));
        }
    }
}

