/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adfdt.model.log.LogUtil;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.ParameterDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2.JdevUtils;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2.Project;

final class CreatableTypesHelper {
    private Project _project;
    private StructureDefinition _definition;
    private String _className;
    private Map _processedTypes;
    private List<String> _creatableTypes;

    public CreatableTypesHelper(StructureDefinition definition, Project project) {
        this._processedTypes = project._processedClassesOrTypes;
        this._creatableTypes = project._creatableClasses;
        this._definition = definition;
        if (this._definition != null) {
            this._className = this._definition.getFullName();
        }
    }

    public CreatableTypesHelper(Project project, StructureDefinition definition) {
        this._project = project;
        this._processedTypes = project._processedClassesOrTypes;
        this._creatableTypes = project._creatableClasses;
        this._definition = definition;
        if (this._definition != null) {
            this._className = this._definition.getFullName();
        }
    }

    private void addCreatableType(String type) {
        this._creatableTypes.add(type);
    }

    private void addProcessed(String type) {
        this._processedTypes.put(type, type);
    }

    public boolean hasProcessed(String type) {
        return this._processedTypes.get(type) != null;
    }

    public void clear() {
        this._processedTypes.clear();
        this._creatableTypes.clear();
    }

    public List<String> getCreatableTypes() {
        return this._creatableTypes;
    }

    public String getClassName() {
        return this._className;
    }

    public List<String> findCreatableTypes() throws Exception {
        if (this._className == null || this._definition == null || this.hasProcessed(this._className)) {
            return null;
        }
        this.addProcessed(this._className);
        this.findInAtributes();
        this.findInAccessors();
        this.findInMethods();
        this.findInBuiltInOperations();
        this.findInConstructors();
        this.findInProps();
        return this._creatableTypes;
    }

    private void findInAtributes() {
    }

    private void findInAccessors() throws Exception {
        for (AccessorDefinition accDef : this._definition.getAccessorDefinitions()) {
            if (accDef.getStructure() == null || !this.isInProject(accDef.getStructure())) continue;
            this.findInStructureDefinition(accDef.getStructure());
        }
    }

    private void findInMethods() {
        for (OperationDefinition operationDef : this._definition.getOperationDefinitions()) {
            AccessorDefinition returnType;
            if (operationDef.getOperationId() != 999) continue;
            if (operationDef.getOperationReturnType() != null && operationDef.getOperationReturnType().isAccessor() && !(returnType = (AccessorDefinition)operationDef.getOperationReturnType()).isScalarCollection() && this.isInProject(returnType.getStructure())) {
                this.findInStructureDefinition(returnType.getStructure());
            }
            for (ParameterDefinition paramDef : operationDef.getOperationParameters()) {
                if (!paramDef.isAccessor() || !this.isInProject(((AccessorDefinition)paramDef).getStructure())) continue;
                this.findInStructureDefinition(((AccessorDefinition)paramDef).getStructure());
            }
        }
    }

    private void findInBuiltInOperations() {
    }

    private void findInConstructors() {
        String sHideFromCreators;
        Iterator iter = this._definition.getConstructorOperationDefinitions().iterator();
        if (iter.hasNext() && ((sHideFromCreators = (String)this._definition.getProperty("__HIDE_FROM_CREATORS_LIST__")) == null || sHideFromCreators.equals(""))) {
            this.addCreatableType(this.getClassName());
        }
        while (iter.hasNext()) {
            OperationDefinition operationDef = (OperationDefinition)iter.next();
            if (operationDef.getOperationId() != 999) continue;
            for (ParameterDefinition paramDef : operationDef.getOperationParameters()) {
                if (!paramDef.isAccessor() || !this.isInProject(((AccessorDefinition)paramDef).getStructure())) continue;
                this.findInStructureDefinition(((AccessorDefinition)paramDef).getStructure());
            }
        }
    }

    private boolean isInProject(StructureDefinition def) {
        return def != null && JdevUtils.getJavaNode(this._project, def.getFullName()) != null;
    }

    public String findInStructureDefinition(StructureDefinition structDef) {
        try {
            if (structDef != null) {
                CreatableTypesHelper creatableTypes = new CreatableTypesHelper(structDef, this._project);
                creatableTypes.findCreatableTypes();
                return creatableTypes.getClassName();
            }
        }
        catch (Exception e) {
            LogUtil.getLogger().info((Throwable)e);
        }
        return null;
    }

    public static List<String> findCreatableTypes(Project project, StructureDefinition definition) {
        try {
            CreatableTypesHelper creatableTypes = new CreatableTypesHelper(project, definition);
            creatableTypes.clear();
            return creatableTypes.findCreatableTypes();
        }
        catch (Exception ex) {
            LogUtil.getLogger().throwing("oracle.adfdtinternal.model.ide.adapter.bean.CreatableTypesHelper", "findCreatableClasses", (Throwable)ex);
            return null;
        }
    }

    public static List<String> findCreatableTypes(StructureDefinition definition, Project project) {
        try {
            CreatableTypesHelper creatableTypes = new CreatableTypesHelper(definition, project);
            creatableTypes.clear();
            return creatableTypes.findCreatableTypes();
        }
        catch (Exception ex) {
            LogUtil.getLogger().throwing("oracle.adfdtinternal.model.ide.adapter.bean.CreatableTypesHelper", "findCreatableClasses", (Throwable)ex);
            return null;
        }
    }

    private void findInProps() {
        try {
            List creatableTypes = (List)this._definition.getProperty("CREATABLE_TYPES");
            if (creatableTypes != null) {
                for (String creatableType : creatableTypes) {
                    this.addCreatableType(creatableType);
                }
            }
        }
        catch (Exception e) {
            LogUtil.getLogger().throwing("oracle.adfdtinternal.model.ide.adapter.bean.CreatableTypesHelper", "findInProps", (Throwable)e);
            e.printStackTrace();
        }
    }
}

