/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2;

import java.util.List;
import oracle.adf.model.adapter.AbstractDefinition;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2.CreatableTypesHelper;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2.Project;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2.StructureDefinitionBuilder;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;

public final class BeanStructureBuilder {
    private BeanStructureBuilder() {
    }

    public static void build(IDTRTManager manager, JUDTAdapterDataControl dataControl) throws Exception {
        AbstractDefinition definition = (AbstractDefinition)dataControl.getNativeDataControlDefinition();
        List<String> creatableTypes = BeanStructureBuilder.handleBeanStructure(manager, definition);
        for (String creatableType : creatableTypes) {
            dataControl.addCreatableType(creatableType);
        }
    }

    private static List<String> handleBeanStructure(IDTRTManager manager, AbstractDefinition definition) throws Exception {
        StructureDefinition structureDefinition = definition.getStructure();
        assert (structureDefinition != null);
        return definition.useDefinitionProvider() ? BeanStructureBuilder.build(manager, structureDefinition) : BeanStructureBuilder.buildJSR227Beans(manager, structureDefinition);
    }

    private static List<String> buildJSR227Beans(IDTRTManager manager, StructureDefinition structureDefinition) throws Exception {
        Project project = new Project(manager);
        StructureDefinitionBuilder builder = new StructureDefinitionBuilder(structureDefinition, project);
        builder.build();
        project.dispose();
        return builder.getCreatableClasses();
    }

    private static List<String> build(IDTRTManager manager, StructureDefinition structureDefinition) throws Exception {
        Project project = new Project(manager);
        CreatableTypesHelper creatableTypes = new CreatableTypesHelper(project, structureDefinition);
        List<String> list = creatableTypes.findCreatableTypes();
        project.dispose();
        return list;
    }
}

