/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1;

import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.EngineConstants;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.JavaManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.Project;

final class EngineUtils
implements EngineConstants {
    public static boolean isComplex(String typeName) {
        String pack;
        if (typeName == null) {
            return false;
        }
        return !DTRTUtil.isEmpty((String)typeName) && !Project.isPrimitive(typeName) && (pack = EngineUtils.getPackage(typeName)) != null && !"java.lang".equals(pack) && !"java.math".equals(pack) && !"java.sql".equals(pack) && !"java.util".equals(pack);
    }

    public static boolean isCollection(JavaManager javaManager, String typeName) {
        Project project = (Project)javaManager;
        return !project.isArray(typeName) && project.isCollection(typeName);
    }

    public static boolean isArray(String type) {
        return type.indexOf(91) > 0;
    }

    public static String getShortName(String qualifiedClassName) {
        if (qualifiedClassName == null) {
            return null;
        }
        String genShortClassName = null;
        int genIndex = qualifiedClassName.indexOf(60);
        if (genIndex > 0) {
            String genClassName = qualifiedClassName.substring(genIndex + 1, qualifiedClassName.length() - 1);
            genShortClassName = EngineUtils.getShortName(genClassName);
            qualifiedClassName = qualifiedClassName.substring(0, genIndex);
        }
        String shortClassName = qualifiedClassName;
        int index = qualifiedClassName.lastIndexOf(46);
        if (index >= 0) {
            shortClassName = qualifiedClassName.substring(index + 1);
        }
        if (genIndex >= 0) {
            shortClassName = String.valueOf(shortClassName) + '<' + genShortClassName + '>';
        }
        return shortClassName;
    }

    public static String getGenericCollectionType(String type) {
        int genIndex = type.indexOf(60);
        if (genIndex > 0) {
            int endIndex = type.lastIndexOf(62);
            return endIndex > genIndex ? type.substring(genIndex + 1, endIndex) : type;
        }
        return null;
    }

    public static Object getJavaNode(Project project, String className) {
        return project.getClass(className);
    }

    private EngineUtils() {
    }

    private static String getPackage(String qualifiedClassName) {
        int index;
        if (qualifiedClassName == null) {
            return "";
        }
        int genIndex = qualifiedClassName.indexOf(60);
        if (genIndex > 0) {
            qualifiedClassName = qualifiedClassName.substring(0, genIndex - 1);
        }
        return (index = qualifiedClassName.lastIndexOf(46)) >= 0 ? qualifiedClassName.substring(0, index) : "";
    }
}

