/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1;

import java.beans.Introspector;
import java.lang.reflect.Modifier;
import java.util.List;
import oracle.adf.model.adapter.bean.annotation.AccessModeType;
import oracle.adf.model.adapter.bean.annotation.Properties;
import oracle.adf.model.adapter.bean.annotation.Property;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.FieldInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.MethodInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.Project;

final class BeanMethodInfo
extends MethodInfo {
    MethodInfo methodInfo;

    public BeanMethodInfo(MethodInfo methodInfo) {
        super(methodInfo);
        this.methodInfo = methodInfo;
    }

    public boolean isGetter() {
        return !Modifier.isStatic(this.modifiers) && (this.name.startsWith("get") && this.name.length() > 3 || ("boolean".equals(this.type) || "java.lang.Boolean".equals(this.type)) && this.name.startsWith("is") && this.name.length() > 2) && !Project.isVoid(this.type) && (this.parameters == null || this.parameters.size() == 0);
    }

    public boolean isSetter() {
        return !Modifier.isStatic(this.modifiers) && this.name.startsWith("set") && this.name.length() > 3 && Project.isVoid(this.type) && this.parameters != null && this.parameters.size() == 1;
    }

    public FieldInfo getField() {
        String type;
        String fieldName;
        if (this.isGetter()) {
            int index = this.name.startsWith("is") ? 2 : 3;
            fieldName = Introspector.decapitalize(this.name.substring(index));
            type = this.type;
        } else if (this.isSetter()) {
            assert (this.parameters != null);
            assert (this.parameters.size() == 1);
            fieldName = Introspector.decapitalize(this.name.substring(3));
            type = (String)((List)this.parameters.get(0)).get(0);
        } else {
            return null;
        }
        FieldInfo fieldInfo = this.findField(fieldName);
        if (fieldInfo == null) {
            fieldInfo = this.getProject().createSyntheticField(this, fieldName, type);
        }
        return fieldInfo;
    }

    public AccessModeType getAccessModeType() {
        AccessModeType accessModeType = this.getProject().getAccessModeType(this);
        return accessModeType != null ? accessModeType : AccessModeType.NO_PAGING;
    }

    public boolean isAnnotatedId() {
        return this.hasMethodOrFieldAnnotation("Id");
    }

    public boolean isEmbeddedID() {
        return this.hasMethodOrFieldAnnotation("EmbeddedId");
    }

    public boolean isAnnotatedGeneratedValue() {
        return this.hasMethodOrFieldAnnotation("GeneratedValue");
    }

    public <T extends Property> T findPropertyAnnotation() {
        return (T)this.getProject().getPropertyAnnotation(this);
    }

    public <T extends Properties> T findPropertiesAnnotation() {
        return (T)this.getProject().getPropertiesAnnotation(this);
    }

    public boolean isFieldUpdatable() {
        Object annotation = this.getProject().findAnnotation(this.getField(), "Column");
        if (annotation != null) {
            Object value = this.getProject().getAnnotationAttributeValue(annotation, "updatable");
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
        }
        return true;
    }

    private boolean hasMethodOrFieldAnnotation(String annotationName) {
        return this.getProject().findAnnotation(this, annotationName) != null || this.getProject().findAnnotation(this.getField(), annotationName) != null;
    }

    private FieldInfo findField(String fieldName) {
        FieldInfo fieldInfo;
        if (fieldName != null && (fieldInfo = this.getProject().getFieldInfo(this.declaringClassName, fieldName)) != null && this.getProject().isAssignableFrom(this.type, fieldInfo.type)) {
            return fieldInfo;
        }
        return null;
    }
}

