/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1;

import java.beans.Introspector;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.adapter.DTContext;
import oracle.adf.model.adapter.bean.annotation.Property;
import oracle.adf.model.adapter.bean.jpa.JPQLUtils;
import oracle.adf.model.adapter.dataformat.AccessorDef;
import oracle.adf.model.adapter.dataformat.AttributeDef;
import oracle.adf.model.adapter.dataformat.MethodDef;
import oracle.adf.model.adapter.dataformat.MethodReturnDef;
import oracle.adf.model.adapter.dataformat.ParamDef;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adf.model.utils.StandardOperationDef;
import oracle.adf.share.logging.ADFLogger;
import oracle.adfinternal.model.adapter.bean.BeanDCUtils;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.ParameterDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.binding.meta.criteria.Criteria;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.AdfModelIdeRes;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanCriteria;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDCDefinitionLoader;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDCHelper;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanMethodInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.ClassEngine;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.EngineUtils;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.FieldInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.JavaAnnotation;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.JavaClass;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.JavaManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.MethodEngine;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.MethodInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.Project;
import oracle.javatools.util.ModelUtil;

abstract class AbstractBeanDataControlProvider {
    public static final String ADFM_EXTENSION_ID = "oracle.adfm";
    private String _definitionClass;
    private boolean _recursive = true;
    private boolean _generateCollectionOperations = false;
    private Set<String> _ignoredClasses = new HashSet<String>();
    private List<String> _ignoredMethodNames = new ArrayList<String>();
    private DefinitionMap _defMap;
    private static final String ACCESSOR_ADD_METHOD = "AddMethod";
    private static final String ACCESSOR_REMOVE_METHOD = "RemoveMethod";
    private static final String _COMPOSITE_PRIMARY_KEYS = "_COMPOSITE_PRIMARY_KEYS";
    private static final String PERSIST_NAME = "persist";
    private static final String MERGE_NAME = "merge";
    private static final String ADD_NAME = "add";
    private static final String REMOVE_NAME = "remove";
    protected ADFLogger mLogger = DTContext.getInstance().getLogger();
    public static String BEAN_DC_PALETTE_SETTINGS = "Bean Data Control Palette Settings";
    public static String BEAN_DC_SHOW_CRUD_METHODS = "Show persist|merge|remove methods in DC Palette";
    private static boolean beanDCShowCRUDMethods = true;

    AbstractBeanDataControlProvider() {
    }

    public void setGenerateCollectionOperations(boolean bSet) {
        this._generateCollectionOperations = bSet;
    }

    public boolean generateCollectionOperations() {
        return this._generateCollectionOperations;
    }

    public void setRecursive(boolean recursive) {
        this._recursive = recursive;
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    public void setDefinitionClass(String definitionClass) {
        this._definitionClass = definitionClass;
    }

    public String getDefinitionClass() {
        return this._definitionClass;
    }

    public static boolean getBeanDCShowCRUDMethods() {
        return beanDCShowCRUDMethods;
    }

    public static void setBeanDCShowCRUDMethods(boolean value) {
        beanDCShowCRUDMethods = value;
    }

    protected boolean ignoredMethod(MethodInfo mi) {
        return this.getIgnoredMethodNames().contains(mi.name) || !AbstractBeanDataControlProvider.getBeanDCShowCRUDMethods() && (this.isCRUDSupportMethod(mi, PERSIST_NAME) || this.isCRUDSupportMethod(mi, MERGE_NAME) || this.isCRUDSupportMethod(mi, ADD_NAME) || this.isCRUDSupportMethod(mi, REMOVE_NAME));
    }

    private boolean isCRUDSupportMethod(MethodInfo mi, String crudType) {
        if (mi.name.startsWith(crudType) && mi.parameters != null && mi.parameters.size() == 1) {
            String shortType = EngineUtils.getShortName((String)((List)mi.parameters.get(0)).get(0));
            String entityType = mi.name.substring(crudType.length());
            if (entityType.equals(shortType) || entityType.equals("Entity")) {
                return true;
            }
        }
        return false;
    }

    protected void setIgnoredClass(String className) {
        if (!this._ignoredClasses.contains(className)) {
            this._ignoredClasses.add(className);
        }
    }

    protected Set<String> getIgnoredClasses() {
        return this._ignoredClasses;
    }

    protected void setIgnoredMethodNames(List<String> methodNames) {
        if (methodNames != null) {
            this._ignoredMethodNames.clear();
            this._ignoredMethodNames.addAll(methodNames);
        }
    }

    protected void setIgnoredMethodNames(String methodName) {
        if (!this._ignoredMethodNames.contains(methodName)) {
            this._ignoredMethodNames.add(methodName);
        }
    }

    protected List<String> getIgnoredMethodNames() {
        return this._ignoredMethodNames;
    }

    protected boolean createStructure(boolean subStructure) {
        return this.isRecursive() || subStructure;
    }

    protected void addUpdateableCollectionOperations(AccessorDef accessorDef) {
        if (this.generateCollectionOperations()) {
            accessorDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildUpdateableCollectionOperations());
        }
    }

    protected void addParameterizedCollectionOperations(AccessorDef accessorDef, BeanMethodInfo bmi) {
        if (this.generateCollectionOperations()) {
            StructureDef structureDef = BeanDCUtils.buildParameterizedCollectionOperations();
            this.addExecuteWIthParamInfo(accessorDef, bmi, structureDef);
            accessorDef.setCollectionStructure((StructureDefinition)structureDef);
        }
    }

    protected void addReadOnlyCollectionOperations(AccessorDef accessorDef) {
        if (this.generateCollectionOperations()) {
            accessorDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildReadOnlyCollectionOperations());
        }
    }

    protected void addScalarCollectionOperations(AccessorDef accessorDef) {
        if (this.generateCollectionOperations()) {
            accessorDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildScalarCollectionOperations());
        }
    }

    protected void addUpdateableCollectionOperations(MethodReturnDef returnDef) {
        if (this.generateCollectionOperations()) {
            returnDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildUpdateableCollectionOperations());
        }
    }

    protected void addReadOnlyCollectionOperations(MethodReturnDef returnDef) {
        if (this.generateCollectionOperations()) {
            returnDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildReadOnlyCollectionOperations());
        }
    }

    protected void addScalarCollectionOperations(MethodReturnDef returnDef) {
        if (this.generateCollectionOperations()) {
            returnDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildScalarCollectionOperations());
        }
    }

    protected void addSingleValueUpdateableOperations(AccessorDef accessorDef) {
        if (this.generateCollectionOperations()) {
            accessorDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildSingleValueUpdateableOperations());
        }
    }

    protected void addSingleValueParameterizedOperations(AccessorDef accessorDef, BeanMethodInfo bmi) {
        if (this.generateCollectionOperations()) {
            StructureDef structureDef = BeanDCUtils.buildSingleValueParamaterizedOperations();
            this.addExecuteWIthParamInfo(accessorDef, bmi, structureDef);
            accessorDef.setCollectionStructure((StructureDefinition)structureDef);
        }
    }

    private void addExecuteWIthParamInfo(AccessorDef accessorDef, BeanMethodInfo bmi, StructureDef structureDef) {
        StandardOperationDef def = (StandardOperationDef)structureDef.getOperationDefinitions().find(StandardOperationDef.getDefaultNameForId((int)95));
        if (def != null) {
            for (List param : bmi.parameters) {
                String pType = (String)param.get(0);
                String pName = (String)param.get(1);
                StringBuffer paramFullName = new StringBuffer();
                paramFullName.append(accessorDef.getStructure().getName());
                paramFullName.append(".variablesMap.");
                paramFullName.append(pName);
                def.addParameter(pName, pType, paramFullName.toString());
            }
        }
    }

    protected void addSingleValueReadOnlyOperations(AccessorDef accessorDef) {
        if (this.generateCollectionOperations()) {
            accessorDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildSingleValueReadOnlyOperations());
        }
    }

    protected void addSingleValueReadOnlyOperations(MethodReturnDef returnDef) {
        if (this.generateCollectionOperations()) {
            returnDef.setCollectionStructure((StructureDefinition)BeanDCUtils.buildSingleValueReadOnlyOperations());
        }
    }

    protected void addTransactionalOperations(StructureDef rootDCDef) {
        BeanDCUtils.addTransactionalOperations((StructureDef)rootDCDef);
    }

    protected StructureDef createStructureDef(Project project, String className) {
        return new StructureDef(className);
    }

    private void initialize() {
        this.setIgnoredMethodNames(Arrays.asList("main", "isEmpty", "queryByRange", "commitTransaction", "rollbackTransaction", "isTransactionDirty", "createSnapshot", "restoreSnapshot", "removeSnapshot", "beginRequest", "endRequest", "resetState", "setAttributeValue", "createRowData", "registerDataProvider", "removeRowData", "validate", "release", "invokeOperation"));
    }

    public StructureDefinition buildStructure(Project project, String className) {
        return this.buildStructure(project, className, this.isRecursive());
    }

    public StructureDefinition buildStructure(Project project, String className, boolean recursive) {
        this.initialize();
        this._defMap = new DefinitionMap(project, className);
        return this.findOrCreateStructureDef(className, this._defMap, recursive);
    }

    public List<String> getCreatableTypes() {
        return this._defMap != null ? this._defMap.creatableTypes : null;
    }

    private StructureDef findOrCreateStructureDef(String className, DefinitionMap defMap, boolean recursive) {
        StructureDef dcDef = null;
        if (this.createStructure(recursive)) {
            dcDef = defMap.getStructure(className);
        }
        if (dcDef == null) {
            dcDef = defMap.createDefinition(className);
            dcDef.getProperties().put("IsBeanBased", Boolean.toString(true));
            if (BeanDCUtils.isComplex((String)className)) {
                ClassEngine engine;
                JavaClass javaClass;
                if (defMap.isEmbeddedIdClass(className)) {
                    dcDef.addProperty(_COMPOSITE_PRIMARY_KEYS, (Object)Boolean.TRUE);
                }
                if ((javaClass = (engine = defMap.findOrCreateClassEngine(className)).getJavaClass()) == null) {
                    String msg = AdfModelIdeRes.format("Class {0} not found or not a valid JavaBean", engine.getClassName());
                    this.mLogger.severe(msg);
                }
                if (javaClass == null || javaClass.isInterface() || javaClass.isEnum()) {
                    dcDef.getProperties().put("__HIDE_FROM_CREATORS_LIST__", Boolean.toString(true));
                }
                if (this.createStructure(recursive)) {
                    this.addDefs(dcDef, defMap, this.isRootDef(className));
                }
            }
        }
        return dcDef;
    }

    private void addDefs(StructureDef dcDef, DefinitionMap defMap, boolean isRootDef) {
        ClassEngine classEngine = defMap.findOrCreateClassEngine(dcDef.getFullName());
        if (classEngine == null || this.ignoredType(classEngine.getClassName())) {
            return;
        }
        ArrayList<BeanMethodInfo> nonGetterMethods = new ArrayList<BeanMethodInfo>();
        ArrayList<FieldInfo> getterFields = new ArrayList<FieldInfo>();
        MethodInfo[] mis = classEngine.getMethods(false, this.getIgnoredClasses(), true);
        HashMap<String, AttributeDef> attrDefMap = new HashMap<String, AttributeDef>();
        JavaClass javaClass = classEngine.getJavaClass();
        boolean isInterface = javaClass.isInterface();
        int i = 0;
        while (i < mis.length) {
            MethodInfo mi = mis[i];
            BeanMethodInfo bmi = new BeanMethodInfo(mi);
            if ((isInterface || Modifier.isPublic(bmi.modifiers)) && (bmi.declaringClassName == null || this.shouldHaveMetaData(bmi.declaringClassName)) && !this.ignoredMethod(mi)) {
                if (isRootDef) {
                    defMap.addCreatableType(bmi.type);
                }
                if (bmi.isGetter()) {
                    getterFields.add(bmi.getField());
                    this.addStructureDef(dcDef, bmi, getterFields, attrDefMap, defMap);
                } else {
                    nonGetterMethods.add(bmi);
                }
            }
            ++i;
        }
        for (BeanMethodInfo bmi : nonGetterMethods) {
            this.addStructureDef(dcDef, bmi, getterFields, attrDefMap, defMap);
        }
        if (!isRootDef) {
            MethodInfo[] constructors = classEngine.getConstructorMethods(this.getIgnoredClasses(), true);
            int i2 = 0;
            while (i2 < constructors.length) {
                MethodInfo mi = constructors[i2];
                this.addConstructorMethodDef(dcDef, mi, defMap);
                ++i2;
            }
        }
    }

    private void addStructureDef(StructureDef dcDef, BeanMethodInfo bmi, List<FieldInfo> getterFields, Map<String, AttributeDef> attrDefMap, DefinitionMap defMap) {
        AttributeDef attrDef;
        ClassEngine classEngine = defMap.findOrCreateClassEngine(dcDef.getFullName());
        FieldInfo fi = null;
        TypeHelper accessorType = new TypeHelper(classEngine.getJavaManager(), classEngine.getJavaClass(), bmi);
        List parameters = bmi.parameters;
        bmi.parameters = accessorType.isComplex ? null : bmi.parameters;
        boolean isGetter = bmi.isGetter();
        if (isGetter) {
            fi = bmi.getField();
        }
        bmi.parameters = parameters;
        boolean isSetter = bmi.isSetter();
        if (isSetter) {
            FieldInfo setterFi = bmi.getField();
            for (FieldInfo getterFi : getterFields) {
                if (!ModelUtil.areEqual((Object)getterFi.name, (Object)setterFi.name) || !ModelUtil.areEqual((Object)getterFi.type, (Object)setterFi.type)) continue;
                fi = getterFi;
                break;
            }
            if (fi == null) {
                isSetter = false;
            }
        }
        String memberType = fi != null ? fi.type : bmi.type;
        accessorType = new TypeHelper(classEngine.getJavaManager(), classEngine.getJavaClass(), memberType);
        if (isGetter) {
            if (accessorType.isStrutureType()) {
                AccessorDef accessorDef;
                if (accessorType.isComplexType()) {
                    if (accessorType.allowMetaDataLookup()) {
                        boolean isKey = bmi.isEmbeddedID();
                        if (isKey) {
                            defMap.setEmbeddedIdClass(accessorType.elemType);
                        }
                        StructureDef structureDef = this.findOrCreateStructureDef(accessorType.elemType, defMap, this.isRecursive());
                        accessorDef = new AccessorDef(fi.name, (StructureDefinition)dcDef, isKey, accessorType.isArrayOrCollection());
                        accessorDef.setSourceTypeString(accessorType.elemType);
                        accessorDef.setStructure((StructureDefinition)structureDef);
                        if (accessorType.isCollection && !this.hasParameters(bmi)) {
                            this.addCriteriaDefinitionDef(accessorDef, defMap);
                        }
                    } else {
                        accessorDef = new AccessorDef(fi.name, (StructureDefinition)dcDef, accessorType.memberType, "element", accessorType.elemType);
                    }
                } else {
                    accessorDef = accessorType.elemType != null ? new AccessorDef(fi.name, (StructureDefinition)dcDef, accessorType.memberType, accessorType.elemType) : new AccessorDef(fi.name, (StructureDefinition)dcDef, accessorType.memberType, Object.class.getName());
                }
                if (accessorType.isCollection) {
                    if (accessorType.elemType != null) {
                        String methodName = this.getAddMethodName(classEngine.getClassName(), accessorType.elemShortType);
                        ArrayList<String> params = new ArrayList<String>();
                        params.add(accessorType.elemType);
                        if (methodName != null && MethodEngine.findMethod(classEngine, methodName, params) != null) {
                            accessorDef.addProperty(ACCESSOR_ADD_METHOD, (Object)methodName);
                        }
                        if ((methodName = this.getRemoveMethodName(classEngine.getClassName(), accessorType.elemShortType)) != null && MethodEngine.findMethod(classEngine, methodName, params) != null) {
                            accessorDef.addProperty(ACCESSOR_REMOVE_METHOD, (Object)methodName);
                        }
                    }
                    if (this.hasParameters(bmi)) {
                        this.addParameterizedCollectionOperations(accessorDef, bmi);
                    } else if (accessorDef.isScalarCollection()) {
                        this.addScalarCollectionOperations(accessorDef);
                    } else {
                        this.addUpdateableCollectionOperations(accessorDef);
                    }
                } else if (accessorType.isArray) {
                    this.addReadOnlyCollectionOperations(accessorDef);
                } else if (bmi.parameters != null && bmi.parameters.size() > 0) {
                    this.addSingleValueParameterizedOperations(accessorDef, bmi);
                } else {
                    this.addSingleValueUpdateableOperations(accessorDef);
                }
                dcDef.addAccessor((AccessorDefinition)accessorDef);
                attrDef = accessorDef;
            } else {
                boolean isReadOnly;
                boolean pk = bmi.isAnnotatedId() || this.isDefCompositePK(dcDef);
                boolean bl = isReadOnly = !bmi.isFieldUpdatable() || pk && bmi.isAnnotatedGeneratedValue();
                byte updateable = isReadOnly ? (byte)0 : (pk ? (byte)1 : 2);
                attrDef = new AttributeDef(fi.name, (StructureDefinition)dcDef, accessorType.elemType, isReadOnly, pk);
                attrDef.addProperty("UPDATEABLE_FLAG", (Object)new Byte(updateable));
                dcDef.addAttribute((AttributeDefinition)attrDef);
            }
            this.addProperties(attrDef, bmi);
            attrDefMap.put(fi.name, attrDef);
        } else if (isSetter && !(attrDef = attrDefMap.get(fi.name)).isKey()) {
            attrDef.setReadOnly(false);
        }
        if (fi == null) {
            TypeHelper returnType = new TypeHelper(classEngine.getJavaManager(), classEngine.getJavaClass(), bmi.type);
            MethodDef methDef = new MethodDef(bmi.name, (StructureDefinition)dcDef, this.nullIfVoid(returnType.getType()));
            if (returnType.isComplex) {
                MethodReturnDef methReturnDef;
                if (returnType.allowMetaDataLookup()) {
                    StructureDef returnDef = this.findOrCreateStructureDef(returnType.elemType, defMap, this.isRecursive());
                    methReturnDef = new MethodReturnDef(returnType.elemShortType, (StructureDefinition)returnDef, (OperationDefinition)methDef, returnType.isArrayOrCollection());
                } else {
                    methReturnDef = new MethodReturnDef(returnType.elemShortType, (OperationDefinition)methDef, returnType.memberType, "element", returnType.elemType);
                }
                if (returnType.isCollection) {
                    this.addUpdateableCollectionOperations(methReturnDef);
                } else if (returnType.isArray) {
                    this.addReadOnlyCollectionOperations(methReturnDef);
                } else {
                    this.addSingleValueReadOnlyOperations(methReturnDef);
                }
                methDef.setReturnType(methReturnDef);
            } else if (returnType.isArrayOrCollection()) {
                MethodReturnDef methReturnDef = returnType.elemType != null ? new MethodReturnDef(returnType.elemShortType, (OperationDefinition)methDef, returnType.memberType, returnType.elemType) : new MethodReturnDef("returnValue", returnType.memberType, (OperationDefinition)methDef, true);
                methDef.setReturnType(methReturnDef);
                if (methReturnDef.isScalarCollection()) {
                    this.addScalarCollectionOperations(methReturnDef);
                } else {
                    this.addUpdateableCollectionOperations(methReturnDef);
                }
            }
            if (bmi.parameters != null) {
                for (List param : bmi.parameters) {
                    ParamDef paramDef;
                    String pType = (String)param.get(0);
                    String pName = (String)param.get(1);
                    TypeHelper paramType = new TypeHelper(classEngine.getJavaManager(), classEngine.getJavaClass(), pType);
                    if (paramType.isComplex() && !paramType.isGeneric(paramType.getType()) && !paramType.isGeneric && this.shouldHaveMetaData(paramType.getType())) {
                        StructureDef structDef = this.findOrCreateStructureDef(paramType.getType(), defMap, this.isRecursive());
                        paramDef = new ParamDef(pName, (StructureDefinition)structDef, (OperationDefinition)methDef, paramType.isArrayOrCollection(), false);
                    } else {
                        paramDef = new ParamDef(pName, paramType.getType(), (OperationDefinition)methDef, paramType.isArrayOrCollection());
                    }
                    methDef.addParameter((ParameterDefinition)paramDef);
                }
            }
            dcDef.addMethod((OperationDefinition)methDef);
        }
    }

    private boolean hasParameters(BeanMethodInfo bmi) {
        return bmi.parameters != null && bmi.parameters.size() > 0;
    }

    private boolean isDefCompositePK(StructureDef def) {
        return BeanDCUtils.getBooleanProperty((NamedDefinition)def, (String)_COMPOSITE_PRIMARY_KEYS, (Boolean)false);
    }

    protected String getAddMethodName(String className, String accName) {
        return ADD_NAME + accName;
    }

    protected String getRemoveMethodName(String className, String accName) {
        return REMOVE_NAME + accName;
    }

    private void addConstructorMethodDef(StructureDef dcDef, MethodInfo mi, DefinitionMap defMap) {
        ClassEngine classEngine = defMap.findOrCreateClassEngine(dcDef.getFullName());
        MethodDef methDef = new MethodDef(mi.name, (StructureDefinition)dcDef, true);
        methDef.setReturnType((StructureDefinition)dcDef);
        if (mi.parameters != null) {
            for (List param : mi.parameters) {
                ParamDef paramDef;
                String pType = (String)param.get(0);
                String pName = (String)param.get(1);
                TypeHelper paramType = new TypeHelper(classEngine.getJavaManager(), classEngine.getJavaClass(), pType);
                if (paramType.isComplex() && !paramType.isGeneric(paramType.getType()) && !paramType.isGeneric && this.shouldHaveMetaData(paramType.getType())) {
                    StructureDef structDef = this.findOrCreateStructureDef(paramType.getType(), defMap, this.isRecursive());
                    paramDef = new ParamDef(pName, (StructureDefinition)structDef, (OperationDefinition)methDef, paramType.isArrayOrCollection(), false);
                } else {
                    paramDef = new ParamDef(pName, paramType.getType(), (OperationDefinition)methDef, paramType.isArrayOrCollection());
                }
                methDef.addParameter((ParameterDefinition)paramDef);
            }
        }
        dcDef.addConstructorMethod((OperationDefinition)methDef);
    }

    private void addCriteriaDefinitionDef(AccessorDef accessorDef, DefinitionMap defMap) {
        JavaAnnotation annoEntity;
        StructureDef dcDef = (StructureDef)accessorDef.getStructure();
        if (dcDef == null || !accessorDef.isCollection()) {
            return;
        }
        ClassEngine classEngine = defMap.findOrCreateClassEngine(dcDef.getFullName());
        JavaClass jc = classEngine.getJavaClass();
        if (jc != null && (annoEntity = BeanDCHelper.findJavaAnnotation("javax.persistence.Entity", jc.getAnnotations())) != null) {
            String entityName = BeanDCHelper.getJavaAnnotationAttr(annoEntity, "name");
            if (entityName == null || entityName.isEmpty()) {
                entityName = BeanDCUtils.getShortName((String)classEngine.getClassName());
            }
            String stmt = this.findNamedQueryStmt(entityName, accessorDef.getName(), jc.getAnnotations());
            BeanCriteria beanCriteria = BeanDCDefinitionLoader.createBeanCriteriaDef((StructureDefinition)dcDef);
            beanCriteria.setProperty(BeanCriteria.DATA_FILTER_PREVIEW, stmt);
            dcDef.addCriteria((Criteria)beanCriteria);
        }
    }

    private String findNamedQueryStmt(String entityName, String accessorName, Collection<JavaAnnotation> annotations) {
        Map<String, ?> jaMap;
        JavaAnnotation namedQueries = BeanDCHelper.findJavaAnnotation("NamedQueries", annotations);
        if (namedQueries != null && !(jaMap = namedQueries.getComponents()).isEmpty()) {
            Object[] objs;
            Map.Entry<String, ?> entry = jaMap.entrySet().iterator().next();
            Object[] objectArray = objs = (Object[])entry.getValue();
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                JavaAnnotation ja = (JavaAnnotation)o;
                String name = BeanDCHelper.getJavaAnnotationAttr(ja, "name");
                if (this.makeAccessorName(name).equals(accessorName)) {
                    return BeanDCHelper.getJavaAnnotationAttr(ja, "query");
                }
                ++n2;
            }
        }
        return entityName != null ? JPQLUtils.getDefaultStmt((String)entityName) : null;
    }

    private String makeAccessorName(String name) {
        String pkg = BeanDCUtils.getPackage((String)name);
        if (!pkg.isEmpty()) {
            return String.valueOf(Introspector.decapitalize(pkg)) + BeanDCUtils.capitalize((String)BeanDCUtils.getShortName((String)name));
        }
        return name;
    }

    private void addProperties(AttributeDef attrDef, BeanMethodInfo mi) {
        if (mi == null) {
            return;
        }
        Object property = mi.findPropertyAnnotation();
        if (property != null) {
            attrDef.addProperty(property.name(), (Object)property.value());
        }
        Object props = mi.findPropertiesAnnotation();
        if (attrDef != null && mi != null && props != null) {
            int i = 0;
            while (i < props.value().length) {
                Property p = props.value()[i];
                attrDef.addProperty(p.name(), (Object)p.value());
                ++i;
            }
        }
    }

    private String nullIfVoid(String type) {
        return "java.lang.Void".equals(type) ? null : type;
    }

    private boolean ignoredType(String className) {
        return className == null || className.length() <= 1 || !this.shouldHaveMetaData(className);
    }

    private boolean shouldHaveMetaData(String type) {
        return !this.getIgnoredClasses().contains(type);
    }

    private boolean isRootDef(String className) {
        return className == null ? false : className.equals(this.getDefinitionClass());
    }

    class DefinitionMap {
        Map<String, StructureDef> classNameToStructureDefMap;
        Map<String, ClassEngine> classNameToClassEngineMap = new HashMap<String, ClassEngine>();
        List<String> embeddedIdList = new ArrayList<String>();
        List<String> idClassList = new ArrayList<String>();
        List<String> creatableTypes = new ArrayList<String>();
        Project project;
        String className;

        DefinitionMap(Project project, String className) {
            this.project = project;
            this.className = className;
            this.classNameToClassEngineMap.put(className, new ClassEngine(project, className));
        }

        StructureDef createDefinition(String className) {
            StructureDef def = null;
            if (AbstractBeanDataControlProvider.this.isRecursive()) {
                def = this.getStructure(className);
            }
            if (def == null) {
                def = AbstractBeanDataControlProvider.this.createStructureDef(this.project, className);
                if (AbstractBeanDataControlProvider.this.isRecursive()) {
                    if (this.classNameToStructureDefMap == null) {
                        this.classNameToStructureDefMap = new HashMap<String, StructureDef>();
                    }
                    this.classNameToStructureDefMap.put(className, def);
                }
            }
            this.setIdClass(className);
            return def;
        }

        ClassEngine findOrCreateClassEngine(String className) {
            ClassEngine classEngine = this.classNameToClassEngineMap.get(className);
            if (classEngine == null) {
                classEngine = new ClassEngine(this.project, className);
                this.classNameToClassEngineMap.put(className, classEngine);
            }
            return classEngine;
        }

        StructureDef getStructure(String className) {
            return this.classNameToStructureDefMap != null ? this.classNameToStructureDefMap.get(className) : null;
        }

        void addCreatableType(String type) {
            ClassEngine classEngine = this.classNameToClassEngineMap.get(this.className);
            if (classEngine != null) {
                TypeHelper typeHelper = new TypeHelper(classEngine.getJavaManager(), classEngine.getJavaClass(), type);
                if (typeHelper.isComplex && !typeHelper.isGeneric && AbstractBeanDataControlProvider.this.shouldHaveMetaData(typeHelper.elemType) && EngineUtils.getJavaNode(this.project, typeHelper.elemType) != null && !this.creatableTypes.contains(typeHelper.elemType) && !this.findOrCreateClassEngine(typeHelper.elemType).getJavaClass().isInterface()) {
                    this.creatableTypes.add(typeHelper.elemType);
                }
            }
        }

        void setEmbeddedIdClass(String className) {
            JavaManager javaManager = JavaManager.getJavaManager(this.project);
            JavaClass jClass = javaManager.getClass(className);
            if (jClass == null) {
                return;
            }
            if (!this.embeddedIdList.contains(className) && jClass.getAnnotation(javaManager.getClass("javax.persistence.Embeddable")) != null) {
                this.embeddedIdList.add(className);
            }
        }

        boolean isEmbeddedIdClass(String className) {
            return this.embeddedIdList.contains(className);
        }

        void setIdClass(String className) {
            JavaManager javaManager = JavaManager.getJavaManager(this.project);
            JavaClass jClass = javaManager.getClass(className);
            if (jClass == null) {
                return;
            }
            if (!this.idClassList.contains(className) && jClass.getAnnotation(javaManager.getClass("javax.persistence.IdClass")) != null) {
                this.idClassList.add(className);
            }
        }

        boolean isIdClass(String className) {
            return this.idClassList.contains(className);
        }
    }

    class TypeHelper {
        boolean isCollection;
        boolean isArray;
        boolean isComplex;
        boolean isGeneric;
        boolean isEnum;
        String elemType;
        String elemShortType;
        String memberType;
        private String _type;
        private JavaManager _javaMgr;
        private JavaClass _javaClass;
        static final String elementName = "element";
        static final String returnValue = "returnValue";

        TypeHelper(JavaManager javaMgr, JavaClass javaClass, BeanMethodInfo bmi) {
            this(javaMgr, javaClass, bmi.type);
        }

        TypeHelper(JavaManager javaMgr, JavaClass javaClass, String type) {
            this._javaMgr = javaMgr;
            this._javaClass = javaClass;
            this._type = type;
            this.isCollection = ((Project)javaMgr).isCollection(type);
            this.isArray = BeanDCUtils.isArray((String)type);
            this.elemType = this.getElemType();
            this.elemShortType = BeanDCUtils.getShortName((String)this.elemType);
            this.memberType = this.getMemberType(type, this.isCollection, this.isArray);
            this.isComplex = BeanDCUtils.isComplex((String)this.elemType);
            JavaClass elemClass = javaMgr.getClass(this.elemType);
            if (elemClass != null) {
                this.isEnum = elemClass.isEnum();
            }
            if (this.isComplex) {
                this.isGeneric = elemClass == null || this.elemType.indexOf(60) > 0;
            }
        }

        public boolean isArrayOrCollection() {
            return this.isCollection || this.isArray;
        }

        public boolean isComplex() {
            return this.isComplex && !this.isArray;
        }

        public String getElemType() {
            String elemType = this._type;
            if (this.isCollection) {
                int index;
                String genericType = BeanDCUtils.getGenericCollectionType((String)this._type);
                if (genericType != null) {
                    elemType = genericType;
                }
                if (elemType != null && (index = elemType.indexOf(44)) > 0) {
                    elemType = elemType.substring(0, index);
                }
            } else {
                elemType = BeanDCUtils.getType((String)this._type);
            }
            if (ModelUtil.hasLength((String)elemType) && elemType.indexOf(".") < 0 && this._javaMgr.getClass(elemType) == null) {
                elemType = "java.lang.Object";
            }
            return elemType;
        }

        public String getType() {
            String type = this._type;
            int index = type.indexOf(60);
            if (index > 0) {
                type = type.substring(0, index);
            }
            if (ModelUtil.hasLength((String)type) && type.indexOf(".") < 0 && this._javaMgr.getClass(type) == null) {
                String arrayPrefix = null;
                int arrayIndex = type.lastIndexOf(91);
                if (arrayIndex > 0 && type.indexOf(62, arrayIndex) < 0) {
                    arrayPrefix = type.substring(arrayIndex);
                }
                type = "java.lang.Object";
                if (arrayPrefix != null) {
                    type = String.valueOf(type) + arrayPrefix;
                }
            }
            return type;
        }

        public boolean isGeneric() {
            return this.isGeneric(this.elemType);
        }

        public boolean isGeneric(String type) {
            return type != null && type.length() > 0 && (type.startsWith("?") || this._javaClass.getTypeParameter(type) != null);
        }

        public boolean isStrutureType() {
            return this.isArray || this.isCollection || this.isComplex && !this.isEnum;
        }

        public boolean isComplexType() {
            return this.isComplex && !this.isEnum;
        }

        public boolean allowMetaDataLookup() {
            return !this.isGeneric && AbstractBeanDataControlProvider.this.shouldHaveMetaData(this.elemType);
        }

        private String getMemberType(String memberType, boolean isCollection, boolean isArray) {
            int index;
            if (isCollection && (index = memberType.indexOf(60)) > 0) {
                memberType = memberType.substring(0, index).trim();
            }
            if (ModelUtil.hasLength((String)memberType) && memberType.indexOf(".") < 0 && this._javaMgr.getClass(memberType) == null) {
                memberType = "java.lang.Object";
            }
            return memberType;
        }
    }
}

