/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import oracle.adf.model.adapter.AbstractDefinition;
import oracle.adf.model.adapter.DataControlFactoryImpl;
import oracle.adf.model.adapter.bean.BeanDCHandler;
import oracle.adf.model.adapter.bean.BeanDefinition;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adfdt.model.datacontrols.JUDTAdapterDataControl;
import oracle.adfdt.model.objects.Configuration;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfinternal.model.adapter.generic.DataControlStructure;
import oracle.adfinternal.model.adapter.generic.DataControlStructureImpl;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.common.JRFVersion;
import oracle.eclipse.tools.adf.common.technology.ADFCommonTechnologyExtension;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.context.command.IStructureCommand;
import oracle.eclipse.tools.adf.dtrt.jdt.IMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.MemberFilterUtil;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreationInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.IDataControlSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.ISourceHandler;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.Messages;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev1.BeanDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.jdev2.BeanStructureBuilder;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class JavaHandler<I extends IDataControlSourceInfo>
implements ISourceHandler,
BeanDataControlProvider.IProviderInfo {
    protected static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    protected static final IMemberFilter[] SUPPORTS_EAGER_PERSIST_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder().findMethod("persistEntity", new String[]{Object.class.getName()}), new MemberFilterUtil.MemberFinder().findMethod("commitTransaction", new String[0]), new MemberFilterUtil.MaximumNumberOfIncludedMembers(2)};
    private I sourceInfo;
    private boolean generateCollectionOperations;
    private boolean recursiveBeanBuild;

    protected JavaHandler(I sourceInfo) {
        assert (sourceInfo != null);
        this.sourceInfo = sourceInfo;
    }

    @Override
    public void dispose() {
        this.sourceInfo = null;
    }

    @Override
    public final boolean isGenerateCollectionOperations() {
        return this.generateCollectionOperations;
    }

    @Override
    public final boolean isRecursiveBeanBuild() {
        return this.recursiveBeanBuild;
    }

    protected final I getSourceInfo() {
        return this.sourceInfo;
    }

    @Override
    public void assertExecution(IStructureCommand command) throws Exception {
        DTRTUtil.assertTrue((this.getJavaProject() != null ? 1 : 0) != 0, (String)Messages.unknownJavaProject);
        if (command instanceof CreateDataControlCommand) {
            CreateDataControlCommand createDataControlCommand = (CreateDataControlCommand)command;
            this.assertCreateCommandExecution();
            this.handleDataControlId(createDataControlCommand, (IDataControlSourceInfo)this.getSourceInfo());
        }
    }

    protected abstract void assertCreateCommandExecution();

    public static String validateTypeAsDataControl(boolean forLoading, IType type) {
        try {
            if (type == null) {
                return Messages.unknownSourceType;
            }
            if (!forLoading) {
                if (!type.isClass()) {
                    return Messages.invalidType;
                }
                if (type.getDeclaringType() != null) {
                    return Messages.cannotBeInnerClass;
                }
                if (type.isAnonymous()) {
                    return Messages.cannotBeAnonType;
                }
                if (Flags.isAbstract((int)type.getFlags())) {
                    return Messages.cannotBeAbstract;
                }
                boolean hasPublicDefaultConstructor = true;
                IMethod[] iMethodArray = type.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    if (method.isConstructor()) {
                        if (method.getParameters().length == 0 && Flags.isPublic((int)method.getFlags())) {
                            hasPublicDefaultConstructor = true;
                            break;
                        }
                        hasPublicDefaultConstructor = false;
                    }
                    ++n2;
                }
                if (!hasPublicDefaultConstructor) {
                    return Messages.missingDefaultPublicConstructor;
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected final void handleDataControlId(CreateDataControlCommand command, IDataControlSourceInfo sourceInfo) {
        String id = command.getDataControlId();
        if (id == null) {
            command.setDataControlId(DTRTvContextUtil.computeUniqueId((IOEPEContext)command.getCommandStack(), IDataControl.class, sourceInfo.getBaseDataControlId(), command.getDataControlType()));
        } else {
            IStatus status = DTRTvContextUtil.isValidObjectId(IDataControl.class, id);
            DTRTUtil.assertTrue((boolean)status.isOK(), (String)NLS.bind((String)Messages.invalidDataControlId, (Object)status.getMessage()));
            try {
                DTRTUtil.assertTrue((DTRTObjectUtil.find((Collection)command.getCommandStack().getDataControls(null), (String)id) == null ? 1 : 0) != 0, (String)NLS.bind((String)Messages.existingDataControl, (Object)id));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected final StructureDef loadStructure(JUDTAdapterDataControl dataControl, IType type) throws Exception {
        this.recursiveBeanBuild = false;
        this.generateCollectionOperations = true;
        IDTRTManager manager = DTRTvUtil.getManager((DataControl)dataControl);
        return BeanDataControlProvider.loadStructureDef(manager, dataControl, type, this);
    }

    protected final IDataControl createDataControl(IType type, CreateDataControlCommand command, IProgressMonitor monitor) throws Exception {
        assert (command != null);
        IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)command.getCommandStack());
        assert (manager.getProject().equals((Object)this.getJavaProject().getProject()));
        this.recursiveBeanBuild = false;
        this.generateCollectionOperations = false;
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
        DataControlStructure dataControlStructure = this.createDataControlStructure(manager, command.getCreationInfo(), type, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        assert (dataControlStructure != null);
        ProgressMonitorUtil.checkIfCanceled((IProgressMonitor)monitor);
        DataControl dataControl = this.createDataControl(manager, command, this.createDefinition(dataControlStructure), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        assert (dataControl != null);
        this.adjustDataControl(command, dataControl);
        ProgressMonitorUtil.done((IProgressMonitor)monitor);
        IObjectTranslator translator = OEPEContextImpl.getTranslator((IOEPEContext)command.getCommandStack());
        return (IDataControl)translator.fromADFObject((Object)dataControl, IDataControl.class);
    }

    protected void adjustDataControl(CreateDataControlCommand command, DataControl dataControl) {
    }

    private DataControlStructure createDataControlStructure(IDTRTManager manager, CreationInfo creationInfo, IType type, IProgressMonitor monitor) throws Exception {
        Pair<StructureDefinition, List<String>> pair = BeanDataControlProvider.buildStructure(manager, type, this);
        assert (pair != null);
        StructureDefinition structureDefinition = (StructureDefinition)pair.getFirst();
        assert (structureDefinition != null);
        this.adjustStructureDefinition(creationInfo, structureDefinition, (List)pair.getSecond());
        Node runtimeSettings = this.getRuntimeSettings(manager.getTypeHelper(), creationInfo, type);
        return new DataControlStructureImpl(type.getElementName(), runtimeSettings, structureDefinition);
    }

    private void adjustStructureDefinition(CreationInfo creationInfo, StructureDefinition structureDefinition, List<String> creatableTypes) throws Exception {
        Hashtable props = structureDefinition.getProperties();
        props.put("__IS_COLLECTIONBEANCLASS__", Boolean.toString(this.isGenerateCollectionOperations()));
        props.put("CREATABLE_TYPES", creatableTypes);
        if (creationInfo != null) {
            props.put("GENERATE_DC_METADATA", Boolean.toString(creationInfo.isGenerateMetadata()));
            props.put("_SupportsCriteria", Boolean.toString(creationInfo.isQueryMethodSupported()));
            props.put("_SupportsTransaction", Boolean.toString(creationInfo.isTransactionalDCSupported()));
        }
    }

    @Override
    public Collection<String> getIgnoredClassNames() {
        return Collections.emptyList();
    }

    protected abstract IJavaProject getJavaProject();

    protected abstract Node getRuntimeSettings(ITypeHelper var1, CreationInfo var2, IType var3) throws Exception;

    protected abstract AbstractDefinition createDefinition(DataControlStructure var1);

    protected final void assignAttr(Element metaData, String key, String value) {
        if (!DTRTUtil.isEmpty((String)value)) {
            metaData.setAttributeNS(null, key, value);
        }
    }

    private DataControl createDataControl(IDTRTManager manager, ICreateDataControlCommand command, AbstractDefinition definition, IProgressMonitor monitor) throws Exception {
        Configuration configuration = manager.getLocalConfiguration(true);
        DataControl dataControl = configuration.findDataControl(command.getDataControlId());
        if (dataControl != null) {
            throw new IllegalStateException(NLS.bind((String)Messages.existingDataControl, (Object)command.getDataControlId()));
        }
        dataControl = this.createDataControl(manager, configuration, definition, command.getDataControlId());
        assert (dataControl != null);
        return dataControl;
    }

    private DataControl createDataControl(IDTRTManager manager, Configuration configuration, AbstractDefinition definition, String id) throws Exception {
        IVersion version;
        JUDTAdapterDataControl dataControl = new JUDTAdapterDataControl();
        Element dataControlElement = configuration.getDocument().createElementNS(dataControl.getNameSpaceUrl(), dataControl.getXMLElementTag());
        dataControl.initializeFromElement(configuration.getTransactionManager(), dataControlElement);
        dataControl.setId(id);
        dataControl.initializeFromDef(definition);
        IProject project = this.getJavaProject().getProject();
        assert (project != null);
        boolean resetFactoryClass = true;
        ADFCommonTechnologyExtension techExt = new ADFCommonTechnologyExtension((Project)project.getAdapter(Project.class), null);
        JRFVersion jrfVersion = techExt.getJRFVersion();
        if (jrfVersion != null && (version = jrfVersion.getVersion()) != null && version.compareTo((Object)new JRFVersion("11.1.1.7.0").getVersion()) >= 0) {
            resetFactoryClass = false;
        }
        if (resetFactoryClass) {
            dataControl.setFactoryClass(DataControlFactoryImpl.class.getName());
        }
        if (definition.getCachingMode() == 0) {
            BeanStructureBuilder.build(manager, dataControl);
        }
        dataControl.setDefinitionClass(definition.getStructure().getFullName());
        configuration.addDataControl((DataControl)dataControl);
        return configuration.findDataControl(id);
    }

    @Override
    public final boolean ignoreMethod(String name, String returnType) {
        return this.isQueryByRangeMethod(name, returnType);
    }

    protected final boolean isQueryByRangeMethod(String name, String returnType) {
        return !Void.class.getName().equals(returnType) && "queryByRange".equals(name);
    }

    protected final void supportsDataControlHandler(CreationInfo creationInfo, Element metaData) {
        if (creationInfo != null && creationInfo.isQueryMethodSupported() && creationInfo.isPaginationSupported()) {
            this.assignAttr(metaData, "DataControlHandler", BeanDefinition.JPQLDataControlHandlerName);
        } else if (creationInfo != null && (creationInfo.isQueryMethodSupported() || creationInfo.isPaginationSupported())) {
            this.assignAttr(metaData, "DataControlHandler", BeanDefinition.DataFilterHandlerName);
        } else {
            this.assignAttr(metaData, "DataControlHandler", BeanDCHandler.class.getName());
        }
    }

    protected final void supportsAccessMode(CreationInfo creationInfo, Element metaData) {
        if (creationInfo != null) {
            if (creationInfo.getAccessMode() == 1) {
                this.assignAttr(metaData, "AccessMode", "scrollable");
            } else if (creationInfo.getAccessMode() == 4) {
                this.assignAttr(metaData, "AccessMode", "rangePaging");
            }
        }
    }
}

