/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.io.Serializable;
import oracle.binding.AttributeContext;
import oracle.binding.RowContext;
import oracle.eclipse.tools.adf.dtrt.jdt.IMemberFilter;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.JavaCodeManipulationHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.MemberFilterUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;

class DataControlCreationHelper {
    private static final String isTransactionDirty = "isTransactionDirty";
    private static final String isTransactionDirtyMethod = "public boolean isTransactionDirty() {return false; }";
    private static final String rollbackTransaction = "rollbackTransaction";
    private static final String rollbackTransactionMethod = "public void rollbackTransaction() { }";
    private static final String commitTransaction = "commitTransaction";
    private static final String commitTransactionMethod = "public void commitTransaction() { }";
    private static final String setAttributeValue = "setAttributeValue";
    private static final String setAttributeValueMethod = "public boolean setAttributeValue(AttributeContext attributeContext, Object object) {return false; }";
    private static final String createRowData = "createRowData";
    private static final String createRowDataMethod = "public Object createRowData(RowContext rowContext) {return null;}";
    private static final String registerDataProvider = "registerDataProvider";
    private static final String registerDataProviderMethod = "public Object registerDataProvider(RowContext rowContext) {return null;}";
    private static final String removeRowData = "removeRowData";
    private static final String removeRowDataMethod = "public boolean removeRowData(RowContext rowContext) {return false;}";
    private static final String validate = "validate";
    private static final String validateMethod = "public void validate() { }";
    private static final String createSnapshot = "createSnapshot";
    private static final String createSnapshotMethod = "public Serializable createSnapshot() {return null;}";
    private static final String restoreSnapshot = "restoreSnapshot";
    private static final String restoreSnapshotMethod = "public void restoreSnapshot(Serializable serializable) { }";
    private static final String removeSnapshot = "removeSnapshot";
    private static final String removeSnapshotMethod = "public void removeSnapshot(Serializable serializable) { }";
    private static final String queryByRange = "queryByRange";
    private static final IMemberFilter[] SUPPORTS_TRANSACTION_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder().findMethod("commitTransaction", new String[0]), new MemberFilterUtil.MemberFinder().findMethod("isTransactionDirty", new String[0]), new MemberFilterUtil.MemberFinder().findMethod("rollbackTransaction", new String[0]), new MemberFilterUtil.MaximumNumberOfIncludedMembers(3)};
    private static final IMemberFilter[] SUPPORTS_QUERY_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("queryByRange", new String[]{String.class.getName(), "int", "int"})};
    private static final IMemberFilter[] HAS_ROLLBACK_TRANSACTION_METHOD_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("rollbackTransaction", new String[0])};
    private static final IMemberFilter[] HAS_IS_DIRTY_TRANSACTION_METHOD_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("isTransactionDirty", new String[0])};
    private static final IMemberFilter[] HAS_COMMIT_TRANSACTION_METHOD_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("commitTransaction", new String[0])};
    private static final IMemberFilter[] SUPPORTS_MANAGED_DC_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder().findMethod("createSnapshot", new String[0]), new MemberFilterUtil.MemberFinder().findMethod("restoreSnapshot", new String[]{Serializable.class.getName()}), new MemberFilterUtil.MemberFinder().findMethod("removeSnapshot", new String[]{Serializable.class.getName()}), new MemberFilterUtil.MaximumNumberOfIncludedMembers(3)};
    private static final IMemberFilter[] HAS_REMOVE_SNAPSHOT_METHOD_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("removeSnapshot", new String[]{Serializable.class.getName()})};
    private static final IMemberFilter[] HAS_RESTORE_SNAPSHOT_METHOD_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("restoreSnapshot", new String[]{Serializable.class.getName()})};
    private static final IMemberFilter[] HAS_CREATE_SNAPSHOT_METHOD_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("createSnapshot", new String[0])};
    private static final IMemberFilter[] SUPPORTS_UPDATEABLE_DC_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder().findMethod("setAttributeValue", new String[]{AttributeContext.class.getName(), Object.class.getName()}), new MemberFilterUtil.MemberFinder().findMethod("createRowData", new String[]{RowContext.class.getName()}), new MemberFilterUtil.MemberFinder().findMethod("registerDataProvider", new String[]{RowContext.class.getName()}), new MemberFilterUtil.MemberFinder().findMethod("removeRowData", new String[]{RowContext.class.getName()}), new MemberFilterUtil.MemberFinder().findMethod("validate", new String[0]), new MemberFilterUtil.MaximumNumberOfIncludedMembers(5)};
    private static final IMemberFilter[] HAS_SET_ATTRIBUTE_VALUE_METHOD_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("setAttributeValue", new String[]{AttributeContext.class.getName(), Object.class.getName()})};
    private static final IMemberFilter[] HAS_VALIDATE_METHOD_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("validate", new String[0])};
    private static final IMemberFilter[] HAS_REMOVE_ROW_DATA_METHOD_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("removeRowData", new String[]{RowContext.class.getName()})};
    private static final IMemberFilter[] HAS_REGISTER_DATA_PROVIDER_METHOD_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("registerDataProvider", new String[]{RowContext.class.getName()})};
    private static final IMemberFilter[] HAS_CREATE_ROW_DATA_METHOD_FILTER = new IMemberFilter[]{MemberFilterUtil.EXCLUDE_NOT_PUBLIC, MemberFilterUtil.EXCLUDE_NOT_ACCESSIBLE_SUPER_MEMBERS, new MemberFilterUtil.MemberFinder(true).findMethod("createRowData", new String[]{RowContext.class.getName()})};

    DataControlCreationHelper() {
    }

    static boolean supportsTransaction(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, SUPPORTS_TRANSACTION_FILTER).size() == 3;
    }

    static boolean createTransactionSupportMethods(ITypeHelper typeHelper, JavaCodeManipulationHelper helper, IType type, IProgressMonitor monitor) throws Exception {
        boolean modified = false;
        if (type != null) {
            IFile javaFile = (IFile)type.getCompilationUnit().getResource();
            if (!DataControlCreationHelper.hasIsDirtyTransactionMethod(typeHelper, type)) {
                modified |= helper.createMethod(javaFile, type.getElementName(), isTransactionDirtyMethod, monitor);
            }
            if (!DataControlCreationHelper.hasCommitTransactionMethod(typeHelper, type)) {
                modified |= helper.createMethod(javaFile, type.getElementName(), commitTransactionMethod, monitor);
            }
            if (!DataControlCreationHelper.hasRollbackTransactionMethod(typeHelper, type)) {
                modified |= helper.createMethod(javaFile, type.getElementName(), rollbackTransactionMethod, monitor);
            }
        }
        return modified;
    }

    static boolean supportsQuery(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, SUPPORTS_QUERY_FILTER).size() == 1;
    }

    private static boolean hasRollbackTransactionMethod(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, HAS_ROLLBACK_TRANSACTION_METHOD_FILTER).size() == 1;
    }

    private static boolean hasIsDirtyTransactionMethod(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, HAS_IS_DIRTY_TRANSACTION_METHOD_FILTER).size() == 1;
    }

    private static boolean hasCommitTransactionMethod(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, HAS_COMMIT_TRANSACTION_METHOD_FILTER).size() == 1;
    }

    static boolean supportsManagedDC(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, SUPPORTS_MANAGED_DC_FILTER).size() == 3;
    }

    static boolean createManagedDCSupportMethods(ITypeHelper typeHelper, JavaCodeManipulationHelper helper, IType type, IProgressMonitor monitor) throws Exception {
        boolean modified = false;
        if (type != null) {
            IFile javaFile = (IFile)type.getCompilationUnit().getResource();
            if (!DataControlCreationHelper.hasCreateSnapshotMethod(typeHelper, type)) {
                modified |= helper.createMethod(javaFile, type.getElementName(), createSnapshotMethod, monitor);
                modified |= helper.createImport(javaFile, type.getElementName(), Serializable.class.getName(), monitor);
            }
            if (!DataControlCreationHelper.hasRestoreSnapshotMethod(typeHelper, type)) {
                modified |= helper.createMethod(javaFile, type.getElementName(), restoreSnapshotMethod, monitor);
                modified |= helper.createImport(javaFile, type.getElementName(), Serializable.class.getName(), monitor);
            }
            if (!DataControlCreationHelper.hasRemoveSnapshotMethod(typeHelper, type)) {
                modified |= helper.createMethod(javaFile, type.getElementName(), removeSnapshotMethod, monitor);
                modified |= helper.createImport(javaFile, type.getElementName(), Serializable.class.getName(), monitor);
            }
        }
        return modified;
    }

    private static boolean hasRemoveSnapshotMethod(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, HAS_REMOVE_SNAPSHOT_METHOD_FILTER).size() == 1;
    }

    private static boolean hasRestoreSnapshotMethod(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, HAS_RESTORE_SNAPSHOT_METHOD_FILTER).size() == 1;
    }

    private static boolean hasCreateSnapshotMethod(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, HAS_CREATE_SNAPSHOT_METHOD_FILTER).size() == 1;
    }

    static boolean supportsUpdateableDC(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, SUPPORTS_UPDATEABLE_DC_FILTER).size() == 5;
    }

    static boolean createUpdateableDCSupportMethods(ITypeHelper typeHelper, JavaCodeManipulationHelper helper, IType type, IProgressMonitor monitor) throws Exception {
        boolean modified = false;
        if (type != null) {
            IFile javaFile = (IFile)type.getCompilationUnit().getResource();
            if (!DataControlCreationHelper.hasRegisterDataProviderMethod(typeHelper, type)) {
                modified |= helper.createMethod(javaFile, type.getElementName(), registerDataProviderMethod, monitor);
                modified |= helper.createImport(javaFile, type.getElementName(), RowContext.class.getName(), monitor);
            }
            if (!DataControlCreationHelper.hasCreateRowDataMethod(typeHelper, type)) {
                modified |= helper.createMethod(javaFile, type.getElementName(), createRowDataMethod, monitor);
                modified |= helper.createImport(javaFile, type.getElementName(), RowContext.class.getName(), monitor);
            }
            if (!DataControlCreationHelper.hasRemoveRowDataMethod(typeHelper, type)) {
                modified |= helper.createMethod(javaFile, type.getElementName(), removeRowDataMethod, monitor);
                modified |= helper.createImport(javaFile, type.getElementName(), RowContext.class.getName(), monitor);
            }
            if (!DataControlCreationHelper.hasSetAttributeValueMethod(typeHelper, type)) {
                modified |= helper.createMethod(javaFile, type.getElementName(), setAttributeValueMethod, monitor);
                modified |= helper.createImport(javaFile, type.getElementName(), AttributeContext.class.getName(), monitor);
            }
            if (!DataControlCreationHelper.hasValidateMethod(typeHelper, type)) {
                modified |= helper.createMethod(javaFile, type.getElementName(), validateMethod, monitor);
            }
        }
        return modified;
    }

    private static boolean hasSetAttributeValueMethod(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, HAS_SET_ATTRIBUTE_VALUE_METHOD_FILTER).size() == 1;
    }

    private static boolean hasValidateMethod(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, HAS_VALIDATE_METHOD_FILTER).size() == 1;
    }

    private static boolean hasRemoveRowDataMethod(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, HAS_REMOVE_ROW_DATA_METHOD_FILTER).size() == 1;
    }

    private static boolean hasRegisterDataProviderMethod(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, HAS_REGISTER_DATA_PROVIDER_METHOD_FILTER).size() == 1;
    }

    private static boolean hasCreateRowDataMethod(ITypeHelper typeHelper, IType type) throws Exception {
        return type != null && typeHelper.getMethods(type, true, HAS_CREATE_ROW_DATA_METHOD_FILTER).size() == 1;
    }
}

