/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.Collection;
import java.util.HashSet;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.jdt.JavaCodeManipulationHelper;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ExecutableContextAdapter;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.BeanCreationInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.BeanSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.CreationInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlCreationHelper;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.DataControlUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.EJBSessionBeanCreationInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.EJBSessionBeanSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.IDataControlSourceInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.CommandExecutor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;

public class CreationInfoProviderCommandExecutor
extends CommandExecutor<ICreateDataControlCommand> {
    private ITypeHelper typeHelper;
    private CreationInfo creationInfo;

    public CreationInfoProviderCommandExecutor(IDataControlContext context) {
        super((ICommandStack)context, ICreateDataControlCommand.class);
        IDTRTManager manager = DTRTvContextUtil.getManager((IOEPEContext)context);
        this.typeHelper = manager.getTypeHelper();
    }

    protected void dispose() {
        this.creationInfo = null;
        this.typeHelper = null;
        super.dispose();
    }

    public CreationInfo getCreationInfo() throws Exception {
        if (this.creationInfo == null || !this.creationInfo.matches((ICreateDataControlCommand)this.getCommand())) {
            this.creationInfo = null;
            this.analyzeDataControlSource();
        }
        return this.creationInfo;
    }

    private void analyzeDataControlSource() throws Exception {
        if (((ICreateDataControlCommand)this.getCommand()).getStructureSource() instanceof IStructure.ITypeSource) {
            IDataControlSourceInfo sourceInfo = DataControlUtil.computeInfo(((ICreateDataControlCommand)this.getCommand()).getStructureSource());
            IType type = ((IStructure.ITypeSource)((ICreateDataControlCommand)this.getCommand()).getStructureSource()).getType();
            if (type != null) {
                this.creationInfo = this.initializeCreationInfo(sourceInfo, ((ICreateDataControlCommand)this.getCommand()).getDataControlType(), type);
            }
        } else {
            throw new IllegalStateException("The command does not have its source set");
        }
    }

    private CreationInfo initializeCreationInfo(IDataControlSourceInfo sourceInfo, IDescribable dataControlType, IType type) throws Exception {
        if (dataControlType == null) {
            throw new IllegalStateException("The command does not have its dataControlType set");
        }
        if ("Java Bean".equals(DTRTUtil.getLabel((IDescribable)dataControlType))) {
            return new BeanCreationInfo((BeanSourceInfo)sourceInfo, DataControlCreationHelper.supportsQuery(this.typeHelper, type), DataControlCreationHelper.supportsManagedDC(this.typeHelper, type), DataControlCreationHelper.supportsTransaction(this.typeHelper, type), DataControlCreationHelper.supportsUpdateableDC(this.typeHelper, type));
        }
        if ("EJB Session Bean".equals(DTRTUtil.getLabel((IDescribable)dataControlType))) {
            return new EJBSessionBeanCreationInfo((EJBSessionBeanSourceInfo)sourceInfo, DataControlCreationHelper.supportsQuery(this.typeHelper, type), DataControlCreationHelper.supportsManagedDC(this.typeHelper, type), DataControlCreationHelper.supportsTransaction(this.typeHelper, type), DataControlCreationHelper.supportsUpdateableDC(this.typeHelper, type));
        }
        return null;
    }

    protected void aboutToExecute() throws Exception {
        if (this.getCommand() instanceof CreateDataControlCommand) {
            if (this.creationInfo == null) {
                this.analyzeDataControlSource();
            }
            ((CreateDataControlCommand)this.getCommand()).setCreationInfo(this.creationInfo);
            ((ICreateDataControlCommand)this.getCommand()).getCommandStack().addListener((IOEPEContext.IContextListener)new ContextAdapter(this.creationInfo, this.typeHelper));
        }
    }

    private static class ContextAdapter
    extends ExecutableContextAdapter {
        private CreationInfo creationInfo;
        private ITypeHelper typeHelper;

        public ContextAdapter(CreationInfo creationInfo, ITypeHelper typeHelper) {
            this.creationInfo = creationInfo;
            this.typeHelper = typeHelper;
        }

        public IOEPEExecutableContext.IContextSaveParticipant handlePreSave(IOEPEExecutableContext context) {
            assert (context instanceof IDataControlContext);
            IDataControlContext dataControlContext = (IDataControlContext)context;
            ICreateDataControlCommand command = (ICreateDataControlCommand)dataControlContext.getMostRecentCommand();
            try {
                return new DataControlCreationSaveParticipant(this.typeHelper, this.creationInfo, ((IStructure.ITypeSource)command.getStructureSource()).getType());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void handleSave(IOEPEExecutableContext context, IOEPEExecutableContext.ISaveSummary saveSummary) {
            context.removeListener((IOEPEContext.IContextListener)this);
            this.creationInfo = null;
            this.typeHelper = null;
        }
    }

    private static class DataControlCreationSaveParticipant
    implements IOEPEExecutableContext.IContextSaveParticipant,
    IWorkspaceRunnable {
        private static final String JRF_SHARED_LIBRARY = "oracle.eclipse.tools.weblogic.lib.shared/adf.oracle.domain/exact/1.0";
        private ITypeHelper typeHelper;
        private CreationInfo creationInfo;
        private IType type;
        private Collection<IResource> affectedResources;

        public DataControlCreationSaveParticipant(ITypeHelper typeHelper, CreationInfo creationInfo, IType type) {
            assert (typeHelper != null);
            assert (creationInfo != null);
            assert (type != null);
            this.typeHelper = typeHelper;
            this.creationInfo = creationInfo;
            this.type = type;
        }

        private void initializeAffectedResources() {
            if (this.affectedResources == null) {
                this.affectedResources = new HashSet<IResource>();
                if (this.creationInfo instanceof BeanCreationInfo) {
                    BeanCreationInfo beanCreationInfo = (BeanCreationInfo)this.creationInfo;
                    if (!DTRTUtil.isEmpty((String)beanCreationInfo.getWrapperClassname())) {
                        this.affectedResources.add((IResource)beanCreationInfo.getWrapperClassFile());
                    } else if (beanCreationInfo.canSetManagedDCSupported() && beanCreationInfo.isManagedDCSupported() || beanCreationInfo.canSetTransactionalDCSupported() && beanCreationInfo.isTransactionalDCSupported()) {
                        this.affectedResources.add(this.type.getResource());
                    }
                    if (beanCreationInfo.canSetUpdateableDCSupported() && beanCreationInfo.isUpdateableDCSupported()) {
                        try {
                            if (!DTRTUtil.hasJRFOnTheClasspath((IProject)this.type.getResource().getProject())) {
                                this.affectedResources.add((IResource)this.type.getResource().getProject());
                            }
                        }
                        catch (Exception e) {
                            DTRTvBundle.log(e);
                        }
                        this.affectedResources.add(this.type.getResource());
                    }
                } else {
                    boolean cfr_ignored_0 = this.creationInfo instanceof EJBSessionBeanCreationInfo;
                }
                this.creationInfo.isGenerateMetadata();
            }
        }

        public Collection<? extends IResource> getResources(IOEPEExecutableContext context) {
            this.initializeAffectedResources();
            return this.affectedResources;
        }

        public IWorkspaceRunnable getWorkspaceRunnable(IOEPEExecutableContext context) {
            return this;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            if (this.creationInfo instanceof BeanCreationInfo) {
                IType modifiedType = this.adjustJavaBean((BeanCreationInfo)this.creationInfo, this.type, monitor);
                this.generateMetadata(this.creationInfo, modifiedType, monitor);
            } else if (this.creationInfo instanceof EJBSessionBeanCreationInfo) {
                this.generateMetadata(this.creationInfo, this.type, monitor);
            }
        }

        private IType adjustJavaBean(BeanCreationInfo creationInfo, IType type, IProgressMonitor monitor) throws CoreException {
            IType modifiableType = type;
            JavaCodeManipulationHelper javaCodeHelper = new JavaCodeManipulationHelper();
            if (!DTRTUtil.isEmpty((String)creationInfo.getWrapperClassname())) {
                String wrapperClass = creationInfo.getWrapperClassname().replace('.', '\\').concat(".java");
                IFile javaFile = JavaUtil.getSourceFile((IProject)type.getJavaProject().getProject(), (String)wrapperClass, (boolean)true, (String)"src");
                ICompilationUnit cu = javaCodeHelper.createClass(javaFile, type.getFullyQualifiedName(), monitor);
                modifiableType = cu.findPrimaryType();
            }
            try {
                boolean updated = false;
                updated |= this.ensureSupportsManagedDC(javaCodeHelper, this.typeHelper, creationInfo, modifiableType, monitor);
                updated |= this.ensureSupportsTransactions(javaCodeHelper, this.typeHelper, creationInfo, modifiableType, monitor);
                if (updated |= this.ensureSupportsUpdateDC(javaCodeHelper, this.typeHelper, creationInfo, modifiableType, monitor)) {
                    javaCodeHelper.save(monitor);
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", e.getMessage()));
            }
            return modifiableType;
        }

        private boolean ensureSupportsManagedDC(JavaCodeManipulationHelper helper, ITypeHelper typeHelper, BeanCreationInfo creationInfo, IType modifiableType, IProgressMonitor monitor) throws Exception {
            if (creationInfo.isManagedDCSupported()) {
                return DataControlCreationHelper.createManagedDCSupportMethods(typeHelper, helper, modifiableType, monitor);
            }
            return false;
        }

        private boolean ensureSupportsTransactions(JavaCodeManipulationHelper helper, ITypeHelper typeHelper, BeanCreationInfo creationInfo, IType modifiableType, IProgressMonitor monitor) throws Exception {
            if (creationInfo.isTransactionalDCSupported()) {
                return DataControlCreationHelper.createTransactionSupportMethods(typeHelper, helper, modifiableType, monitor);
            }
            return false;
        }

        private boolean ensureSupportsUpdateDC(JavaCodeManipulationHelper helper, ITypeHelper typeHelper, BeanCreationInfo creationInfo, IType modifiableType, IProgressMonitor monitor) throws Exception {
            if (creationInfo.isUpdateableDCSupported()) {
                this.ensureJRFSetForProject(this.type.getJavaProject(), typeHelper);
                return DataControlCreationHelper.createUpdateableDCSupportMethods(typeHelper, helper, modifiableType, monitor);
            }
            return false;
        }

        private void ensureJRFSetForProject(IJavaProject project, ITypeHelper typeHelper) throws Exception {
            if (!DTRTUtil.hasJRFOnTheClasspath((IProject)project.getProject())) {
                JDTUtil.addContainerClasspathEntry((IJavaProject)project, (String)JRF_SHARED_LIBRARY);
            }
        }

        private boolean generateMetadata(CreationInfo creationInfo, IType type, IProgressMonitor monitor) {
            creationInfo.isGenerateMetadata();
            return false;
        }
    }
}

