/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import oracle.eclipse.tools.adf.dtrt.jdt.ITypeHelper;
import oracle.eclipse.tools.adf.dtrt.jdt.JDTUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.JavaUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChooseWrapperClassDialog
extends StatusDialog {
    private IType type;
    private String packageName;
    private String wrapperClassName;
    private Text packageText;
    private Text classText;
    private ITypeHelper typeHelper;

    protected ChooseWrapperClassDialog(Shell parentShell, IType type) {
        super(parentShell);
        this.setTitle(Messages.ChooseWrapperClassDialog_title);
        this.setHelpAvailable(false);
        this.type = type;
    }

    public ITypeHelper getTypeHelper() {
        return this.typeHelper == null ? (this.typeHelper = JDTUtil.createTypeHelper()) : this.typeHelper;
    }

    protected Point getInitialSize() {
        return new Point(400, 200);
    }

    public String getWrapperClassName() {
        return this.wrapperClassName;
    }

    public IFile getWrapperClassFile() {
        if (this.wrapperClassName != null) {
            IProject project = this.type.getResource().getProject();
            Path path = new Path(String.valueOf(this.wrapperClassName.replace('.', '/')) + ".java");
            return JavaUtil.getSourceFile((IProject)project, (String)path.toString(), (boolean)true, (String)"src");
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite outerComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(outerComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(composite);
        DTRTUIUtil.applyGrabAllGridData((Control)composite);
        Label packageLabel = new Label(composite, 0);
        packageLabel.setText(Messages.ChooseWrapperClassDialog_package);
        this.packageText = new Text(composite, 2056);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.packageText);
        this.packageText.setEditable(false);
        Label classLabel = new Label(composite, 0);
        classLabel.setText(Messages.ChooseWrapperClassDialog_class);
        this.classText = new Text(composite, 2048);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.classText);
        this.initializeControls();
        return outerComposite;
    }

    private void initializeControls() {
        this.packageName = this.type.getPackageFragment().getElementName();
        this.packageText.setText(this.packageName);
        this.classText.setText(this.generateWrapperClassName(this.packageName));
        this.classText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ChooseWrapperClassDialog.this.validate();
            }
        });
        this.classText.setFocus();
        this.classText.setSelection(0, this.classText.getText().length());
        this.validate();
    }

    private String generateWrapperClassName(String packageName) {
        String className = this.type.getElementName().concat("Wrapper");
        IStatus status = Status.OK_STATUS;
        String wrapperClassName = className;
        int i = 1;
        while (!(status = this.checkUniqueness(String.valueOf(packageName) + "." + wrapperClassName)).isOK()) {
            wrapperClassName = String.valueOf(className) + i++;
        }
        return wrapperClassName;
    }

    private void validate() {
        if (this.classText != null) {
            IStatus status = Status.OK_STATUS;
            String className = this.classText.getText();
            if (DTRTUtil.isEmpty((String)className)) {
                status = new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", Messages.ChooseWrapperClassDialog_class_empty);
            } else if (className.indexOf(46) != -1) {
                status = new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", Messages.ChooseWrapperClassDialog_class_qualified);
            } else {
                status = JavaConventions.validateJavaTypeName((String)className, (String)"1.5", (String)"1.5");
                if (status.isOK()) {
                    this.wrapperClassName = String.valueOf(this.packageName) + '.' + className;
                    status = this.checkUniqueness(this.wrapperClassName);
                }
            }
            this.updateStatus(status);
        }
    }

    private IStatus checkUniqueness(String wrapperClassName) {
        IStatus status = Status.OK_STATUS;
        try {
            IType wrapperType = this.getTypeHelper().findType(JavaCore.create((IProject)this.type.getResource().getProject()), wrapperClassName);
            if (wrapperType != null) {
                status = new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", "'" + wrapperClassName + Messages.ChooseWrapperClassDialog_class_exists);
            }
        }
        catch (Exception e) {
            status = new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", e.getLocalizedMessage());
        }
        return status;
    }

    public boolean close() {
        this.classText = null;
        this.packageText = null;
        return super.close();
    }
}

