/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.ui.provider.ISummaryProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.BaseWizardPage;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.BeanCreationInfo;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.ChooseWrapperClassDialog;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

class BeanFeaturesPage
extends BaseWizardPage
implements ISummaryProvider {
    private boolean shouldSetErrorMessage = true;
    private Button failoverButton;
    private Button transactionsButton;
    private Button updateableButton;
    private Text wrapperClass;
    private Button chooseWrapperClass;
    private IType type;
    private Label wrapperClassDeleteHelp;

    public BeanFeaturesPage(BeanCreationInfo creationInfo, IType type) {
        super(creationInfo, BeanFeaturesPage.class.getSimpleName(), Messages.BeanFeaturesPage_title, null);
        this.setDescription(Messages.BeanFeaturesPage_description);
        this.type = type;
    }

    @Override
    public void dispose() {
        this.type = null;
        this.failoverButton = null;
        this.transactionsButton = null;
        this.updateableButton = null;
        this.wrapperClass = null;
        this.chooseWrapperClass = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(this.getClientArea().width, this.getClientArea().height);
            }
        };
        this.setControl((Control)composite);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(composite);
        DTRTUIUtil.applyGrabAllGridData((Control)composite);
        Group group = new Group(composite, 0);
        group.setText(Messages.BeanFeaturesPage_features);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)group);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)group);
        this.failoverButton = new Button((Composite)group, 32);
        this.failoverButton.setText(Messages.BeanFeaturesPage_failover);
        this.transactionsButton = new Button((Composite)group, 32);
        this.transactionsButton.setText(Messages.BeanFeaturesPage_transactions);
        this.updateableButton = new Button((Composite)group, 32);
        this.updateableButton.setText(Messages.BeanFeaturesPage_crud);
        new Label(composite, 0).setText("");
        Label label = new Label(composite, 64);
        label.setText(Messages.BeanFeaturesPage_implementation_dec);
        label.setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite wrapperComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(3).applyTo(wrapperComposite);
        wrapperComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label wrapperClassText = new Label(wrapperComposite, 0);
        wrapperClassText.setText(Messages.BeanFeaturesPage_implementation_label);
        wrapperClassText.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.wrapperClass = new Text(wrapperComposite, 2056);
        this.wrapperClass.setEditable(false);
        this.wrapperClass.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.chooseWrapperClass = new Button(wrapperComposite, 8);
        this.chooseWrapperClass.setText("");
        this.chooseWrapperClass.setImage(DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_BROWSE));
        this.chooseWrapperClass.setToolTipText(Messages.BeanFeaturesPage_wrapperClassPickerTooltip);
        this.chooseWrapperClass.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        Label spc = new Label(wrapperComposite, 0);
        spc.setLayoutData((Object)new GridData());
        this.wrapperClassDeleteHelp = new Label(wrapperComposite, 0);
        this.wrapperClassDeleteHelp.setText(Messages.BeanFeaturesPage_wrapper_class_delete);
        FontData fontData = this.wrapperClassDeleteHelp.getFont().getFontData()[0];
        Font font = new Font((Device)this.getShell().getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 2));
        this.wrapperClassDeleteHelp.setFont(font);
        this.wrapperClassDeleteHelp.setLayoutData((Object)new GridData(-1, 128, true, false));
        this.initializeControls();
        this.setPageComplete(true);
        this.setControl((Control)composite);
    }

    private void initializeControls() {
        this.failoverButton.setSelection(this.getCreationInfo().isManagedDCSupported());
        this.failoverButton.setEnabled(!this.getCreationInfo().isManagedDCSupported());
        if (this.getCreationInfo().isManagedDCSupported()) {
            this.failoverButton.setText(String.valueOf(this.failoverButton.getText()) + Messages.BeanFeaturesPage_failover_exists);
        } else {
            this.failoverButton.setToolTipText(Messages.BeanFeaturesPage_failover_support);
            this.failoverButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BeanFeaturesPage.this.getCreationInfo().setManagedDCSupported(!BeanFeaturesPage.this.getCreationInfo().isManagedDCSupported());
                }
            });
        }
        this.transactionsButton.setSelection(this.getCreationInfo().isTransactionalDCSupported());
        this.transactionsButton.setEnabled(!this.getCreationInfo().isTransactionalDCSupported());
        if (this.getCreationInfo().isTransactionalDCSupported()) {
            this.transactionsButton.setText(String.valueOf(this.transactionsButton.getText()) + Messages.BeanFeaturesPage_transactions_exist);
        } else {
            this.transactionsButton.setToolTipText(Messages.BeanFeaturesPage_transactions_support);
            this.transactionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BeanFeaturesPage.this.getCreationInfo().setTransactionalDCSupported(!BeanFeaturesPage.this.getCreationInfo().isTransactionalDCSupported());
                }
            });
        }
        this.updateableButton.setSelection(this.getCreationInfo().isUpdateableDCSupported());
        this.updateableButton.setEnabled(!this.getCreationInfo().isUpdateableDCSupported());
        if (this.getCreationInfo().isUpdateableDCSupported()) {
            this.updateableButton.setText(String.valueOf(this.updateableButton.getText()) + Messages.BeanFeaturesPage_crud_exists);
        } else {
            this.updateableButton.setToolTipText(Messages.BeanFeaturesPage_crud_support);
            this.updateableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BeanFeaturesPage.this.getCreationInfo().setUpdateableDCSupported(!BeanFeaturesPage.this.getCreationInfo().isUpdateableDCSupported());
                }
            });
        }
        this.wrapperClass.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    BeanFeaturesPage.this.getCreationInfo().setWrapperClassFile(null);
                    BeanFeaturesPage.this.getCreationInfo().setWrapperClassName(null);
                    BeanFeaturesPage.this.initializeWrapperClassValues();
                    BeanFeaturesPage.this.validatePage();
                }
                e.doit = false;
            }
        });
        this.initializeWrapperClassValues();
        this.chooseWrapperClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseWrapperClassDialog dialog = new ChooseWrapperClassDialog(BeanFeaturesPage.this.getShell(), BeanFeaturesPage.this.type);
                if (dialog.open() == 0) {
                    BeanFeaturesPage.this.wrapperClass.setText(dialog.getWrapperClassName());
                    BeanFeaturesPage.this.validatePage();
                    BeanFeaturesPage.this.getCreationInfo().setWrapperClassFile(dialog.getWrapperClassFile());
                    BeanFeaturesPage.this.getCreationInfo().setWrapperClassName(dialog.getWrapperClassName());
                    BeanFeaturesPage.this.wrapperClass.setSelection(0, BeanFeaturesPage.this.wrapperClass.getText().length());
                    BeanFeaturesPage.this.wrapperClass.setToolTipText(NLS.bind((String)Messages.BeanFeaturesPage_wrapper_class_tooltip, (Object)dialog.getWrapperClassFile().getProjectRelativePath().toString()));
                    BeanFeaturesPage.this.wrapperClassDeleteHelp.setVisible(true);
                    BeanFeaturesPage.this.wrapperClass.setFocus();
                }
            }
        });
    }

    private void initializeWrapperClassValues() {
        this.wrapperClass.setText(this.type.getFullyQualifiedName());
        this.wrapperClass.setToolTipText(NLS.bind((String)Messages.BeanFeaturesPage_wrapper_class_tooltip, (Object)this.type.getResource().getProjectRelativePath().toString()));
        this.wrapperClassDeleteHelp.setVisible(false);
        this.chooseWrapperClass.setFocus();
    }

    private void validatePage() {
    }

    public void setErrorMessage(String newMessage) {
        if (this.shouldSetErrorMessage || newMessage == null) {
            super.setErrorMessage(newMessage);
        }
    }

    @Override
    protected BeanCreationInfo getCreationInfo() {
        return (BeanCreationInfo)super.getCreationInfo();
    }

    public List<String> getSummaries() {
        ArrayList<String> summaries = new ArrayList<String>();
        if (this.getCreationInfo().canSetManagedDCSupported && this.getCreationInfo().isManagedDCSupported()) {
            summaries.add(Messages.BeanFeaturesPage_failover_summary);
        }
        if (this.getCreationInfo().canSetTransactionalDCSupported && this.getCreationInfo().isTransactionalDCSupported()) {
            summaries.add(Messages.BeanFeaturesPage_transaction_summary);
        }
        if (this.getCreationInfo().canSetUpdateableDCSupported && this.getCreationInfo().isUpdateableDCSupported()) {
            summaries.add(Messages.BeanFeaturesPage_crud_summary);
        }
        summaries.add(0, "");
        summaries.add(1, Messages.BeanFeaturesPage_features_summary);
        int adjustFeaturesLine = 2;
        if (this.getCreationInfo().canSetUpdateableDCSupported && this.getCreationInfo().isUpdateableDCSupported() && !DTRTUtil.hasJRFOnTheClasspath((IProject)this.type.getResource().getProject())) {
            summaries.add(1, String.valueOf(Messages.BeanFeaturesPage_add_jrf) + '\n');
            adjustFeaturesLine = 3;
        }
        if (this.getCreationInfo().getWrapperClassFile() != null) {
            summaries.add(adjustFeaturesLine, NLS.bind((String)Messages.BeanFeaturesPage_implementation_summary, (Object)this.getCreationInfo().getWrapperClassname()));
        } else if (summaries.size() > 2) {
            summaries.add(adjustFeaturesLine, NLS.bind((String)Messages.BeanFeaturesPage_implementation_summary, (Object)this.type.getFullyQualifiedName()));
        } else {
            summaries.add(adjustFeaturesLine, Messages.BeanFeaturesPage_none_summary);
        }
        return summaries;
    }
}

