/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.objects.CtrlHier;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.common.binding.standalone.WidgetFactory;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.adfdt.view.unified.binding.util.ExpressionUtils;
import oracle.adfdt.view.unified.binding.util.ProviderUtils;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AccessorParameterDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandExecutor;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.IBindCommand;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.object.IWidget;
import oracle.eclipse.tools.adf.dtrt.ui.command.IWizardCommandExecutor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vbundle.CreatableType;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.BasePageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.ObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.WizardBindCommandExecutor;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.CreateCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.bind.BindCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.IInternalWidget;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.WidgetImpl;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.taskflowwidget.TaskFlowWidget;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.BoundSourceUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.WebPageBoundSourceSubType;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.BindOperationType;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class WebPageContext
extends BasePageDefinitionContext
implements IWebPageContext {
    private IPageDefinition.IBoundSource webPageBoundSource;
    private IWebPageContext.IManagedBeanManager managedBeanManager;

    WebPageContext() {
    }

    @Override
    protected void doDispose() {
        this.webPageBoundSource = null;
        this.managedBeanManager = null;
        super.doDispose();
    }

    public WebPageContext initialize(IProject earProject, IFile webPageFile, IWebPageContext.IManagedBeanManager managedBeanManager, IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (!this.isInitialized()) {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)5);
            try {
                this.webPageBoundSource = BoundSourceUtil.createWebPageBoundSource((IFile)webPageFile, (WebPageBoundSourceSubType[])DTRTvContextUtil.SUPPORTED_WEB_PAGE_BOUND_SOURCE_SUB_TYPES);
                IProject webProject = webPageFile.getProject();
                this.initializeManager(earProject, webProject);
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                ProgressMonitorUtil.checkIfCanceled((IProgressMonitor)monitor);
                this.loadPageDefinition(this.webPageBoundSource);
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)4);
                this.managedBeanManager = managedBeanManager;
                if (managedBeanManager != null) {
                    managedBeanManager.setContext((IWebPageContext)this);
                }
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                return (WebPageContext)this.initialize((OEPEContextImpl)this);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.throwNotInitializedException(e);
            }
        }
        return this;
    }

    @Override
    protected void handleReset(IProgressMonitor monitor) throws CoreException {
        this.adfPageDefinition = null;
        this.pageDefinitionURI = null;
    }

    public IFile getWebPageFile() {
        return this.webPageBoundSource.getFile();
    }

    public IWebPageContext.IManagedBeanManager getManagedBeanManager() {
        return this.managedBeanManager;
    }

    public List<? extends IDescribable> getCreatableTypes(Class<? extends IObject> baseType) {
        return baseType == IPageDefinition.class ? Collections.singletonList(CreatableType.TYPE_PageDefinition) : Collections.emptyList();
    }

    protected <T extends ICommand> T doCreateCommand(Class<T> commandType) {
        this.checkCommandCreation();
        CreateCommand command = commandType == ICreateCommand.class ? new CreateCommand((IOEPEExecutableContext)this) : (commandType == IBindCommand.class ? (ICommand)commandType.cast((Object)new BindCommand(this)) : null);
        return (T)(command != null ? (ICommand)commandType.cast((Object)command) : null);
    }

    public List<? extends IInternalWidget> getCreateWidgets(IWebPageContext.IBindPosition bindPosition, IDataControlObject dataControlObject) {
        WidgetImpl.NamedDefinitionCreationFilter widgetFilter;
        List<Widget<?>> widgets;
        Pair<DataControl, NamedDefinition> pair = this.getDataControlAndNamedDefinition(dataControlObject = this.getLocalDataControlObject(dataControlObject));
        if (pair.getFirst() != null && !(widgets = this.getWidgets(pair, widgetFilter = new WidgetImpl.NamedDefinitionCreationFilter(dataControlObject, (NamedDefinition)pair.getSecond()))).isEmpty()) {
            Collections.sort(widgets, WidgetImpl.ALPHA_CREATOR_COMPARATOR);
            ArrayList<? extends IInternalWidget> list = new ArrayList<IInternalWidget>(widgets.size());
            for (Widget<?> widget : widgets) {
                if (!this.checkBindingCompatibility((NamedDefinition)pair.getSecond(), bindPosition.getParentNode(), widget)) continue;
                list.addAll(ObjectTranslator.INSTANCE.fromADFObject(widget, dataControlObject, bindPosition));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public List<? extends IInternalWidget> getCreateWidgets(IWebPageContext.IBindPosition bindPosition, IWebPageContext.ITaskFlowProxy taskFlow) throws IllegalStateException {
        if (this.getManagedBeanManager() == null) {
            throw new IllegalStateException("This context was initialized without a managed bean manager and cannot perform this operation.");
        }
        return TaskFlowWidget.getWidgets(this.getTranslator(), this.getPageDefinition(), taskFlow, bindPosition);
    }

    public boolean canBindOnCreation(String tagNSURI, String tagLocalName) {
        return WidgetImpl.canBindOnCreation(tagNSURI, tagLocalName);
    }

    public IWidget getCreateWidget(IWebPageContext.IBindPosition bindPosition, String tagNSURI, String tagLocalName, IDataControlObject dataControlObject) {
        String widgetId;
        if (this.canBindOnCreation(tagNSURI, tagLocalName) && (widgetId = WidgetImpl.getTagDropWidgetId(tagNSURI, tagLocalName)) != null) {
            List<? extends IInternalWidget> widgets = this.getCreateWidgets(bindPosition, dataControlObject);
            for (IInternalWidget iInternalWidget : widgets) {
                if (!iInternalWidget.getId().equals(widgetId)) continue;
                return iInternalWidget;
            }
        }
        return null;
    }

    public boolean canBeBound(Element nodeToBind) {
        return nodeToBind != null && WidgetImpl.canBeBound(nodeToBind.getNamespaceURI(), nodeToBind.getLocalName());
    }

    private boolean canEditElement(Element nodeToBind) {
        return nodeToBind != null && WidgetImpl.canEditBinding(nodeToBind.getNamespaceURI(), nodeToBind.getLocalName());
    }

    public boolean canEditBinding(Element nodeToBind) {
        return this.canEditElement(nodeToBind) && DTRTObjectUtil.getFirstBindingObject((IOEPEContext)this, (IFile)this.getWebPageFile(), (Node)nodeToBind) != null;
    }

    public IInternalWidget getBindWidget(Element nodeToBind) {
        if (this.canEditElement(nodeToBind)) {
            IBindingObject bindingObject = DTRTObjectUtil.getFirstBindingObject((IOEPEContext)this, (IFile)this.getWebPageFile(), (Node)nodeToBind);
            List<? extends IInternalWidget> widgets = this.getBindWidgets(nodeToBind, bindingObject.getDataControlObject(), BindOperationType.EDIT);
            return this.selectWidget(widgets, nodeToBind);
        }
        return null;
    }

    public IInternalWidget getBindWidget(Element nodeToBind, IDataControlObject dataControlObject) {
        if (this.canBeBound(nodeToBind)) {
            dataControlObject = this.getLocalDataControlObject(dataControlObject);
            BindOperationType operationType = BindOperationType.BIND;
            IBindingObject bindingObject = DTRTObjectUtil.getFirstBindingObject((IOEPEContext)this, (IFile)this.getWebPageFile(), (Node)nodeToBind);
            if (bindingObject != null && DTRTUtil.equals((Object)dataControlObject, (Object)bindingObject.getDataControlObject())) {
                operationType = BindOperationType.EDIT;
            } else {
                IPageDefinition pageDefinition = this.getPageDefinition();
                if (pageDefinition != null) {
                    for (IPageDefinition.IBoundSource boundSource : pageDefinition.getBoundSources()) {
                        if (!this.getWebPageFile().equals((Object)boundSource.getFile())) continue;
                        if (!boundSource.usesBindingObjects(pageDefinition, (Node)nodeToBind)) break;
                        operationType = BindOperationType.REBIND;
                        break;
                    }
                }
            }
            List<? extends IInternalWidget> widgets = this.getBindWidgets(nodeToBind, dataControlObject, operationType);
            return this.selectWidget(widgets, nodeToBind);
        }
        return null;
    }

    private List<? extends IInternalWidget> getBindWidgets(Element nodeToBind, IDataControlObject dataControlObject, BindOperationType operationType) {
        WidgetImpl.RebindFilter widgetFilter;
        List<Widget<?>> widgets;
        Pair<DataControl, NamedDefinition> pair = this.getDataControlAndNamedDefinition(dataControlObject);
        if (pair.getFirst() != null && !(widgets = this.getWidgets(pair, widgetFilter = new WidgetImpl.RebindFilter(nodeToBind))).isEmpty()) {
            Collections.sort(widgets, WidgetImpl.RANK_COMPARATOR);
            ArrayList<IInternalWidget> list = new ArrayList<IInternalWidget>(widgets.size());
            for (Widget<?> widget : widgets) {
                list.add(ObjectTranslator.INSTANCE.fromADFObject(widget, dataControlObject, operationType, nodeToBind));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private Pair<DataControl, NamedDefinition> getDataControlAndNamedDefinition(IDataControlObject dataControlObject) {
        NamedDefinition namedDefinition;
        DataControl dataControl;
        if (dataControlObject instanceof IDataControl) {
            dataControl = (DataControl)this.getTranslator().toADFObject((IObject)dataControlObject);
            namedDefinition = null;
        } else if (dataControlObject instanceof IDataControlChild && ((IDataControlChild)dataControlObject).getStructureObject() != null) {
            dataControl = (DataControl)this.getTranslator().toADFObject((IObject)DTRTObjectUtil.getDataControl((IDataControlObject)dataControlObject));
            namedDefinition = (NamedDefinition)this.getTranslator().toADFObject((IObject)dataControlObject);
        } else {
            dataControl = null;
            namedDefinition = null;
        }
        return new Pair((Object)dataControl, namedDefinition);
    }

    private List<Widget<?>> getWidgets(Pair<DataControl, NamedDefinition> pair, WidgetFactory.WidgetFilter widgetFilter) {
        DataControl dataControl = (DataControl)pair.getFirst();
        NamedDefinition namedDefinition = (NamedDefinition)pair.getSecond();
        if (dataControl != null && namedDefinition != null) {
            Map map;
            WidgetFactory.WidgetFactoryContext widgetFactoryContext = WidgetFactory.createContext((ADFDesignTimeContext)this.getManager().getADFDesignTimeContext(), (DataControl)dataControl, (NamedDefinition)namedDefinition);
            if (widgetFilter != null) {
                widgetFactoryContext.withWidgetFilter(widgetFilter);
            }
            if ((map = WidgetFactory.getAvailableWidgets((WidgetFactory.WidgetFactoryContext)widgetFactoryContext)) != null && !map.isEmpty()) {
                ArrayList widgets = new ArrayList(map.values());
                return widgets;
            }
        }
        return new ArrayList(0);
    }

    private IInternalWidget selectWidget(List<? extends IInternalWidget> widgets, Element nodeToBind) {
        if (!widgets.isEmpty()) {
            if ("column".equals(nodeToBind.getLocalName()) && widgets.size() > 1) {
                NodeList nodeList = nodeToBind.getElementsByTagNameNS("http://xmlns.oracle.com/adf/faces/rich", "inputText");
                if (nodeList != null && nodeList.getLength() > 0) {
                    for (IInternalWidget iInternalWidget : widgets) {
                        if (!"column_adf_faces".equals(iInternalWidget.getId())) continue;
                        return iInternalWidget;
                    }
                } else {
                    for (IInternalWidget iInternalWidget : widgets) {
                        if (!"read_only_column_adf_faces".equals(iInternalWidget.getId())) continue;
                        return iInternalWidget;
                    }
                }
            }
            return widgets.get(0);
        }
        return null;
    }

    private boolean checkBindingCompatibility(NamedDefinition definition, Node insertionRoot, Widget<?> widget) {
        if (definition != null && insertionRoot != null && ("column_adf_faces".equals(widget.getId()) || "read_only_column_adf_faces".equals(widget.getId()))) {
            String ns = insertionRoot.getNamespaceURI();
            String localName = insertionRoot.getLocalName();
            if (insertionRoot.getNodeType() == 1 && ("http://xmlns.oracle.com/adf/faces/rich".equals(ns) && ("table".equals(localName) || "treeTable".equals(localName)) || "http://java.sun.com/jsf/html".equals(ns) && "dataTable".equals(localName))) {
                Element tableNode = (Element)insertionRoot;
                String value = tableNode.getAttributeNS(null, "value");
                String bindingId = ExpressionUtils.getBindingIdFromExpression((String)value);
                if (bindingId == null) {
                    return false;
                }
                IBindingObject bindingObject = (IBindingObject)DTRTObjectUtil.find((Collection)DTRTObjectUtil.getBindingObjects((IPageDefinition)this.getPageDefinition()), (String)bindingId);
                Object controlBinding = this.getTranslator().toADFObject((IObject)bindingObject);
                if (!(controlBinding instanceof CtrlHier)) {
                    return false;
                }
                CtrlHier ctrlHier = (CtrlHier)controlBinding;
                AccessorDefinition assumedTableDef = null;
                StructureDefinition structToSearch = null;
                NamedDefinition parentDef = ADFBindingUtils.findPotentialAccessorParentOfAttribute((NamedDefinition)definition);
                if (parentDef == null || !(parentDef instanceof AccessorDefinition) && !(parentDef instanceof AccessorParameterDefinition)) {
                    return false;
                }
                AccessorDefinition accParent = (AccessorDefinition)parentDef;
                if (ADFBindingUtils.hasAttributeDefinitions((Definition)accParent) && !accParent.isCollection() && !accParent.isScalarCollection()) {
                    assumedTableDef = accParent.getParentAccessor();
                    if (assumedTableDef == null) {
                        return false;
                    }
                    structToSearch = ADFBindingUtils.getStructureDefinition((Definition)accParent);
                } else {
                    assumedTableDef = accParent;
                    structToSearch = ADFBindingUtils.getStructureDefinition((Definition)assumedTableDef);
                }
                if (structToSearch == null) {
                    return false;
                }
                if (!ProviderUtils.isAccessorDefinitionCompatibleWithBinding((NamedDefinition)assumedTableDef, (CtrlHier)ctrlHier)) {
                    return false;
                }
                DefinitionContainer attrs = structToSearch.getAttributeDefinitions();
                if (attrs == null) {
                    return false;
                }
                if (attrs.find(definition.getName()) == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected <C extends ICommand, E extends ICommandExecutor<C>> E doCreateCommandExecutor(Class<E> commandExecutorType, Class<C> commandType) {
        if (commandExecutorType == IWizardCommandExecutor.class && commandType == IBindCommand.class) {
            return (E)((ICommandExecutor)commandExecutorType.cast((Object)new WizardBindCommandExecutor(this)));
        }
        return null;
    }
}

