/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adfdt.model.objects.Application;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.command.IRunnableCommand;
import oracle.eclipse.tools.adf.dtrt.command.IUndoableRunnableCommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.IObjectEditor;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateCommand;
import oracle.eclipse.tools.adf.dtrt.context.command.IDeleteCommand;
import oracle.eclipse.tools.adf.dtrt.context.command.ISetCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IApplication;
import oracle.eclipse.tools.adf.dtrt.object.IBinding;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IIteratorBinding;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.ui.context.IUIObjectEditor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vbundle.CreatableType;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvBundle;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.BasePageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.DTRTvContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.editor.EMFContextUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.CreateCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.DeleteCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.SetCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.command.UndoableRunnableCommand;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.PageDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.object.ApplicationImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.RunnableCommandImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEContextImpl;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

final class PageDefinitionContext
extends BasePageDefinitionContext
implements IPageDefinitionContext {
    private Map<IApplication, List<IPageDefinition.IBoundSource>> applicationMap;

    PageDefinitionContext() {
    }

    @Override
    protected void doDispose() {
        if (this.applicationMap != null) {
            DTRTUtil.dispose(this.applicationMap.keySet());
            this.applicationMap.clear();
            this.applicationMap = null;
        }
        super.doDispose();
    }

    @Override
    protected boolean doReset(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.applicationMap != null) {
            DTRTUtil.dispose(this.applicationMap.keySet());
            this.applicationMap.clear();
            this.applicationMap = null;
        }
        return super.doReset(monitor);
    }

    @Override
    protected void handleReset(IProgressMonitor monitor) throws CoreException {
        if (this.pageDefinitionURI != null) {
            try {
                this.adfPageDefinition = this.getManager().loadRegisteredPageDefinition(this.pageDefinitionURI);
            }
            catch (Exception e) {
                DTRTvBundle.log(e);
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.dtrt.v120102", BasePageDefinitionContext.Messages.errorDuringReset, (Throwable)e));
            }
            assert (this.adfPageDefinition != null);
        }
    }

    public PageDefinitionContext initialize(IProject earProject, IFile pageDefinitionFile, IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (!this.isInitialized()) {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)5);
            try {
                IProject webProject = pageDefinitionFile.getProject();
                this.initializeManager(earProject, webProject);
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                ProgressMonitorUtil.checkIfCanceled((IProgressMonitor)monitor);
                this.loadPageDefinition(pageDefinitionFile);
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)4);
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                return (PageDefinitionContext)this.initialize((OEPEContextImpl)this);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.throwNotInitializedException(e);
            }
        }
        return this;
    }

    public Map<IApplication, List<IPageDefinition.IBoundSource>> getApplications() {
        if (this.getManager() != null && this.getADFPageDefinition() != null) {
            Map<Application, List<IPageDefinition.IBoundSource>> adfApplicationMap;
            if (this.applicationMap == null && !(adfApplicationMap = this.getManager().getApplications(this.getADFPageDefinition())).isEmpty()) {
                HashMap<IApplication, List<IPageDefinition.IBoundSource>> map = new HashMap<IApplication, List<IPageDefinition.IBoundSource>>(adfApplicationMap.size());
                for (Map.Entry<Application, List<IPageDefinition.IBoundSource>> entry : adfApplicationMap.entrySet()) {
                    IApplication application = (IApplication)this.getTranslator().fromADFObject((Object)entry.getKey(), IApplication.class);
                    if (application instanceof ApplicationImpl) {
                        ((ApplicationImpl)application).setManager(this.getManager());
                    }
                    map.put(application, entry.getValue());
                }
                this.applicationMap = map;
            }
            if (this.applicationMap != null) {
                return Collections.unmodifiableMap(this.applicationMap);
            }
        }
        return Collections.emptyMap();
    }

    protected <T extends ICommand> T doCreateCommand(Class<T> commandType) {
        this.checkCommandCreation();
        RunnableCommandImpl command = commandType == IRunnableCommand.class ? new RunnableCommandImpl((ICommandStack)this) : (commandType == IUndoableRunnableCommand.class ? new UndoableRunnableCommand((IOEPEExecutableContext)this) : (commandType == ICreateCommand.class ? new CreateCommand((IOEPEExecutableContext)this) : (commandType == IDeleteCommand.class ? new DeleteCommand(this) : (commandType == ISetCommand.class ? new SetCommand(this) : null))));
        return (T)(command != null ? (ICommand)commandType.cast(command) : null);
    }

    public List<? extends IDescribable> getCreatableTypes(Class<? extends IObject> baseType) {
        List<CreatableType> creatableTypes;
        this.checkInitialized();
        List<CreatableType> list = baseType == IBinding.class ? Arrays.asList(CreatableType.CONTROL_BINDING_TYPES) : (creatableTypes = baseType == IExecutable.class ? Arrays.asList(CreatableType.EXECUTABLE_TYPES) : null);
        if (creatableTypes == null && baseType == IIteratorBinding.class) {
            CreatableType[] array = CreatableType.ITERATOR_BINDING_TYPES;
            if (this.getPageDefinition() instanceof PageDefinition && ((PageDefinition)this.getPageDefinition()).getVariablesIterator() != null) {
                creatableTypes = new ArrayList<CreatableType>(array.length);
                int i = 0;
                while (i < array.length) {
                    if (array[i] != CreatableType.TYPE_VariablesIterator) {
                        creatableTypes.add(array[i]);
                    }
                    ++i;
                }
            } else {
                creatableTypes = Arrays.asList(array);
            }
        }
        return creatableTypes != null && !creatableTypes.isEmpty() ? Collections.unmodifiableList(creatableTypes) : Collections.emptyList();
    }

    public <T extends IObjectEditor> T createObjectEditor(Class<T> type, IObject object) {
        if (type == IUIObjectEditor.class && object != null) {
            return (T)((IObjectEditor)type.cast(EMFContextUtil.createObjectEditor((OEPEContextImpl)this, object)));
        }
        return null;
    }

    public String computeUniqueId(Class<? extends IObject> type, String baseId, IDescribable creatableType) {
        return DTRTvContextUtil.computeUniqueId((IOEPEContext)this, type, baseId, creatableType);
    }

    public boolean canModifyId(IDescribable type) {
        return type != CreatableType.TYPE_VariablesIterator;
    }
}

