/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.context;

import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.dtrt.vbundle.DTRTvUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.ObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vbundle.context.ObjectValidator;
import oracle.eclipse.tools.adf.dtrt.vbundle.datacontrol.structure.StructureUtil;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IManagerListener;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.impl.DTRTManagerFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectValidator;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.OEPEExecutableContextImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

abstract class OEPEExecutableContext
extends OEPEExecutableContextImpl {
    private IDTRTManager manager;
    private boolean localManager;

    OEPEExecutableContext() {
    }

    protected void doDispose() {
        if (this.manager != null) {
            if (this.localManager) {
                this.manager.dispose();
            }
            this.manager = null;
        }
        super.doDispose();
    }

    public final IObjectTranslator getTranslator() {
        return ObjectTranslator.INSTANCE;
    }

    public final IObjectValidator getValidator() {
        return ObjectValidator.INSTANCE;
    }

    public final boolean isInitialized() {
        return super.isInitialized() && this.getManager() != null;
    }

    protected final void initializeManager(IProject earProject, IProject webProject) {
        if (super.isInitialized()) {
            throw new IllegalStateException("This context is already initialized");
        }
        if (this.getManager() == null) {
            this.initializeManager(DTRTManagerFactory.createManager(earProject, webProject));
        } else if (!DTRTUtil.equals((Object)earProject, (Object)this.getManager().getEARProject()) || !DTRTUtil.equals((Object)webProject, (Object)this.getManager().getProject())) {
            throw new IllegalStateException("Invalid manager");
        }
    }

    protected final void initializeManager(IProject modelProject) {
        if (super.isInitialized()) {
            throw new IllegalStateException("This context is already initialized");
        }
        if (this.getManager() == null) {
            this.initializeManager(DTRTManagerFactory.createManager(modelProject));
        } else if (!DTRTUtil.equals((Object)modelProject, (Object)this.getManager().getProject())) {
            throw new IllegalStateException("Invalid manager");
        }
    }

    protected final void initializeManager(IDTRTManager manager) {
        if (super.isInitialized()) {
            throw new IllegalStateException("This context is already initialized");
        }
        if (this.getManager() != null) {
            throw new IllegalStateException("This context has a manager");
        }
        this.manager = manager;
        manager.addListener(new IManagerListener(){

            @Override
            public void handleExternalChange(IDTRTManager manager) {
                OEPEExecutableContext.this.handleExternalChange();
            }

            @Override
            public void handleStructureLoading(IDTRTManager manager) {
                OEPEExecutableContext.this.handleStructureLoading();
            }

            @Override
            public void handleStructureChange(IDTRTManager manager) {
                OEPEExecutableContext.this.handleStructureChange();
            }
        });
        this.localManager = true;
    }

    protected abstract void handleStructureLoading();

    protected abstract void handleStructureChange();

    protected final void setManager(IDTRTManager manager) {
        if (this.manager != null) {
            throw new IllegalStateException();
        }
        this.manager = manager;
        this.localManager = false;
    }

    public final IDTRTManager getManager() {
        if (this.localManager) {
            return this.manager;
        }
        if (this.manager != null && this.manager.isDisposed()) {
            throw new IllegalStateException("The context is in an inconsistent state");
        }
        return this.manager;
    }

    protected boolean doReset(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.getManager() != null) {
            super.doReset(null);
            if (this.localManager) {
                this.getManager().reset();
            }
            return true;
        }
        return false;
    }

    public final boolean needsSaving() {
        return this.getManager() != null && this.getManager().needsSaving();
    }

    protected IOEPEExecutableContext.ISaveSummary doSave(List<? extends IOEPEExecutableContext.IContextSaveParticipant> saveParticipants, IProgressMonitor monitor) throws Exception {
        this.checkInitialized();
        return this.getManager().save((IOEPEExecutableContext)this, saveParticipants, monitor);
    }

    protected final void checkCommandCreation() {
        if (!this.localManager) {
            throw new IllegalStateException("Cannot create command");
        }
    }

    public final boolean isKnown(IObject object) throws IllegalStateException {
        if (object != null) {
            if (object instanceof IStructureObject) {
                return StructureUtil.isKnown(this.getManager(), (IStructureObject)object);
            }
            if (object instanceof IDataControlChild) {
                object = DTRTObjectUtil.getDataControl((IDataControlObject)((IDataControlChild)object));
            }
            return DTRTvUtil.getManagedElement(this.getManager(), this.getTranslator(), object) != null;
        }
        return false;
    }

    public final IFile getAccessibleFile(IObject object) throws IllegalArgumentException, IllegalStateException {
        if (object != null) {
            IFile file = DTRTvUtil.getAccessibleFile(this.getManager(), this.getTranslator(), object);
            if (file == null && !this.isKnown(object)) {
                throw new IllegalArgumentException("Unknown object: " + object);
            }
            return file;
        }
        return null;
    }

    public List<? extends IFileMarker> getAccessibleDeclarations(IObject object) throws IllegalArgumentException, IllegalStateException {
        return DTRTvUtil.getAccessibleDeclarations(this.getManager(), this.getTranslator(), object);
    }
}

