/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.context;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.DataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ObjectList;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseElementObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.facade.executable.IBaseObject;
import oracle.eclipse.tools.adf.dtrt.vbundle.manager.IDTRTManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.context.IObjectTranslator;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.core.runtime.IProgressMonitor;

final class DataControlProviderHelper {
    private ObjectList<IDataControl> dataControls;

    DataControlProviderHelper() {
    }

    public void dispose() {
        if (this.dataControls != null) {
            DTRTUtil.dispose(this.dataControls);
            this.dataControls.clear();
            this.dataControls = null;
        }
    }

    public void clear() {
        if (this.dataControls != null) {
            this.dataControls.clear();
            this.dataControls = null;
        }
    }

    public void addDataControl(IDTRTManager manager, IObjectTranslator translator, IDataControl dataControl, IProgressMonitor monitor) {
        if (this.dataControls != null && dataControl != null) {
            DataControl adfDataControl = (DataControl)translator.toADFObject((IObject)dataControl);
            assert (adfDataControl != null) : dataControl;
            DataControl managerDataControl = manager.getDataControlByPath(adfDataControl.getReferencePath());
            if (managerDataControl == null) {
                throw new IllegalArgumentException("Unknown data control: " + dataControl);
            }
            if (adfDataControl.getConfigurationParent() != managerDataControl.getConfigurationParent()) {
                throw new IllegalArgumentException("Unknown data control: " + dataControl);
            }
            this.dataControls.add((Object)((IDataControl)translator.fromADFObject((Object)managerDataControl, IDataControl.class)));
        }
    }

    public void removeDataControls(IDTRTManager manager, IObjectTranslator translator, IProgressMonitor monitor) {
        if (this.dataControls != null) {
            List<? extends DataControl> adfDataControls = manager.getDataControls();
            HashSet<Object> dataControlKeys = new HashSet<Object>(adfDataControls.size());
            for (DataControl dataControl : adfDataControls) {
                Object key = this.computeDataControlKey(manager, dataControl);
                assert (key != null);
                boolean added = dataControlKeys.add(key);
                assert (added) : dataControl.getReferencePath();
            }
            Iterator iterator = this.dataControls.iterator();
            while (iterator.hasNext()) {
                IDataControl dataControl = (IDataControl)iterator.next();
                DataControl adfDataControl = (DataControl)translator.toADFObject((IObject)dataControl);
                if (dataControlKeys.remove(this.computeDataControlKey(manager, adfDataControl))) continue;
                iterator.remove();
                dataControl.dispose();
            }
        }
    }

    public void updateStructure(IDTRTManager manager) {
        if (this.dataControls != null) {
            List<? extends DataControl> updatedDataControls = manager.getDataControls();
            HashMap<Object, DataControl> updatedDataControlMap = new HashMap<Object, DataControl>(updatedDataControls.size());
            for (DataControl dataControl : updatedDataControls) {
                Object key = this.computeDataControlKey(manager, dataControl);
                assert (key != null);
                updatedDataControlMap.put(key, dataControl);
            }
            for (IDataControl iDataControl : this.dataControls) {
                IBaseElementObject oepeDataControl = (IBaseElementObject)iDataControl;
                DataControl adfDataControl = (DataControl)oepeDataControl.getDecoratedObject();
                DataControl updatedDataControl = (DataControl)updatedDataControlMap.remove(this.computeDataControlKey(manager, adfDataControl));
                if (updatedDataControl == null) {
                    this.dispose();
                    return;
                }
                oepeDataControl.handlePropertyChange(new Object[]{IBaseObject.CachedProperty.CHILDREN});
                oepeDataControl.setDecoratedObject(updatedDataControl);
            }
        }
    }

    private Object computeDataControlKey(IDTRTManager manager, DataControl adfDataControl) {
        return adfDataControl instanceof BaseElementObject && adfDataControl.getElement() != null && adfDataControl.getConfigurationParent() != null && adfDataControl.getConfigurationParent().getElement() != null && DTRTUtil.equals((Object)adfDataControl.getOwnerDocument(), (Object)adfDataControl.getConfigurationParent().getDocument()) ? new Pair((Object)adfDataControl.getReferencePath(), (Object)manager.getElementURI(adfDataControl)) : null;
    }

    public List<? extends IDataControl> getDataControls(IDTRTManager manager, IObjectTranslator translator, IProgressMonitor monitor) throws IllegalStateException, InterruptedException {
        if (this.dataControls == null) {
            List<? extends DataControl> adfDataControls = manager.getDataControls();
            ObjectList dataControls = new ObjectList(adfDataControls.size());
            for (DataControl dataControl : adfDataControls) {
                dataControls.add((Object)((IDataControl)translator.fromADFObject((Object)dataControl, IDataControl.class)));
            }
            this.dataControls = dataControls;
        }
        return this.dataControls.getUnmodifiableView();
    }

    public IDataControlObject getLocalDataControlObject(IDTRTManager manager, IObjectTranslator translator, IDataControlObject dataControlObject) {
        if (dataControlObject != null) {
            if (this.dataControls != null && this.dataControls.contains((Object)dataControlObject)) {
                return dataControlObject;
            }
            try {
                IDataControlObject localDataControlObject = (IDataControlObject)DTRTObjectUtil.find(this.getDataControls(manager, translator, null), (URI)dataControlObject.getURI());
                assert (localDataControlObject != null) : String.valueOf(dataControlObject.isDisposed()) + " - " + dataControlObject.getURI();
                assert (dataControlObject.equals((Object)localDataControlObject));
                return localDataControlObject;
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }
}

