/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.binding.pattern.selection;

import java.util.Map;
import oracle.adf.model.adapter.dataformat.AttributeDef;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.objects.Application;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.CtrlList;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.model.objects.IteratorBinding;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.view.common.binding.creator.v2.BasePattern;
import oracle.adfdt.view.common.binding.creator.v2.BinderParams;
import oracle.adfdt.view.common.binding.creator.v2.BinderResult;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.creator.v2.CreatorResult;
import oracle.adfdt.view.common.binding.utils.ADFBindingGenerator;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.adfdt.view.unified.binding.provider.ADFSelectionModelProvider;
import oracle.adfdt.view.unified.binding.provider.api.TableModelProvider;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.eclipse.tools.adf.dtrt.vbundle.binding.pattern.selection.SelectOneOptions;
import oracle.eclipse.tools.adf.dtrt.vbundle.binding.pattern.selection.ViewAttributeInfo;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseSelectOnePattern
extends BasePattern<SelectOneOptions> {
    public CreatorResult create(CreatorParams<SelectOneOptions> params) {
        this._configure(params);
        Document d = params.getOwnerDocument();
        DocumentFragment df = d.createDocumentFragment();
        df.appendChild(d.createElementNS("http://xmlns.oracle.com/adf/faces/rich", this.getLocalName()));
        return new CreatorResult(df);
    }

    public BinderResult bind(BinderParams<SelectOneOptions> params) {
        this._configure((CreatorParams<SelectOneOptions>)params);
        this._bind(params);
        return BinderResult.OK;
    }

    public SelectOneOptions createOptions(CreatorParams<SelectOneOptions> params) {
        return new SelectOneOptions((ADFSelectionModelProvider)params.getModelProvider());
    }

    public SelectOneOptions generateOptions(BinderParams<SelectOneOptions> params) {
        return new SelectOneOptions((ADFSelectionModelProvider)params.getModelProvider());
    }

    private void _configure(CreatorParams<SelectOneOptions> p) {
        ADFSelectionModelProvider mp = (ADFSelectionModelProvider)p.getModelProvider();
        mp.setIgnorePopulation(true);
    }

    protected abstract String getLocalName();

    private void _bind(BinderParams<SelectOneOptions> params) {
        ADFDesignTimeContext dtContext = params.getDtContext();
        ADFSelectionModelProvider modelProvider = this.getModelProvider(params);
        Element root = this.getSingleBindRoot(params.getBindRoots());
        Map properties = params.getProperties();
        boolean isJsf = ADFBindingUtils.hasProperty((Map)properties, (String)"jsf");
        boolean addRequired = "true".equals(properties.get("primitive:addRequired"));
        this.populateBinding(modelProvider, params);
        String itorVar = modelProvider.getIteratorVar();
        boolean isBoundToIterator = modelProvider.isBoundToIterator();
        String value = isBoundToIterator ? modelProvider.getSelectionExpression(itorVar) : modelProvider.getSelectionExpression();
        root.setAttributeNS(null, "value", value);
        if (!isJsf) {
            String shortDesc;
            String label = isBoundToIterator ? modelProvider.getLabelExpression(itorVar) : modelProvider.getLabelExpression();
            root.setAttributeNS(null, "label", label);
            if (!root.hasAttributeNS(null, "shortDesc") && (shortDesc = modelProvider.getShortDescExpression()) != null && !"".equals(shortDesc)) {
                root.setAttributeNS(null, "shortDesc", shortDesc);
            }
            String requiredExpr = modelProvider.getRequiredExpression();
            if (addRequired && requiredExpr != null) {
                root.setAttributeNS(null, "required", requiredExpr);
            }
        }
        Element selectItems = null;
        Node child = root.getFirstChild();
        while (child != null) {
            Element childElement;
            if (child.getNodeType() == 1 && "http://java.sun.com/jsf/core".equals((childElement = (Element)child).getNamespaceURI()) && "selectItems".equals(childElement.getLocalName())) {
                selectItems = childElement;
                break;
            }
            child = child.getNextSibling();
        }
        if (selectItems == null) {
            Document document = root.getOwnerDocument();
            selectItems = document.createElementNS("http://java.sun.com/jsf/core", "selectItems");
            dtContext.prepareAppendElement(root, selectItems);
            root.appendChild(selectItems);
        }
        String childValue = isBoundToIterator ? modelProvider.getChildIteratorExpression(itorVar) : modelProvider.getChildIteratorExpression();
        selectItems.setAttributeNS(null, "value", childValue);
        Element validator = null;
        Node vChild = root.getFirstChild();
        while (vChild != null) {
            Element childElement;
            if (vChild.getNodeType() == 1 && "http://java.sun.com/jsf/core".equals((childElement = (Element)vChild).getNamespaceURI()) && "validator".equals(childElement.getLocalName())) {
                validator = childElement;
                break;
            }
            vChild = vChild.getNextSibling();
        }
        if (validator == null) {
            Document document = root.getOwnerDocument();
            validator = document.createElementNS("http://java.sun.com/jsf/core", "validator");
            dtContext.prepareAppendElement(root, validator);
            root.appendChild(validator);
        }
        String validatorBinding = isBoundToIterator ? modelProvider.getValidatorExpression(itorVar) : modelProvider.getValidatorExpression();
        validator.setAttributeNS(null, "binding", validatorBinding);
    }

    private ADFSelectionModelProvider getModelProvider(BinderParams<SelectOneOptions> params) {
        AccessorDefinition pa;
        SelectOneOptions options = (SelectOneOptions)params.getOptions();
        ADFSelectionModelProvider modelProvider = (ADFSelectionModelProvider)params.getModelProvider();
        NamedDefinition namedDef = modelProvider.getDefinition();
        if (options.isLovDefinedInModel() && namedDef instanceof AccessorDefinition && (pa = ((AccessorDefinition)namedDef).getParentAccessor()) != null) {
            StructureDefinition parent = pa.getStructure();
            modelProvider = new ADFSelectionModelProviderForLOV(params.getDtContext(), modelProvider.getDataControl(), (NamedDefinition)new ViewAttributeInfo((AccessorDefinition)namedDef, parent));
        }
        return modelProvider;
    }

    private void populateBinding(ADFSelectionModelProvider modelProvider, BinderParams<SelectOneOptions> params) {
        SelectOneOptions options = (SelectOneOptions)params.getOptions();
        ControlBinding ctrlBinding = modelProvider.getOrCreateUnpopulatedBinding();
        PageDefinition pageDefinition = ctrlBinding.getBindingContainer();
        Application application = pageDefinition.getDesigntimeContext().getApplication();
        if (options.isLovDefinedInModel()) {
            if (ctrlBinding instanceof CtrlList) {
                CtrlList ctrlList = (CtrlList)ctrlBinding;
                ctrlList.setServerListBindingName(options.getModelListBindingName());
                ctrlList.setStaticList(false);
                ctrlList.setValueList(null);
                ctrlList.setListAttrNames(null);
                ctrlList.setListDisplayAttrNames(null);
                ctrlList.setListOperMode(0);
                ctrlList.setListIteratorBindingName("");
                ctrlList.setMRUCount(0);
                ctrlList.setMRUValueString(null, null);
                ctrlList.setNullValue(null);
            }
        } else {
            IteratorBinding newIter = ADFBindingGenerator.createUniqueIteratorBinding((Application)application, (PageDefinition)pageDefinition, (DataControl)options.getListDataSourceDC(), (NamedDefinition)options.getListDataSource());
            newIter.setRangeSize(-1);
            if (ctrlBinding instanceof CtrlList) {
                CtrlList ctrlList = (CtrlList)ctrlBinding;
                ctrlList.setStaticList(false);
                ctrlList.setListOperMode(0);
                ctrlList.setAttrNames(this.getTargetAttribute(modelProvider.getDefinition()));
                ctrlList.setListIteratorBindingName(newIter.getId());
                ctrlList.setListAttrNames(this.createStringArray(options.getListAttribute()));
                ctrlList.setListDisplayAttrNames(this.createStringArray(options.getDisplayAttribute()));
                ctrlList.setServerListBindingName("");
            }
        }
    }

    private String[] getTargetAttribute(NamedDefinition definition) {
        return definition instanceof AttributeDef ? this.createStringArray((AttributeDef)definition) : null;
    }

    private String[] createStringArray(AttributeDef attributeDef) {
        if (attributeDef != null) {
            String[] attrs = new String[]{attributeDef.getName()};
            return attrs;
        }
        return null;
    }

    private class ADFSelectionModelProviderForLOV
    extends ADFSelectionModelProvider {
        public ADFSelectionModelProviderForLOV(ADFDesignTimeContext dtContext, DataControl dataControl, NamedDefinition dataControlDefinition) {
            super(dtContext, dataControl, dataControlDefinition, null, true);
        }

        @Override
        protected TableModelProvider getTableModelProvider(ADFDesignTimeContext dtContext, PageDefinition pageDefinition, String bindingId) {
            return null;
        }

        @Override
        protected Element getParentTable(Node insertParent) {
            return null;
        }
    }
}

