/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vbundle.binding.creator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.adfdtinternal.view.common.binding.resource.ADFCommonResources;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.ICreatorPresentation;
import oracle.eclipse.tools.adf.dtrt.vcommon.binding.creator.IPresentationVariation;

class CreatorPresentation
implements ICreatorPresentation {
    private final String _masterLabel;
    private final String _detailLabel;
    private final List<IPresentationVariation> _variations;
    private final boolean _variationsHaveVariations;

    public CreatorPresentation(Map<String, String> properties, List<IPresentationVariation> variations) {
        String detailHeader;
        this._variations = variations == null ? new ArrayList<IPresentationVariation>() : variations;
        this._variationsHaveVariations = CreatorPresentation.hasChildVariations(this._variations);
        String masterHeader = properties.get("masterHeader");
        if (masterHeader == null && !this._variationsHaveVariations) {
            masterHeader = properties.get("header");
        }
        if (masterHeader == null) {
            masterHeader = ADFCommonResources.getResource((String)"MD_MASTER_HEADER");
        }
        if ((detailHeader = properties.get("detailHeader")) == null) {
            detailHeader = ADFCommonResources.getResource((String)"MD_DETAIL_HEADER");
        }
        this._masterLabel = masterHeader;
        this._detailLabel = detailHeader;
    }

    private static boolean hasChildVariations(List<IPresentationVariation> variations) {
        for (IPresentationVariation pv : variations) {
            List children = pv.getChildren();
            if (children == null || children.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getMasterLabel() {
        return this._masterLabel;
    }

    public String getDetailLabel() {
        return this._detailLabel;
    }

    public List<IPresentationVariation> getPresentationVariations() {
        return Collections.unmodifiableList(this._variations);
    }

    public boolean variationsHaveVariations() {
        return this._variationsHaveVariations;
    }
}

