/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdt.view.common.binding.registration;

import java.util.HashSet;
import java.util.Set;

public final class RegistrationConfiguration {
    private HashSet<String> _includedProperties;
    private HashSet<String> _exludedProperties;
    private ClassLoader _classLoader;

    public boolean acceptPattern(Set<String> properties) {
        if (this._includedProperties != null) {
            boolean acceptable = false;
            for (String s : properties) {
                if (!this._includedProperties.contains(s)) continue;
                acceptable = true;
                break;
            }
            if (!acceptable) {
                return false;
            }
        }
        if (this._exludedProperties != null) {
            for (String s : properties) {
                if (!this._exludedProperties.contains(s)) continue;
                return false;
            }
        }
        return true;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader != null ? this._classLoader : this.getClass().getClassLoader();
    }

    public ClassLoader getClassLoaderDirectly() {
        return this._classLoader;
    }

    public void addIncludedProperties(String ... properties) {
        if (this._includedProperties == null) {
            this._includedProperties = new HashSet();
        }
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this._includedProperties.add(s);
            ++n2;
        }
    }

    public void addExcludedProperties(String ... properties) {
        if (this._exludedProperties == null) {
            this._exludedProperties = new HashSet();
        }
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this._exludedProperties.add(s);
            ++n2;
        }
    }

    public RegistrationConfiguration copy() {
        RegistrationConfiguration rc = new RegistrationConfiguration();
        if (this._exludedProperties != null) {
            for (String s : this._exludedProperties) {
                rc.addExcludedProperties(s);
            }
        }
        if (this._includedProperties != null) {
            for (String s : this._includedProperties) {
                rc.addIncludedProperties(s);
            }
        }
        if (this._classLoader != null) {
            rc.setClassLoader(this._classLoader);
        }
        return rc;
    }
}

