/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common;

import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClassUtils {
    private static Logger logger = Logger.getLogger(ClassUtils.class.getName());
    public static final boolean OSGI_BUDDY_MODE = false;

    public static Class forName(String className) throws ClassNotFoundException {
        Class<?> cls = null;
        if (className != null) {
            cls = Class.forName(className, true, ClassUtils.getClassLoader());
        }
        return cls;
    }

    public static Class forName(String className, Class referenceClass) throws ClassNotFoundException {
        Class<?> cls = null;
        if (className != null) {
            cls = Class.forName(className, true, ClassUtils.getClassLoader(referenceClass));
        }
        return cls;
    }

    @Deprecated
    public static ClassLoader getClassLoader() {
        return ClassUtils.getClassLoader(ClassUtils.class);
    }

    public static ClassLoader getClassLoader(Class referenceClass) {
        if (referenceClass == null) {
            throw new IllegalArgumentException("referenceClass must not be null");
        }
        String threadName = Thread.currentThread().getName();
        ClassLoader loader = ClassUtils.class.getClassLoader();
        if (loader == null) {
            loader = referenceClass.getClassLoader();
        }
        return loader;
    }

    public static URL getResource(ClassLoader loader, String resourceName) {
        return loader.getResource(resourceName);
    }

    public static InputStream getResourceAsStream(ClassLoader loader, String resourceName) {
        return loader.getResourceAsStream(resourceName);
    }

    public static ClassLoader getParentClassLoader(ClassLoader cl) {
        ClassLoader parentCl = cl.getParent();
        return parentCl;
    }

    public static boolean isAncestor(ClassLoader clsLoader, ClassLoader parentClsLoader) {
        ClassLoader childClsLoader = clsLoader;
        do {
            if (parentClsLoader != (childClsLoader = childClsLoader.getParent())) continue;
            return true;
        } while (childClsLoader != null);
        return false;
    }

    private static final boolean hasProperty(final String propName) {
        block3: {
            try {
                String propValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(propName);
                    }
                });
                if (propValue != null && propValue.length() > 0) {
                    return true;
                }
            }
            catch (Exception x) {
                if (!logger.isLoggable(Level.FINE)) break block3;
                logger.log(Level.INFO, propName, x);
            }
        }
        return false;
    }
}

