/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.codecompletion.ctxinsensitive;

import com.python.pydev.analysis.CtxInsensitiveImportComplProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.shared_interactive_console.console.ui.IScriptConsoleViewer;

public class PyConsoleCompletion
extends CtxInsensitiveImportComplProposal {
    private int commandLineOffset;
    private int deltaInLine;
    private int diff;

    public PyConsoleCompletion(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, String realImportRep, IScriptConsoleViewer viewer) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, realImportRep);
        this.commandLineOffset = viewer.getCommandLineOffset();
    }

    public void apply(IDocument document, char trigger, int stateMask, int offset) {
        if (!this.triggerCharAppliesCurrentCompletion(trigger, document, offset)) {
            return;
        }
        try {
            this.diff = offset - (this.fReplacementOffset + this.fReplacementLength);
            this.deltaInLine = document.getLength() - (this.fReplacementOffset + this.fReplacementLength);
            String currentLineContents = document.get(this.commandLineOffset, document.getLength() - this.commandLineOffset);
            StringBuffer buf = new StringBuffer(currentLineContents);
            int startReplace = currentLineContents.length() - this.deltaInLine - this.fReplacementLength;
            int endReplace = currentLineContents.length() - this.deltaInLine + this.diff;
            String newCurrentLineString = buf.replace(startReplace, endReplace, this.fReplacementString).toString();
            document.replace(this.commandLineOffset, document.getLength() - this.commandLineOffset, "");
            boolean addImport = this.realImportRep.length() > 0;
            String delimiter = PyAction.getDelimiter((IDocument)document);
            if (addImport) {
                document.replace(this.commandLineOffset, 0, String.valueOf(this.realImportRep) + delimiter + newCurrentLineString);
            } else {
                document.replace(document.getLength(), 0, newCurrentLineString);
            }
        }
        catch (BadLocationException x) {
            Log.log((Throwable)x);
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(document.getLength() - this.deltaInLine + this.diff, 0);
    }
}

