/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.wtp.java.core.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.wtp.java.core.internal.CommonWtpJavaExtensionsPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class ExportExtensionManager {
    public static final String PRE_OPERATION_CLASS = "preOperationClass";
    public static final String POST_OPERATION_CLASS = "postOperationClass";
    private Map<OperationType, List<ExportOperationElement>> allOperations = new HashMap<OperationType, List<ExportOperationElement>>();
    private boolean initialized;
    private static ExportExtensionManager instance = new ExportExtensionManager();

    private ExportExtensionManager() {
    }

    public static ExportExtensionManager getInstance() {
        return instance;
    }

    public List<ExportOperationElement> getExportOperations(OperationType type) {
        this.ensureInitialized();
        if (this.allOperations.containsKey((Object)type)) {
            return this.allOperations.get((Object)type);
        }
        return Collections.emptyList();
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            try {
                IExtension[] extensions;
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint point = registry.getExtensionPoint("oracle.eclipse.tools.common", "export");
                IExtension[] iExtensionArray = extensions = point.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    this.processExtension(extension);
                    ++n2;
                }
                for (List<ExportOperationElement> operations : this.allOperations.values()) {
                    Collections.sort(operations, new Comparator<ExportOperationElement>(){

                        @Override
                        public int compare(ExportOperationElement e1, ExportOperationElement e2) {
                            return e1.getPriority() - e2.getPriority();
                        }
                    });
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }

    private void processExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("exportOperation".equals(element.getName())) {
                String priority = element.getAttribute("priority");
                String type = element.getAttribute("type");
                if (priority != null && type != null) {
                    try {
                        int pri = Integer.parseInt(priority);
                        OperationType opType = OperationType.WAR;
                        if ("EAR".equals(type)) {
                            opType = OperationType.EAR;
                        } else if ("EJB".equals(type)) {
                            opType = OperationType.EJB;
                        }
                        this.addOperation(new ExportOperationElement(element, pri, opType));
                    }
                    catch (NumberFormatException nfe) {
                        CommonWtpJavaExtensionsPlugin.logException(nfe);
                    }
                }
            }
            ++n2;
        }
    }

    private void addOperation(ExportOperationElement element) {
        if (element != null) {
            List<ExportOperationElement> elements = this.allOperations.get((Object)element.getType());
            if (elements == null) {
                elements = new ArrayList<ExportOperationElement>();
                this.allOperations.put(element.getType(), elements);
            }
            elements.add(element);
        }
    }

    public static class ExportOperationElement {
        private IDataModelOperation preOperation;
        private IDataModelOperation postOperation;
        private int priority = 100;
        private OperationType type;

        public ExportOperationElement(IConfigurationElement element, int priority, OperationType type) {
            this.priority = priority;
            this.type = type;
            try {
                if (element.isValid()) {
                    if (element.getAttribute(ExportExtensionManager.PRE_OPERATION_CLASS) != null) {
                        this.preOperation = (IDataModelOperation)element.createExecutableExtension(ExportExtensionManager.PRE_OPERATION_CLASS);
                    }
                    if (element.getAttribute(ExportExtensionManager.POST_OPERATION_CLASS) != null) {
                        this.postOperation = (IDataModelOperation)element.createExecutableExtension(ExportExtensionManager.POST_OPERATION_CLASS);
                    }
                }
            }
            catch (Exception e) {
                CommonWtpJavaExtensionsPlugin.logException(e);
            }
        }

        public int getPriority() {
            return this.priority;
        }

        public OperationType getType() {
            return this.type;
        }

        public IDataModelOperation getPreOperation() {
            return this.preOperation;
        }

        public IDataModelOperation getPostOperation() {
            return this.postOperation;
        }
    }

    public static enum OperationType {
        EAR,
        WAR,
        EJB,
        GAR;

    }
}

