/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.wtp.core.fproj.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public final class TargetedRuntimeCompositionPropertyTester
extends PropertyTester {
    private static final String PROP_TARGETED_RUNTIME_COMPOSITION = "targetedRuntimeComposition";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object value) {
        try {
            boolean matches;
            if (!property.equals(PROP_TARGETED_RUNTIME_COMPOSITION)) {
                throw new IllegalStateException();
            }
            IFacetedProject fproj = null;
            if (receiver instanceof IFacetedProject) {
                fproj = (IFacetedProject)receiver;
            } else if (receiver instanceof IProject) {
                fproj = ProjectFacetsManager.create((IProject)((IProject)receiver));
            }
            if (fproj == null) {
                return false;
            }
            List<RuntimeComponentSig> expectedRuntimeComposition = TargetedRuntimeCompositionPropertyTester.parseRuntimeComposition(value.toString());
            if (expectedRuntimeComposition == null) {
                return false;
            }
            Iterator itr1 = fproj.getTargetedRuntimes().iterator();
            block2: do {
                if (!itr1.hasNext()) {
                    return false;
                }
                IRuntime runtime = (IRuntime)itr1.next();
                matches = true;
                for (RuntimeComponentSig rcsig : expectedRuntimeComposition) {
                    boolean found = false;
                    for (IRuntimeComponent rc : runtime.getRuntimeComponents()) {
                        if (!TargetedRuntimeCompositionPropertyTester.match(rc, rcsig)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    matches = false;
                    continue block2;
                }
            } while (!matches);
            return true;
        }
        catch (CoreException e) {
            LoggingService.logException("oracle.eclipse.tools.common.wtp.core", e);
        }
        return false;
    }

    private static boolean match(IRuntimeComponent component, RuntimeComponentSig expectedSignature) throws CoreException {
        if (component.getRuntimeComponentType() == expectedSignature.type) {
            if (expectedSignature.vexpr != null) {
                Set expectedVersions = expectedSignature.type.getVersions(expectedSignature.vexpr);
                return expectedVersions.contains(component.getRuntimeComponentVersion());
            }
            return true;
        }
        return false;
    }

    private static List<RuntimeComponentSig> parseRuntimeComposition(String propertyValue) {
        ArrayList<RuntimeComponentSig> result = new ArrayList<RuntimeComponentSig>();
        String[] stringArray = propertyValue.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if ((segment = segment.trim()).length() != 0) {
                String typeString = null;
                String vexpr = null;
                int colon = segment.indexOf(58);
                if (colon != -1) {
                    if (colon == 0 || colon == segment.length() - 1) {
                        String msg = Resources.bind((String)Resources.invalidSyntax, (Object)propertyValue);
                        LoggingService.logError("oracle.eclipse.tools.common.wtp.core", msg);
                        return null;
                    }
                    typeString = segment.substring(0, colon);
                    vexpr = segment.substring(colon + 1);
                } else {
                    typeString = segment;
                }
                if (!RuntimeManager.isRuntimeComponentTypeDefined((String)typeString)) {
                    return null;
                }
                IRuntimeComponentType type = RuntimeManager.getRuntimeComponentType((String)typeString);
                result.add(new RuntimeComponentSig(type, vexpr));
            }
            ++n2;
        }
        return result;
    }

    private static final class Resources
    extends NLS {
        public static String invalidSyntax;

        static {
            Resources.initializeMessages((String)TargetedRuntimeCompositionPropertyTester.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static final class RuntimeComponentSig {
        public final IRuntimeComponentType type;
        public final String vexpr;

        public RuntimeComponentSig(IRuntimeComponentType type, String vexpr) {
            this.type = type;
            this.vexpr = vexpr;
        }
    }
}

