/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.wtp.core.fproj.internal;

import java.util.Collection;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public final class ContainsRuntimeComponentType
extends PropertyTester {
    private static final String PROP_CONTAINS_RUNTIME_COMPONENT_TYPE = "containsRuntimeComponentType";

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object value) {
        try {
            String vexpr;
            String typeid;
            if (!property.equals(PROP_CONTAINS_RUNTIME_COMPONENT_TYPE)) {
                throw new IllegalStateException();
            }
            String val = (String)value;
            int colon = val.indexOf(58);
            if (colon == -1 || colon == val.length() - 1) {
                typeid = val;
                vexpr = null;
            } else {
                typeid = val.substring(0, colon);
                vexpr = val.substring(colon + 1);
            }
            if (!RuntimeManager.isRuntimeComponentTypeDefined((String)typeid)) {
                return false;
            }
            IRuntimeComponentType type = RuntimeManager.getRuntimeComponentType((String)typeid);
            if (receiver instanceof IRuntime) {
                for (Object component : ((IRuntime)receiver).getRuntimeComponents()) {
                    if (!ContainsRuntimeComponentType.match((IRuntimeComponent)component, type, vexpr)) continue;
                    return true;
                }
                return false;
            }
            if (receiver instanceof Collection) {
                for (Object obj : (Collection)receiver) {
                    if (obj instanceof IRuntimeComponent) {
                        if (!ContainsRuntimeComponentType.match((IRuntimeComponent)obj, type, vexpr)) continue;
                        return true;
                    }
                    if (obj instanceof IRuntime) {
                        if (!this.test(obj, property, args, value)) continue;
                        return true;
                    }
                    throw new IllegalStateException();
                }
                return false;
            }
            throw new IllegalStateException();
        }
        catch (CoreException e) {
            LoggingService.logException("oracle.eclipse.tools.common.wtp.core", e);
            return false;
        }
    }

    private static final boolean match(IRuntimeComponent component, IRuntimeComponentType type, String vexpr) throws CoreException {
        if (component.getRuntimeComponentType() == type) {
            if (vexpr != null) {
                return type.getVersions(vexpr).contains(component.getRuntimeComponentVersion());
            }
            return true;
        }
        return false;
    }
}

