/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.wtp.core.fproj;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import oracle.eclipse.tools.common.util.AbstractModel;
import oracle.eclipse.tools.common.wtp.core.internal.CommonWtpExtensionsPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class ModifyFacetedProjectOperationConfig
extends AbstractModel {
    private static final String CLASS_NAME = ModifyFacetedProjectOperationConfig.class.getName();
    public static final String PROP_FACETS = String.valueOf(CLASS_NAME) + ".FACETS";
    public static final String PROP_ACTIONS = String.valueOf(CLASS_NAME) + ".ACTIONS";
    public static final String PROP_TARGETED_RUNTIMES = String.valueOf(CLASS_NAME) + ".TARGETED_RUNTIMES";
    private IProject project = null;
    private final Set<IProjectFacetVersion> facets = new CopyOnWriteArraySet<IProjectFacetVersion>();
    private final Set<IProjectFacetVersion> facetsReadOnly = Collections.unmodifiableSet(this.facets);
    private final Set<IFacetedProject.Action> actions = new CopyOnWriteArraySet<IFacetedProject.Action>();
    private final Set<IFacetedProject.Action> actionsReadOnly = Collections.unmodifiableSet(this.actions);
    private final Set<IRuntime> targetedRuntimes = new CopyOnWriteArraySet<IRuntime>();
    private final Set<IRuntime> targetedRuntimesReadOnly = Collections.unmodifiableSet(this.targetedRuntimes);

    public static ModifyFacetedProjectOperationConfig create(IProject project) {
        ModifyFacetedProjectOperationConfig res = new ModifyFacetedProjectOperationConfig();
        res.setProject(project);
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj != null) {
                res.setProjectFacets(fproj.getProjectFacets());
                res.setTargetedRuntimes(fproj.getTargetedRuntimes());
            }
        }
        catch (CoreException e) {
            CommonWtpExtensionsPlugin.logException((Exception)((Object)e));
        }
        return res;
    }

    public synchronized IProject getProject() {
        return this.project;
    }

    public synchronized void setProject(IProject project) {
        this.project = project;
    }

    public synchronized Set<IProjectFacetVersion> getProjectFacets() {
        return this.facetsReadOnly;
    }

    public synchronized void setProjectFacets(Set<IProjectFacetVersion> facets) {
        if (!this.facets.equals(facets)) {
            HashSet<IProjectFacetVersion> oldFacets = new HashSet<IProjectFacetVersion>(this.facets);
            this.facets.clear();
            this.facets.addAll(facets);
            this.notifyListeners(PROP_FACETS, oldFacets, this.facetsReadOnly);
        }
    }

    public synchronized Set<IFacetedProject.Action> getActions() {
        return this.actionsReadOnly;
    }

    public synchronized void setActions(Set<IFacetedProject.Action> actions) {
        if (!this.actions.equals(actions)) {
            HashSet<IFacetedProject.Action> oldActions = new HashSet<IFacetedProject.Action>(this.actions);
            this.actions.clear();
            this.actions.addAll(actions);
            this.notifyListeners(PROP_ACTIONS, oldActions, this.actionsReadOnly);
        }
    }

    public synchronized Set getTargetedRuntimes() {
        return this.targetedRuntimesReadOnly;
    }

    public synchronized void setTargetedRuntimes(Set<IRuntime> runtimes) {
        if (!this.targetedRuntimes.equals(runtimes)) {
            HashSet<IRuntime> oldTargetedRuntimes = new HashSet<IRuntime>(this.targetedRuntimes);
            this.targetedRuntimes.clear();
            this.targetedRuntimes.addAll(runtimes);
            this.notifyListeners(PROP_TARGETED_RUNTIMES, oldTargetedRuntimes, this.targetedRuntimesReadOnly);
        }
    }

    public synchronized void addTargetedRuntime(IRuntime runtime) {
        if (runtime == null) {
            throw new NullPointerException();
        }
        HashSet<IRuntime> oldTargetedRuntimes = new HashSet<IRuntime>(this.targetedRuntimes);
        this.targetedRuntimes.add(runtime);
        this.notifyListeners(PROP_TARGETED_RUNTIMES, oldTargetedRuntimes, this.targetedRuntimesReadOnly);
    }

    public synchronized void removeTargetedRuntime(IRuntime runtime) {
        if (runtime == null) {
            throw new NullPointerException();
        }
        HashSet<IRuntime> oldTargetedRuntimes = new HashSet<IRuntime>(this.targetedRuntimes);
        if (this.targetedRuntimes.remove(runtime)) {
            this.notifyListeners(PROP_TARGETED_RUNTIMES, oldTargetedRuntimes, this.targetedRuntimesReadOnly);
        }
    }

    @Override
    public Object getProperty(String property) {
        if (property.equals(PROP_FACETS)) {
            return this.getProjectFacets();
        }
        if (property.equals(PROP_TARGETED_RUNTIMES)) {
            return this.getTargetedRuntimes();
        }
        return null;
    }

    @Override
    public void setProperty(String property, Object value) {
        if (property.equals(PROP_FACETS)) {
            this.setProjectFacets((Set)value);
        } else if (property.equals(PROP_TARGETED_RUNTIMES)) {
            this.setTargetedRuntimes((Set)value);
        }
    }
}

