/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp.webxml.internal;

import java.util.List;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUtils;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUtilsForJavaEE;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.AbstractWebXmlUpdater;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.operations.ContextParamAdderForJavaEE;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.operations.ContextParamRemoverForJavaEE;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.operations.FilterAdderForJavaEE;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.operations.FilterMapperAdderForJavaEE;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.operations.FilterRemoverForJavaEE;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.operations.ListenerAdderForJavaEE;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.operations.ServletAdderForJavaEE;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.operations.ServletMappingAdderForJavaEE;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.operations.ServletRemoverForJavaEE;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.WebApp;

public class WebXmlUpdaterForJavaEE
extends AbstractWebXmlUpdater {
    private final WebApp webApp;

    public WebXmlUpdaterForJavaEE(Object webAppObj, IProject project, IModelProvider provider, IProgressMonitor monitor) {
        super(webAppObj, project, provider, monitor);
        this.webApp = (WebApp)webAppObj;
    }

    @Override
    public void addServlet(String servletName, String servletClass, String loadOnStartup) {
        this.provider.modify((Runnable)new ServletAdderForJavaEE(this.project, servletName, servletClass, loadOnStartup), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void removeServlet(String servletClassName) {
        Servlet servlet = WebXmlUtilsForJavaEE.findServlet(servletClassName, this.webApp);
        if (servlet == null) {
            throw new IllegalArgumentException("Cannot find servlet named \"" + servletClassName + "\"");
        }
        this.provider.modify((Runnable)new ServletRemoverForJavaEE(this.project, servletClassName), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addServletMapping(String servletName, String servletClass, String urlPattern) {
        this.provider.modify((Runnable)new ServletMappingAdderForJavaEE(this.project, servletName, servletClass, urlPattern), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addFilter(String filterName, String filterClass) {
        this.provider.modify((Runnable)new FilterAdderForJavaEE(this.project, filterName, filterClass), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void removeFilter(String filterClassName) {
        Filter filter = WebXmlUtilsForJavaEE.findFilter(this.webApp, filterClassName);
        if (filter == null) {
            throw new IllegalArgumentException("Cannot find filter named \"" + filterClassName + "\"");
        }
        this.provider.modify((Runnable)new FilterRemoverForJavaEE(this.project, filterClassName), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addFilterMapping(String filterName, String filterClass, String servletName) {
        this.provider.modify((Runnable)new FilterMapperAdderForJavaEE(this.project, filterName, servletName), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addFilterMapping(String filterName, String filterClass, String servletName, List<String> dispatchers) {
        this.provider.modify((Runnable)new FilterMapperAdderForJavaEE(this.project, filterName, servletName, dispatchers), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addContextParam(String paramName, String paramValue, String description) {
        this.provider.modify((Runnable)new ContextParamAdderForJavaEE(this.project, paramName, paramValue, description), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void addCommaSeparatedValueToContextParam(final String paramName, final String paramValue) {
        this.provider.modify(new Runnable(){

            @Override
            public void run() {
                WebApp webapp = (WebApp)ModelProviderManager.getModelProvider((IProject)WebXmlUpdaterForJavaEE.this.project).getModelObject();
                WebXmlUtilsForJavaEE.addCommaSeparatedValueToContextParam(webapp, paramName, paramValue);
            }
        }, WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void removeContextParam(String paramName, String paramValue) {
        this.provider.modify((Runnable)new ContextParamRemoverForJavaEE(this.project, paramName, paramValue), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public List<String> getContextParamValues(String paramName) {
        WebApp webapp = (WebApp)ModelProviderManager.getModelProvider((IProject)this.project).getModelObject();
        return WebXmlUtilsForJavaEE.getContextParamValues(webapp, paramName);
    }

    @Override
    public void addListener(String listenerClass) {
        this.provider.modify((Runnable)new ListenerAdderForJavaEE(this.project, listenerClass), WebXmlUtils.WEB_XML_PATH);
    }

    @Override
    public void removeListener(final String listenerClass) {
        this.provider.modify(new Runnable(){

            @Override
            public void run() {
                WebApp webapp = (WebApp)ModelProviderManager.getModelProvider((IProject)WebXmlUpdaterForJavaEE.this.project).getModelObject();
                WebXmlUtilsForJavaEE.removeListener(webapp, listenerClass);
            }
        }, WebXmlUtils.WEB_XML_PATH);
    }
}

