/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp.webxml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.DispatcherType;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.FilterMapping;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;

public class WebXmlUtilsForJavaEE {
    public static void addServlet(WebApp webapp, String servletName, String servletClass, String loadOnStartup) {
        if (WebXmlUtilsForJavaEE.existsServlet(webapp, servletName, servletClass)) {
            return;
        }
        Servlet servlet = WebFactory.eINSTANCE.createServlet();
        servlet.setServletName(servletName);
        servlet.setServletClass(servletClass);
        servlet.setLoadOnStartup((Object)loadOnStartup);
        webapp.getServlets().add(servlet);
    }

    public static boolean existsServlet(WebApp webapp, String servletName, String servletClass) {
        return WebXmlUtilsForJavaEE.findServlet(webapp, servletName, servletClass) != null;
    }

    public static Servlet findServlet(WebApp webapp, String servletName, String servletClass) {
        for (Object s : webapp.getServlets()) {
            Servlet servlet = (Servlet)s;
            if (!servlet.getServletName().equals(servletName) || !servlet.getServletClass().equals(servletClass)) continue;
            return servlet;
        }
        return null;
    }

    public static Servlet findServlet(String servletName, WebApp webApp) {
        for (Object servlet : webApp.getServlets()) {
            if (!((Servlet)servlet).getServletClass().trim().equals(servletName)) continue;
            return (Servlet)servlet;
        }
        return null;
    }

    public static void removeServlet(WebApp webApp, Servlet servlet) {
        webApp.getServlets().remove(servlet);
    }

    public static void addServletMapping(WebApp webApp, String servletName, String servletClass, String urlPatternString) {
        if (WebXmlUtilsForJavaEE.existsServletMapping(webApp, servletName, urlPatternString)) {
            return;
        }
        ServletMapping servletMapping = WebFactory.eINSTANCE.createServletMapping();
        servletMapping.setServletName(servletName);
        servletMapping.getUrlPatterns().add(WebXmlUtilsForJavaEE.createUrlPattern(urlPatternString));
        webApp.getServletMappings().add(servletMapping);
    }

    public static boolean existsServletMapping(WebApp webApp, String servletName, String urlPatternString) {
        return WebXmlUtilsForJavaEE.findServletMapping(webApp, servletName, urlPatternString) != null;
    }

    public static ServletMapping findServletMapping(WebApp webApp, String servletName, String urlPatternString) {
        for (Object mapping : webApp.getServletMappings()) {
            ServletMapping servletMappingToCheck = (ServletMapping)mapping;
            if (!servletMappingToCheck.getServletName().equals(servletName)) continue;
            for (Object pattern : servletMappingToCheck.getUrlPatterns()) {
                if (!((UrlPatternType)pattern).getValue().equals(urlPatternString)) continue;
                return servletMappingToCheck;
            }
        }
        return null;
    }

    public static void removeServletMappings(WebApp webApp, Servlet servlet) {
        List mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            servletName = servletName.trim();
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServletName() != null && mapping.getServletName().trim().equals(servletName)) {
                    mappings.remove(mapping);
                }
                --i;
            }
        }
    }

    public static List<String> getServletMappingPatterns(WebApp webApp) {
        ArrayList<String> patterns = new ArrayList<String>();
        for (Object mapping : webApp.getServletMappings()) {
            ServletMapping servletMapping = (ServletMapping)mapping;
            for (Object patternType : servletMapping.getUrlPatterns()) {
                String pattern = ((UrlPatternType)patternType).getValue();
                if (pattern == null) continue;
                patterns.add(pattern);
            }
        }
        return patterns;
    }

    public static void addFilter(WebApp webapp, String filterName, String filterClass) {
        if (WebXmlUtilsForJavaEE.existsFilter(webapp, filterName, filterClass)) {
            return;
        }
        webapp.getFilters().add(WebXmlUtilsForJavaEE.createFilter(filterName, filterClass));
    }

    public static Filter createFilter(String filterName, String filterClass) {
        Filter trinidadFilter = WebFactory.eINSTANCE.createFilter();
        trinidadFilter.setFilterName(filterName);
        trinidadFilter.setFilterClass(filterClass);
        return trinidadFilter;
    }

    public static boolean existsFilter(WebApp webapp, String filterName, String filterClass) {
        return WebXmlUtilsForJavaEE.findFilter(webapp, filterName, filterClass) != null;
    }

    public static Filter findFilter(WebApp webapp, String filterName, String filterClass) {
        for (Object f : webapp.getFilters()) {
            Filter filter = (Filter)f;
            if (!filter.getFilterName().trim().equals(filterName) || !filter.getFilterClass().trim().equals(filterClass)) continue;
            return filter;
        }
        return null;
    }

    public static Filter findFilter(WebApp webApp, String filterClassName) {
        for (Object filter : webApp.getFilters()) {
            if (!((Filter)filter).getFilterClass().trim().equals(filterClassName)) continue;
            return (Filter)filter;
        }
        return null;
    }

    public static void removeFilter(WebApp webApp, Filter filter) {
        webApp.getFilters().remove(filter);
    }

    public static void addFilterMapping(WebApp webapp, String filterName, String servletName) {
        if (WebXmlUtilsForJavaEE.existsFilterMapping(webapp, filterName, servletName)) {
            return;
        }
        webapp.getFilterMappings().add(WebXmlUtilsForJavaEE.createFilterMapping(filterName, servletName));
    }

    private static FilterMapping createFilterMapping(String filterName, String servletName) {
        FilterMapping filterMapping = WebFactory.eINSTANCE.createFilterMapping();
        filterMapping.setFilterName(filterName);
        filterMapping.getServletNames().add(servletName);
        return filterMapping;
    }

    public static void addFilterMapping(WebApp webapp, String filterName, String servletName, List<String> dispatcherList) {
        if (WebXmlUtilsForJavaEE.existsFilterMapping(webapp, filterName, servletName)) {
            return;
        }
        webapp.getFilterMappings().add(WebXmlUtilsForJavaEE.createFilterMapping(filterName, servletName, dispatcherList));
    }

    private static FilterMapping createFilterMapping(String filterName, String servletName, List<String> dispatcherList) {
        FilterMapping filterMapping = WebFactory.eINSTANCE.createFilterMapping();
        filterMapping.setFilterName(filterName);
        filterMapping.getServletNames().add(servletName);
        List dispatcherTypeList = filterMapping.getDispatchers();
        for (String literal : dispatcherList) {
            dispatcherTypeList.add(DispatcherType.get((String)literal));
        }
        return filterMapping;
    }

    public static boolean existsFilterMapping(WebApp webapp, String filterName, String servletName) {
        return WebXmlUtilsForJavaEE.findFilterMapping(webapp, filterName, servletName) != null;
    }

    public static FilterMapping findFilterMapping(WebApp webapp, String filterName, String servletName) {
        for (Object fm : webapp.getFilterMappings()) {
            FilterMapping filterMapping = (FilterMapping)fm;
            if (!filterMapping.getFilterName().trim().equals(filterName) || !filterMapping.getServletNames().contains(servletName)) continue;
            return filterMapping;
        }
        return null;
    }

    public static void removeFilterMappings(WebApp webApp, Filter filter) {
        List mappings = webApp.getFilterMappings();
        String filterName = filter.getFilterName();
        if (filterName != null) {
            filterName = filterName.trim();
            int i = mappings.size() - 1;
            while (i >= 0) {
                FilterMapping mapping = (FilterMapping)mappings.get(i);
                if (mapping != null && mapping.getFilterName() != null && mapping.getFilterName().trim().equals(filterName)) {
                    mappings.remove(mapping);
                }
                --i;
            }
        }
    }

    public static void addContextParam(WebApp webApp, String paramName, String paramValue, String description) {
        if (WebXmlUtilsForJavaEE.existsContextParam(webApp, paramName, paramValue)) {
            return;
        }
        webApp.getContextParams().add(WebXmlUtilsForJavaEE.createContextParam(paramName, paramValue, description));
    }

    public static void addCommaSeparatedValueToContextParam(WebApp webapp, String paramName, String paramValue) {
        ParamValue param = WebXmlUtilsForJavaEE.findContextParam(webapp, paramName);
        if (param == null) {
            webapp.getContextParams().add(WebXmlUtilsForJavaEE.createContextParam(paramName, paramValue, null));
            return;
        }
        param.setParamValue(String.valueOf(param.getParamValue()) + ", " + paramValue);
    }

    private static ParamValue createContextParam(String paramName, String paramValue, String descriptionString) {
        ParamValue param = JavaeeFactory.eINSTANCE.createParamValue();
        param.setParamName(paramName);
        param.setParamValue(paramValue);
        if (descriptionString != null) {
            Description description = JavaeeFactory.eINSTANCE.createDescription();
            description.setValue(descriptionString);
            param.getDescriptions().add(description);
        }
        return param;
    }

    public static boolean existsContextParam(WebApp webApp, String paramName, String paramValue) {
        return WebXmlUtilsForJavaEE.findContextParam(webApp, paramName, paramValue) != null;
    }

    public static ParamValue findContextParam(WebApp webApp, String paramName, String paramValue) {
        for (Object param : webApp.getContextParams()) {
            ParamValue contextParam = (ParamValue)param;
            if (!contextParam.getParamName().equals(paramName) || !contextParam.getParamValue().equals(paramValue)) continue;
            return contextParam;
        }
        return null;
    }

    public static ParamValue findContextParam(WebApp webApp, String paramName) {
        for (Object param : webApp.getContextParams()) {
            ParamValue contextParam = (ParamValue)param;
            if (!contextParam.getParamName().trim().equals(paramName)) continue;
            return contextParam;
        }
        return null;
    }

    public static void removeContextParam(WebApp webapp, String paramName, String paramValue) {
        ArrayList<ParamValue> contextParamsToRemove = new ArrayList<ParamValue>();
        for (Object param : webapp.getContextParams()) {
            ParamValue contextParam = (ParamValue)param;
            if (!contextParam.getParamName().equals(paramName) || !contextParam.getParamValue().equals(paramValue)) continue;
            contextParamsToRemove.add(contextParam);
        }
        webapp.getContextParams().removeAll(contextParamsToRemove);
    }

    public static List<String> getContextParamValues(WebApp webapp, String paramName) {
        ParamValue param = WebXmlUtilsForJavaEE.findContextParam(webapp, paramName);
        if (param == null) {
            return null;
        }
        ArrayList<String> paramValueStrings = new ArrayList<String>();
        String[] stringArray = param.getParamValue().trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String paramValueString = stringArray[n2];
            paramValueStrings.add(paramValueString.trim());
            ++n2;
        }
        return paramValueStrings;
    }

    public static void addListener(WebApp webapp, String listenerClass) {
        if (WebXmlUtilsForJavaEE.existsListener(webapp, listenerClass)) {
            return;
        }
        Listener listener = JavaeeFactory.eINSTANCE.createListener();
        listener.setListenerClass(listenerClass);
        webapp.getListeners().add(listener);
    }

    public static boolean existsListener(WebApp webapp, String listenerClass) {
        return WebXmlUtilsForJavaEE.findListener(webapp, listenerClass) != null;
    }

    public static Listener findListener(WebApp webapp, String listenerClass) {
        for (Object listener : webapp.getListeners()) {
            if (!((Listener)listener).getListenerClass().equals(listenerClass)) continue;
            return (Listener)listener;
        }
        return null;
    }

    public static void removeListener(WebApp webapp, Listener listenerClass) {
        webapp.getListeners().remove(listenerClass);
    }

    public static void removeListener(WebApp webapp, String listenerClass) {
        Listener listenerToRemove = WebXmlUtilsForJavaEE.findListener(webapp, listenerClass);
        if (listenerClass != null) {
            WebXmlUtilsForJavaEE.removeListener(webapp, listenerToRemove);
        }
    }

    public static UrlPatternType createUrlPattern(String urlPatternString) {
        UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
        urlPattern.setValue(urlPatternString);
        return urlPattern;
    }
}

