/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp.webxml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.webapplication.DispatcherType;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;

public class WebXmlUtilsForJ2EE {
    public static void addServlet(WebApp webapp, String servletName, String servletClass, String loadOnStartup) {
        if (WebXmlUtilsForJ2EE.existsServlet(webapp, servletName, servletClass)) {
            return;
        }
        Servlet servlet = WebapplicationFactory.eINSTANCE.createServlet();
        servlet.setServletName(servletName);
        servlet.setLoadOnStartup(new Integer(loadOnStartup));
        ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
        servletType.setClassName(servletClass);
        servlet.setWebType((WebType)servletType);
        webapp.getServlets().add((Object)servlet);
    }

    public static boolean existsServlet(WebApp webapp, String servletName, String servletClass) {
        return WebXmlUtilsForJ2EE.findServlet(webapp, servletName, servletClass) != null;
    }

    public static Servlet findServlet(WebApp webapp, String servletName, String servletClass) {
        for (Object s : webapp.getServlets()) {
            Servlet servlet = (Servlet)s;
            if (!servlet.getServletName().equals(servletName) || !((ServletType)servlet.getWebType()).getClassName().equals(servletClass)) continue;
            return servlet;
        }
        return null;
    }

    public static Servlet findServlet(WebApp webApp, String servletClassName) {
        for (Object servlet : webApp.getServlets()) {
            Servlet j2eeServlet = (Servlet)servlet;
            String servletClass = ((ServletType)j2eeServlet.getWebType()).getClassName();
            if (!servletClass.equals(servletClassName)) continue;
            return j2eeServlet;
        }
        return null;
    }

    public static Servlet findServletByName(WebApp webapp, String servletName) {
        for (Object s : webapp.getServlets()) {
            Servlet servlet = (Servlet)s;
            if (!servlet.getServletName().trim().equals(servletName)) continue;
            return servlet;
        }
        return null;
    }

    public static void removeServlet(WebApp webApp, Servlet servlet) {
        webApp.getServlets().remove((Object)servlet);
    }

    public static void addServletMapping(WebApp webapp, String servletName, String servletClass, String urlPattern) {
        if (WebXmlUtilsForJ2EE.existsServletMapping(webapp, servletName, urlPattern)) {
            return;
        }
        Servlet servlet = WebXmlUtilsForJ2EE.findServlet(webapp, servletName, servletClass);
        if (servlet == null) {
            throw new IllegalArgumentException("Cannot create servlet mapping with servlet name \"" + servletName + "\" and URL pattern \"" + urlPattern + "\". No corresponding servlet is defined.");
        }
        ServletMapping servletMapping = WebapplicationFactory.eINSTANCE.createServletMapping();
        servletMapping.setServlet(servlet);
        servletMapping.setName(servletName);
        servletMapping.setUrlPattern(urlPattern);
        webapp.getServletMappings().add((Object)servletMapping);
    }

    public static boolean existsServletMapping(WebApp webapp, String servletName, String urlPattern) {
        return WebXmlUtilsForJ2EE.findServletMapping(webapp, servletName, urlPattern) != null;
    }

    public static ServletMapping findServletMapping(WebApp webapp, String servletName, String urlPattern) {
        for (Object mapping : webapp.getServletMappings()) {
            ServletMapping servletMapping = (ServletMapping)mapping;
            if (!servletMapping.getName().equals(servletName) || !servletMapping.getUrlPattern().equals(urlPattern)) continue;
            return servletMapping;
        }
        return null;
    }

    public static void removeServletMappings(WebApp webApp, Servlet servlet) {
        EList mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            servletName = servletName.trim();
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName)) {
                    mappings.remove(mapping);
                }
                --i;
            }
        }
    }

    public static List<String> getServletMappingPatterns(WebApp webApp) {
        ArrayList<String> patterns = new ArrayList<String>();
        for (Object mapping : webApp.getServletMappings()) {
            ServletMapping servletMapping = (ServletMapping)mapping;
            String pattern = servletMapping.getUrlPattern();
            if (pattern == null) continue;
            patterns.add(pattern);
        }
        return patterns;
    }

    public static void addFilter(WebApp webapp, String filterName, String filterClass) {
        if (WebXmlUtilsForJ2EE.existsFilter(webapp, filterName, filterClass)) {
            return;
        }
        webapp.getFilters().add((Object)WebXmlUtilsForJ2EE.createFilter(filterName, filterClass));
    }

    public static Filter createFilter(String filterName, String filterClass) {
        Filter trinidadFilter = WebapplicationFactory.eINSTANCE.createFilter();
        trinidadFilter.setName(filterName);
        trinidadFilter.setFilterClassName(filterClass);
        return trinidadFilter;
    }

    public static boolean existsFilter(WebApp webapp, String filterName, String filterClass) {
        return WebXmlUtilsForJ2EE.findFilter(webapp, filterName, filterClass) != null;
    }

    public static Filter findFilter(WebApp webapp, String filterName, String filterClass) {
        for (Object f : webapp.getFilters()) {
            Filter filter = (Filter)f;
            if (!filter.getName().trim().equals(filterName) || !filter.getFilterClassName().trim().equals(filterClass)) continue;
            return filter;
        }
        return null;
    }

    public static Filter findFilter(WebApp webApp, String filterClassName) {
        for (Object filter : webApp.getFilters()) {
            if (!((Filter)filter).getFilterClassName().trim().equals(filterClassName)) continue;
            return (Filter)filter;
        }
        return null;
    }

    public static void removeFilter(WebApp webApp, Filter filter) {
        webApp.getFilters().remove((Object)filter);
    }

    public static void addFilterMapping(WebApp webapp, String filterName, String filterClass, String servletName) {
        if (WebXmlUtilsForJ2EE.existsFilterMapping(webapp, filterName, servletName)) {
            return;
        }
        Filter filter = WebXmlUtilsForJ2EE.findFilter(webapp, filterName, filterClass);
        if (filter == null) {
            throw new IllegalArgumentException("Cannot create filter mapping with filter name \"" + filterName + "\" and servlet name \"" + servletName + "\". No corresponding filter is defined.");
        }
        Servlet servlet = WebXmlUtilsForJ2EE.findServletByName(webapp, servletName);
        if (servlet == null) {
            throw new IllegalArgumentException("Cannot create filter mapping with filter name \"" + filterName + "\" and servlet name \"" + servletName + "\". No corresponding servlet is defined.");
        }
        FilterMapping filterMapping = WebapplicationFactory.eINSTANCE.createFilterMapping();
        filterMapping.setFilter(filter);
        filterMapping.setServlet(servlet);
        filterMapping.setServletName(servletName);
        webapp.getFilterMappings().add((Object)filterMapping);
    }

    public static void addFilterMapping(WebApp webapp, String filterName, String filterClass, String servletName, List<String> dispatcherList) {
        if (WebXmlUtilsForJ2EE.existsFilterMapping(webapp, filterName, servletName)) {
            return;
        }
        Filter filter = WebXmlUtilsForJ2EE.findFilter(webapp, filterName, filterClass);
        if (filter == null) {
            throw new IllegalArgumentException("Cannot create filter mapping with filter name \"" + filterName + "\" and servlet name \"" + servletName + "\". No corresponding filter is defined.");
        }
        Servlet servlet = WebXmlUtilsForJ2EE.findServletByName(webapp, servletName);
        if (servlet == null) {
            throw new IllegalArgumentException("Cannot create filter mapping with filter name \"" + filterName + "\" and servlet name \"" + servletName + "\". No corresponding servlet is defined.");
        }
        FilterMapping filterMapping = WebapplicationFactory.eINSTANCE.createFilterMapping();
        filterMapping.setFilter(filter);
        filterMapping.setServlet(servlet);
        filterMapping.setServletName(servletName);
        for (String literal : dispatcherList) {
            filterMapping.getDispatcherType().add((Object)DispatcherType.get((String)literal));
        }
        webapp.getFilterMappings().add((Object)filterMapping);
    }

    public static boolean existsFilterMapping(WebApp webapp, String filterName, String servletName) {
        return WebXmlUtilsForJ2EE.findFilterMapping(webapp, filterName, servletName) != null;
    }

    public static FilterMapping findFilterMapping(WebApp webapp, String filterName, String servletName) {
        for (Object fm : webapp.getFilterMappings()) {
            FilterMapping filterMapping = (FilterMapping)fm;
            if (!filterMapping.getFilter().getName().trim().equals(filterName) || !filterMapping.getServletName().equals(servletName)) continue;
            return filterMapping;
        }
        return null;
    }

    public static void removeFilterMappings(WebApp webApp, Filter filter) {
        EList mappings = webApp.getFilterMappings();
        String filterName = filter.getName();
        if (filterName == null) {
            return;
        }
        filterName = filterName.trim();
        int i = mappings.size() - 1;
        while (i >= 0) {
            FilterMapping mapping = (FilterMapping)mappings.get(i);
            if (mapping != null && mapping.getFilter().getName() != null && mapping.getFilter().getName().trim().equals(filterName)) {
                mappings.remove(mapping);
            }
            --i;
        }
    }

    public static void addContextParam(WebApp webApp, String paramName, String paramValue, String description) {
        if (WebXmlUtilsForJ2EE.existsContextParam(webApp, paramName, paramValue)) {
            return;
        }
        webApp.getContextParams().add((Object)WebXmlUtilsForJ2EE.createContextParam(paramName, paramValue, description));
    }

    public static void addCommaSeparatedValueToContextParam(WebApp webapp, String paramName, String paramValue) {
        ParamValue param = WebXmlUtilsForJ2EE.findContextParam(webapp, paramName);
        if (param == null) {
            webapp.getContextParams().add((Object)WebXmlUtilsForJ2EE.createContextParam(paramName, paramValue, null));
            return;
        }
        param.setValue(String.valueOf(param.getValue()) + ", " + paramValue);
    }

    private static ParamValue createContextParam(String paramName, String paramValue, String descriptionString) {
        ParamValue param = CommonFactory.eINSTANCE.createParamValue();
        param.setName(paramName);
        param.setValue(paramValue);
        if (descriptionString != null) {
            Description description = CommonFactory.eINSTANCE.createDescription();
            description.setValue(descriptionString);
            param.getDescriptions().add((Object)description);
        }
        return param;
    }

    public static boolean existsContextParam(WebApp webApp, String paramName, String paramValue) {
        return WebXmlUtilsForJ2EE.findContextParam(webApp, paramName, paramValue) != null;
    }

    public static ParamValue findContextParam(WebApp webApp, String paramName) {
        for (Object param : webApp.getContextParams()) {
            ParamValue contextParam = (ParamValue)param;
            if (!contextParam.getName().trim().equals(paramName)) continue;
            return contextParam;
        }
        return null;
    }

    public static ParamValue findContextParam(WebApp webApp, String paramName, String paramValue) {
        for (Object param : webApp.getContextParams()) {
            ParamValue contextParam = (ParamValue)param;
            if (!contextParam.getName().equals(paramName) || !contextParam.getValue().equals(paramValue)) continue;
            return contextParam;
        }
        return null;
    }

    public static void removeContextParam(WebApp webapp, String paramName, String paramValue) {
        ArrayList<ParamValue> contextParamsToRemove = new ArrayList<ParamValue>();
        for (Object param : webapp.getContextParams()) {
            ParamValue contextParam = (ParamValue)param;
            if (!contextParam.getName().equals(paramName) || !contextParam.getValue().equals(paramValue)) continue;
            contextParamsToRemove.add(contextParam);
        }
        webapp.getContextParams().removeAll(contextParamsToRemove);
    }

    public static List<String> getContextParamValues(WebApp webapp, String paramName) {
        ParamValue param = WebXmlUtilsForJ2EE.findContextParam(webapp, paramName);
        if (param == null) {
            return null;
        }
        ArrayList<String> paramValueStrings = new ArrayList<String>();
        String[] stringArray = param.getValue().trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String paramValueString = stringArray[n2];
            paramValueStrings.add(paramValueString.trim());
            ++n2;
        }
        return paramValueStrings;
    }

    public static void addListener(WebApp webapp, String listenerClass) {
        if (WebXmlUtilsForJ2EE.existsListener(webapp, listenerClass)) {
            return;
        }
        Listener listener = CommonFactory.eINSTANCE.createListener();
        listener.setListenerClassName(listenerClass);
        webapp.getListeners().add((Object)listener);
    }

    public static void removeListener(WebApp webapp, Listener listenerClass) {
        webapp.getListeners().remove((Object)listenerClass);
    }

    public static void removeListener(WebApp webapp, String listenerClass) {
        Listener listenerToRemove = WebXmlUtilsForJ2EE.findListener(webapp, listenerClass);
        if (listenerClass != null) {
            WebXmlUtilsForJ2EE.removeListener(webapp, listenerToRemove);
        }
    }

    public static boolean existsListener(WebApp webapp, String listenerClass) {
        return WebXmlUtilsForJ2EE.findListener(webapp, listenerClass) != null;
    }

    public static Listener findListener(WebApp webapp, String listenerClass) {
        for (Object listener : webapp.getListeners()) {
            if (!((Listener)listener).getListenerClassName().equals(listenerClass)) continue;
            return (Listener)listener;
        }
        return null;
    }
}

