/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp;

import java.net.URL;
import java.net.URLClassLoader;
import oracle.eclipse.tools.common.internal.OracleCommonToolsPlugin;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.validation.IValidatorUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ValidatorUtil {
    public static final String WSDL_VALIDATOR_UNIQUE_NAME = "org.eclipse.wst.wsdl.validation.wsdl";
    public static final String XML_VALIDATOR_UNIQUE_NAME = "org.eclipse.wst.xml.core.xml";
    public static final String EJB_VALIDATOR_UNIQUE_NAME = "org.eclipse.jst.j2ee.internal.ejb.workbench.validation.UIEjbValidator";
    private static IValidatorUtil validatorUtil;

    static {
        String className;
        ClassLoader classLoader;
        Version sr2Version = new Version("1.2.6.v200901282045");
        Bundle validationBundle = Platform.getBundle((String)"org.eclipse.wst.validation");
        Version installedVersion = new Version(String.valueOf(validationBundle.getHeaders().get("Bundle-Version")));
        if (sr2Version.compareTo(installedVersion) > 0) {
            Path jarPath = new Path("lib/sr1validator.jar");
            URL[] urls = new URL[]{FileLocator.find((Bundle)OracleCommonToolsPlugin.getBundle(), (IPath)jarPath, null)};
            classLoader = new URLClassLoader(urls, IValidatorUtil.class.getClassLoader());
            className = "oracle.eclipse.tools.common.util.wtp.validation.internal.SR1ValidatorUtil";
        } else {
            classLoader = IValidatorUtil.class.getClassLoader();
            className = "oracle.eclipse.tools.common.util.wtp.validation.internal.ProvisionalValidatorUtil";
        }
        try {
            validatorUtil = (IValidatorUtil)classLoader.loadClass(className).newInstance();
        }
        catch (Exception exception) {
            LoggingService.logError("oracle.eclipse.tools.common", "Unable to load implementation of Validator Util");
            validatorUtil = new IValidatorUtil(){

                @Override
                public void addExcludeFileToWorkspaceV2Validator(String validatorId, String relativeDirectoryToExclude) {
                }

                @Override
                public void disableValidation(IProject project, String ... validatorsToDisable) throws CoreException {
                }

                @Override
                public void addExcludeFileToProjectValidator(IProject project, String validatorId, String relativeDirectoryToExclude) {
                }
            };
        }
    }

    public static synchronized void disableValidation(IProject project, String ... validatorsToDisable) throws CoreException {
        validatorUtil.disableValidation(project, validatorsToDisable);
    }

    public static void addExcludeFileToWorkspaceV2Validator(String validatorId, String relativeDirectoryToExclude) {
        validatorUtil.addExcludeFileToWorkspaceV2Validator(validatorId, relativeDirectoryToExclude);
    }

    public static synchronized void addExcludeFileToProjectValidator(IProject project, String validatorId, String relativeDirectoryToExclude) throws CoreException {
        validatorUtil.addExcludeFileToProjectValidator(project, validatorId, relativeDirectoryToExclude);
    }
}

