/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetPreferences;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetPreferencesGroup;
import org.eclipse.wst.common.project.facet.core.util.internal.DomUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.FileUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.XmlWriter;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Element;

public final class ProjectFacetPreferencesMetatdata {
    private ProjectFacetPreferencesGroup prefGroup = null;
    private static final String PATH_IN_PROJECT = ".settings/org.eclipse.wst.common.project.facet.core.prefs.xml";
    private static final String PATH_IN_WORKSPACE = ".metadata/.plugins/org.eclipse.wst.common.project.facet.core/prefs.xml";
    private static final String EL_ROOT = "root";
    private static final String EL_FACET = "facet";
    private static final String EL_NODE = "node";
    private static final String EL_ATTRIBUTE = "attribute";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private final IFacetedProject project;
    private final LinkedHashMap<String, ProjectFacetPreferences> preferences;

    public ProjectFacetPreferencesMetatdata(IFacetedProject project) throws BackingStoreException {
        this.prefGroup = new ProjectFacetPreferencesGroup(project);
        this.project = project;
        this.preferences = new LinkedHashMap();
        InputStream in = this.getBackingFileContents();
        if (in != null) {
            try {
                try {
                    InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(in), "UTF-8");
                    for (Element elFacet : DomUtil.elements((Element)DomUtil.root((Reader)reader), (String)EL_FACET)) {
                        String facetId = elFacet.getAttribute(ATTR_ID);
                        ProjectFacetPreferences root = new ProjectFacetPreferences(this.prefGroup, facetId, project);
                        this.read(root, elFacet);
                        this.preferences.put(facetId, root);
                    }
                }
                catch (Exception e) {
                    throw new BackingStoreException(e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectFacetPreferences getPreferences(String facetId) throws BackingStoreException {
        ProjectFacetPreferences prefs;
        boolean saveNeeded = false;
        ProjectFacetPreferencesMetatdata projectFacetPreferencesMetatdata = this;
        synchronized (projectFacetPreferencesMetatdata) {
            prefs = this.preferences.get(facetId);
            if (prefs == null) {
                prefs = new ProjectFacetPreferences(this.prefGroup, facetId, this.project);
                this.preferences.put(facetId, prefs);
                saveNeeded = true;
            }
        }
        if (saveNeeded) {
            this.save();
        }
        return prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreferences(String facetId) throws BackingStoreException {
        ProjectFacetPreferencesMetatdata projectFacetPreferencesMetatdata = this;
        synchronized (projectFacetPreferencesMetatdata) {
            this.preferences.remove(facetId);
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws BackingStoreException {
        try {
            File file = this.getBackingFile();
            StringWriter w = null;
            ProjectFacetPreferencesMetatdata projectFacetPreferencesMetatdata = this;
            synchronized (projectFacetPreferencesMetatdata) {
                if (!this.preferences.isEmpty()) {
                    w = new StringWriter();
                    this.write(w);
                }
            }
            if (w == null) {
                FileUtil.deleteFile((File)file);
            } else {
                FileUtil.writeFile((File)file, (String)w.toString());
            }
        }
        catch (IOException e) {
            throw new BackingStoreException(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            throw new BackingStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private File getBackingFile() {
        File file;
        if (this.project != null) {
            IFile f = this.project.getProject().getFile(PATH_IN_PROJECT);
            file = f.getLocation().toFile();
        } else {
            File wsroot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            file = new File(wsroot, PATH_IN_WORKSPACE);
        }
        return file;
    }

    private InputStream getBackingFileContents() throws BackingStoreException {
        InputStream in = null;
        if (this.project != null) {
            IFile f = this.project.getProject().getFile(PATH_IN_PROJECT);
            if (f.exists()) {
                try {
                    in = f.getContents();
                }
                catch (CoreException e) {
                    throw new BackingStoreException(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            File wsroot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            File file = new File(wsroot, PATH_IN_WORKSPACE);
            if (file.exists()) {
                try {
                    in = new FileInputStream(file);
                }
                catch (IOException e) {
                    throw new BackingStoreException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return in;
    }

    private void read(ProjectFacetPreferences preferences, Element node) {
        String name;
        for (Element elAttr : DomUtil.elements((Element)node, (String)EL_ATTRIBUTE)) {
            name = elAttr.getAttribute(ATTR_NAME);
            String value = elAttr.getAttribute(ATTR_VALUE);
            preferences.put(name, value);
        }
        for (Element elNode : DomUtil.elements((Element)node, (String)EL_NODE)) {
            name = elNode.getAttribute(ATTR_NAME);
            ProjectFacetPreferences child = (ProjectFacetPreferences)preferences.node(name);
            this.read(child, elNode);
        }
    }

    private void write(Writer w) throws IOException, BackingStoreException {
        XmlWriter xml = new XmlWriter(w);
        xml.startElement(EL_ROOT);
        for (Map.Entry<String, ProjectFacetPreferences> entry : this.preferences.entrySet()) {
            xml.startElement(EL_FACET);
            xml.addAttribute(ATTR_ID, entry.getKey());
            this.write(xml, (Preferences)entry.getValue());
            xml.endElement();
        }
        xml.endElement();
        xml.flush();
    }

    private void write(XmlWriter xml, Preferences preferences) throws IOException, BackingStoreException {
        String[] stringArray = preferences.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            xml.startElement(EL_ATTRIBUTE);
            xml.addAttribute(ATTR_NAME, key);
            xml.addAttribute(ATTR_VALUE, preferences.get(key, null));
            xml.endElement();
            ++n2;
        }
        stringArray = preferences.childrenNames();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String childName = stringArray[n2];
            Preferences child = preferences.node(childName);
            xml.startElement(EL_NODE);
            xml.addAttribute(ATTR_NAME, child.name());
            this.write(xml, child);
            xml.endElement();
            ++n2;
        }
    }
}

