/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.ValidateEditUtil;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.internal.modulecore.util.ArchiveManifest;
import org.eclipse.jst.common.internal.modulecore.util.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class J2EEProjectDependencyUtil {
    public static final IPath DOT_COMPONENT_PATH = new Path(".settings").append(".component");
    private static ResourceLoader _resourceLoader = new ResourceLoader(J2EEProjectDependencyUtil.class);

    public static void addDependency(IProject sourceProject, IProject targetProject, IProject earProject, IProgressMonitor monitor) throws ExecutionException {
        J2EEProjectDependencyUtil.checkProject(sourceProject, "Source");
        J2EEProjectDependencyUtil.checkProject(targetProject, "Target");
        J2EEProjectDependencyUtil.checkProject(earProject, "EAR");
        assert (WtpProjectUtil.isEarProject(earProject)) : "EAR project does not have jst.ear facet";
        IVirtualComponent sourceComponent = ComponentCore.createComponent((IProject)sourceProject);
        IVirtualComponent targetComponent = ComponentCore.createComponent((IProject)targetProject);
        List<IProject> earProjects = J2EEProjectDependencyUtil.getEARProjects(earProject);
        assert (J2EEProjectDependencyUtil.referencedByEAR(earProjects, sourceProject)) : "Source project is not referenced by EAR project";
        assert (J2EEProjectDependencyUtil.referencedByEAR(earProjects, targetProject)) : "Target project is not referenced by EAR project";
        J2EEProjectDependencyUtil.addModuleDependency(sourceComponent, targetComponent, monitor);
    }

    protected static void checkProject(IProject project, String label) {
        assert (project != null) : String.valueOf(label) + " project cannot be null";
        assert (project.exists()) : String.valueOf(label) + " project must exist";
        assert (project.isOpen()) : String.valueOf(label) + " project must be open";
    }

    public static void addWebLibDependency(IVirtualComponent sourceComp, IVirtualComponent targetComp, boolean projectRef, boolean webLibRef, IProgressMonitor monitor) throws ExecutionException {
        assert (sourceComp != null) : "Source IVirtualComponent cannot be null";
        assert (targetComp != null) : "Target IVirtualComponent cannot be null";
        assert (WtpProjectUtil.isDynamicWebProject(sourceComp.getProject())) : "Source project does not have jst.web facet";
        IDataModel refdm = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        List targetCompList = (List)refdm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        targetCompList.add(targetComp);
        refdm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComp);
        refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)targetCompList);
        refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/WEB-INF/lib");
        refdm.getDefaultOperation().execute(monitor, null);
    }

    public static void addModuleDependency(IVirtualComponent sourceComp, IVirtualComponent targetComp, IProgressMonitor monitor) throws ExecutionException {
        assert (sourceComp != null) : "Source IVirtualComponent cannot be null";
        assert (targetComp != null) : "Target IVirtualComponent cannot be null";
        J2EEProjectDependencyUtil.updateManifestDependency(sourceComp, targetComp, monitor);
    }

    public static boolean requires1_0_XModuleDependencyUpdate(IProject project) throws CoreException {
        if (project.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") && project.findMember(DOT_COMPONENT_PATH) != null) {
            IVirtualReference[] refs;
            if (WtpProjectUtil.isEarProject(project)) {
                return false;
            }
            boolean isJavaProject = JavaProjectUtil.isJavaProject(project);
            IVirtualComponent source = ComponentCore.createComponent((IProject)project);
            IVirtualReference[] iVirtualReferenceArray = refs = source.getReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualReference ref = iVirtualReferenceArray[n2];
                IVirtualComponent target = ref.getReferencedComponent();
                IProject targetProject = target.getProject();
                if (isJavaProject) {
                    IClasspathEntry[] entries;
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
                    int n3 = entries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry entry = iClasspathEntryArray[n4];
                        if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)targetProject.getFullPath())) {
                            return true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public static void update1_0_XModuleDependencies(IProject project, IProgressMonitor monitor) throws CoreException, ExecutionException {
        IVirtualReference[] refs;
        J2EEProjectDependencyUtil.checkProject(project, "source");
        if (WtpProjectUtil.isEarProject(project)) {
            return;
        }
        boolean isJavaProject = JavaProjectUtil.isJavaProject(project);
        boolean isWeb = WtpProjectUtil.isDynamicWebProject(project);
        IVirtualComponent source = ComponentCore.createComponent((IProject)project);
        IVirtualReference[] iVirtualReferenceArray = refs = source.getReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            IVirtualComponent target = ref.getReferencedComponent();
            IProject targetProject = target.getProject();
            if (isWeb && ref.getRuntimePath().equals((Object)new Path("/WEB-INF/lib"))) {
                if (isJavaProject) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    JavaUtil.removeFromClasspath(javaProject, targetProject.getFullPath());
                }
            } else {
                IProjectDescription desc = project.getDescription();
                IProject[] projectRefs = desc.getReferencedProjects();
                ArrayList<IProject> newRefs = new ArrayList<IProject>();
                IProject[] iProjectArray = projectRefs;
                int n3 = projectRefs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject p = iProjectArray[n4];
                    if (!p.equals((Object)targetProject)) {
                        newRefs.add(p);
                    }
                    ++n4;
                }
                desc.setReferencedProjects(newRefs.toArray(new IProject[newRefs.size()]));
                if (isJavaProject) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    JavaUtil.removeFromClasspath(javaProject, targetProject.getFullPath());
                }
                IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
                model.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)source);
                List modHandlesList = (List)model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                modHandlesList.add(target);
                model.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modHandlesList);
                model.getDefaultOperation().execute(monitor, null);
            }
            ++n2;
        }
    }

    public static void addEARDependency(IProject earProject, IProject targetProject, IProgressMonitor monitor) throws ExecutionException {
        J2EEProjectDependencyUtil.checkProject(earProject, "EAR");
        J2EEProjectDependencyUtil.checkProject(targetProject, "Target");
        assert (WtpProjectUtil.isEarProject(earProject)) : "EAR project does not have jst.ear facet";
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        IVirtualComponent targetComp = ComponentCore.createComponent((IProject)targetProject);
        assert (earComp != null) : "EAR project does not have ModuleCoreNature";
        assert (targetComp != null) : "Target project does not have ModuleCoreNature";
        List<IProject> earProjects = J2EEProjectDependencyUtil.getEARProjects(earProject);
        if (J2EEProjectDependencyUtil.referencedByEAR(earProjects, targetProject)) {
            return;
        }
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
        ArrayList<IVirtualComponent> depList = new ArrayList<IVirtualComponent>();
        depList.add(targetComp);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", depList);
        dm.getDefaultOperation().execute(monitor, null);
    }

    public static void updateManifestDependency(IVirtualComponent sourceComp, IVirtualComponent targetComp, IProgressMonitor monitor) throws ExecutionException {
        IVirtualFile vf = sourceComp.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile manifestmf = null;
        IFile[] files = vf.getUnderlyingFiles();
        if (files.length == 1) {
            manifestmf = files[0];
        } else {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                if (f.exists()) {
                    manifestmf = f;
                    break;
                }
                ++n2;
            }
        }
        if (manifestmf == null) {
            throw new ExecutionException(_resourceLoader.resource("error-reading-manifest", new Object[0]));
        }
        J2EEProjectDependencyUtil.updateManifestDependency(sourceComp.getProject(), targetComp.getProject(), manifestmf, monitor);
    }

    public static void updateManifestDependency(IProject dependentProject, IProject targetProject, IFile manifestmf, IProgressMonitor monitor) throws ExecutionException {
        IStatus status = ValidateEditUtil.validateEdit(manifestmf);
        if (!status.isOK()) {
            throw new ExecutionException(status.getMessage());
        }
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel((IDataModelProvider)new UpdateManifestDataModelProvider());
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)dependentProject.getName());
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
        ArchiveManifest manifest = J2EEProjectDependencyUtil.getArchiveManifest(manifestmf);
        String[] cp = manifest.getClassPathTokenized();
        ArrayList<String> cpList = new ArrayList<String>();
        String newCp = String.valueOf(targetProject.getName()) + ".jar";
        int i = 0;
        while (i < cp.length) {
            if (!cp[i].equals(newCp)) {
                cpList.add(cp[i]);
            }
            ++i;
        }
        cpList.add(newCp);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", cpList);
        updateManifestDataModel.getDefaultOperation().execute(monitor, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArchiveManifest getArchiveManifest(IFile manifestFile) throws ExecutionException {
        ArchiveManifestImpl archiveManifestImpl;
        InputStream in = null;
        try {
            ArchiveManifestImpl mf;
            in = manifestFile.getContents();
            archiveManifestImpl = mf = new ArchiveManifestImpl(new Manifest(in));
            if (in == null) return archiveManifestImpl;
        }
        catch (CoreException ce) {
            try {
                throw new ExecutionException(_resourceLoader.resource("error-reading-manifest", new Object[0]), (Throwable)ce);
                catch (IOException io) {
                    throw new ExecutionException(_resourceLoader.resource("error-reading-manifest", new Object[0]), (Throwable)io);
                }
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            in.close();
            return archiveManifestImpl;
        }
        catch (IOException iOException) {}
        return archiveManifestImpl;
    }

    protected static boolean referencedByEAR(List<IProject> earProjects, IProject project) {
        for (IProject earProject : earProjects) {
            if (!earProject.equals((Object)project)) continue;
            return true;
        }
        return false;
    }

    public static final List<IProject> getEARProjects(IProject earProject) {
        IVirtualReference[] refComponents;
        J2EEProjectDependencyUtil.checkProject(earProject, "EAR");
        ArrayList<IProject> result = new ArrayList<IProject>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)earProject);
        IVirtualReference[] iVirtualReferenceArray = refComponents = component.getReferences();
        int n = refComponents.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            IVirtualComponent comp = ref.getReferencedComponent();
            if (comp != null && comp.getProject() != null) {
                result.add(comp.getProject());
            }
            ++n2;
        }
        return Collections.unmodifiableList(result);
    }
}

