/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.system.ServiceRunnable;

public abstract class AbstractServiceRunnable
implements ServiceRunnable {
    private final String name;
    private List<Throwable> exceptions;
    private boolean done;
    private boolean outcome;
    private boolean started;
    private final Object mutex;
    private Thread thread = null;

    protected AbstractServiceRunnable() {
        this(null);
    }

    protected AbstractServiceRunnable(String name) {
        this.name = name;
        this.mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: {
            AbstractServiceRunnable abstractServiceRunnable = this;
            synchronized (abstractServiceRunnable) {
                if (this.started) {
                    throw new IllegalStateException("run() method may only be called once");
                }
                this.thread = Thread.currentThread();
                this.started = true;
            }
            try {
                try {
                    this.runLocal();
                }
                catch (Exception e) {
                    this.addException(e);
                    this.done = true;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.done = true;
                throw throwable;
            }
            this.done = true;
        }
        this.doNotify();
    }

    protected abstract void runLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doNotify() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    public void join() throws InterruptedException {
        this.join(0L);
    }

    public void join(long millis) throws InterruptedException {
        if (this.thread == null) {
            throw new IllegalStateException("no thread assigned to runnable");
        }
        this.thread.join(millis);
    }

    public void waitTillStarted(long loopInterval) {
        while (!this.isStarted()) {
            try {
                this.waitForStart(loopInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void waitForStart(long loopInterval) throws InterruptedException {
        while (!this.isStarted()) {
            Thread.sleep(loopInterval);
        }
    }

    protected void interrupt() {
        if (this.thread == null) {
            return;
        }
        this.thread.interrupt();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean getOutcome() {
        if (!this.isDone()) {
            return false;
        }
        if (this.isFailed()) {
            return false;
        }
        return this.outcome;
    }

    protected void setOutcome() {
        this.setOutcome(true);
    }

    protected void setOutcome(boolean outcome) {
        this.outcome = outcome;
    }

    @Override
    public boolean isFailed() {
        return this.getExceptionCount() != 0;
    }

    @Override
    public int getExceptionCount() {
        if (this.exceptions == null) {
            return 0;
        }
        return this.exceptions.size();
    }

    @Override
    public Throwable getException(int index) {
        if (this.exceptions == null) {
            return null;
        }
        return this.exceptions.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addException(Throwable t) {
        AbstractServiceRunnable abstractServiceRunnable = this;
        synchronized (abstractServiceRunnable) {
            if (this.exceptions == null) {
                this.exceptions = Collections.synchronizedList(new ArrayList());
            }
        }
        this.exceptions.add(t);
    }
}

