/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import oracle.eclipse.tools.common.util.stream.StreamListener;
import oracle.eclipse.tools.common.util.system.AbstractServiceRunnable;

public class StreamCaptureService
extends AbstractServiceRunnable {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    private final InputStream input;
    private final StreamListener listener;
    private boolean listenerFailed = false;

    public StreamCaptureService(String name, InputStream input) {
        this(name, input, null);
    }

    public StreamCaptureService(String name, InputStream input, StreamListener listener) {
        super(name);
        this.input = input;
        if (listener == null) {
            listener = new NullListener();
        }
        this.listener = listener;
    }

    public StreamListener getListener() {
        return this.listener;
    }

    @Override
    protected void runLocal() {
        int size = this.getBufferSize();
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(this.input, StandardCharsets.UTF_8));
                char[] buf = new char[size];
                int cnt = -2;
                while ((cnt = reader.read(buf, 0, size)) > -1) {
                    if (this.listenerFailed) continue;
                    this.write(buf, 0, cnt);
                }
            }
            catch (IOException ioe) {
                this.addException(new RuntimeException("exception encountered reading stream( " + this.getName() + " ), exception( " + ioe.getMessage() + " )", ioe));
                try {
                    this.cleanup();
                }
                catch (IOException e) {
                    this.addException(new RuntimeException("failed to cleanup listener( " + this.listener + " ), exception( " + e.getMessage() + " )", e));
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        this.addException(new RuntimeException("failed to close stream reader( " + this.getName() + " ), exception( " + e.getMessage() + " )", e));
                    }
                }
                if (this.getExceptionCount() == 0) {
                    this.setOutcome();
                }
            }
        }
        finally {
            try {
                this.cleanup();
            }
            catch (IOException e) {
                this.addException(new RuntimeException("failed to cleanup listener( " + this.listener + " ), exception( " + e.getMessage() + " )", e));
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.addException(new RuntimeException("failed to close stream reader( " + this.getName() + " ), exception( " + e.getMessage() + " )", e));
                }
            }
            if (this.getExceptionCount() == 0) {
                this.setOutcome();
            }
        }
    }

    private void write(char[] buf, int offset, int len) {
        if (this.listenerFailed) {
            return;
        }
        try {
            this.listener.write(buf, offset, len);
        }
        catch (Exception e) {
            this.listenerFailed = true;
            this.addException(new RuntimeException("exception encountered writing to listener( " + this.listener + " ), in stream service( " + this.getName() + " ), exception( " + e.getMessage() + " )", e));
        }
    }

    public void cleanup() throws IOException {
        if (this.listener != null) {
            this.listener.cleanup();
        }
    }

    protected int getBufferSize() {
        return 512;
    }

    public static class NullListener
    implements StreamListener {
        @Override
        public void write(char[] buf, int offset, int len) {
        }

        @Override
        public void write(String data) {
        }

        @Override
        public void cleanup() {
        }
    }
}

