/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.performance;

import java.text.NumberFormat;
import oracle.eclipse.tools.common.util.performance.BasicAccumulator;

public class Accumulator
extends BasicAccumulator {
    private boolean minSet = false;
    private double min = 0.0;
    private boolean maxSet = false;
    private double max = 0.0;
    private double first = 0.0;
    private double last = 0.0;

    public Accumulator() {
        this(null);
    }

    public Accumulator(String name) {
        this(name, null);
    }

    public Accumulator(String name, String description) {
        super(name, description);
    }

    public void addOp(double opValue) {
        this.total += opValue;
        ++this.opCount;
        this.updateMinMax(opValue);
        this.last = opValue;
    }

    public void addWeightedAvg(double opValue, int count) {
        this.total += opValue * (double)count;
        this.opCount += (long)count;
        this.updateMinMax(opValue);
        this.last = opValue;
    }

    @Override
    public String getAvgString(NumberFormat format) {
        if (format == null) {
            return Double.toString(this.avg());
        }
        return format.format(this.avg());
    }

    protected void updateMinMax(double opValue) {
        if (!this.minSet) {
            this.minSet = true;
            this.min = opValue;
            this.first = opValue;
        }
        if (!this.maxSet) {
            this.maxSet = true;
            this.max = opValue;
        }
        if (opValue < this.min) {
            this.min = opValue;
        } else if (opValue > this.max) {
            this.max = opValue;
        }
    }

    public double getMin() {
        return this.min;
    }

    public String getMinString(NumberFormat format) {
        if (format == null) {
            return Double.toString(this.min);
        }
        return format.format(this.min);
    }

    public double getMax() {
        return this.max;
    }

    public String getMaxString(NumberFormat format) {
        if (format == null) {
            return Double.toString(this.max);
        }
        return format.format(this.max);
    }

    public double getFirst() {
        return this.first;
    }

    public String getFirstString(NumberFormat format) {
        if (format == null) {
            return Double.toString(this.first);
        }
        return format.format(this.first);
    }

    public double getLast() {
        return this.last;
    }

    public String getLastString(NumberFormat format) {
        if (format == null) {
            return Double.toString(this.last);
        }
        return format.format(this.last);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(NumberFormat format) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("[ ");
        sb.append("name( " + this.name + " )");
        sb.append(", opCount( " + this.opCount + " )");
        sb.append(", total( " + this.getTotalString(format) + " )");
        sb.append(", avg( " + this.getAvgString(format) + " )");
        sb.append(", min( " + this.getMinString(format) + " )");
        sb.append(", max( " + this.getMaxString(format) + " )");
        sb.append(", first( " + this.getFirstString(format) + " )");
        sb.append(", last( " + this.getLastString(format) + " )");
        sb.append(", description( " + this.description + " )");
        sb.append(" ]");
        return sb.toString();
    }
}

