/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.jdt;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ClasspathUtil {
    public static String createClasspathString(List<IPath> cp) {
        assert (cp != null) : "IPath list cannot be null";
        assert (!cp.isEmpty()) : "IPath list cannot be empty";
        StringBuilder cpBuilder = new StringBuilder();
        int i = 0;
        for (IPath path : cp) {
            if (i++ > 0) {
                cpBuilder.append(File.pathSeparator);
            }
            cpBuilder.append(path.toOSString());
        }
        return cpBuilder.toString();
    }

    public static List<IPath> createClasspath(IJavaProject javaProject) throws JavaModelException {
        ArrayList<IPath> cp = new ArrayList<IPath>();
        ClasspathUtil.createClasspathInternal(javaProject, cp, false, new HashSet<IProject>());
        return cp;
    }

    private static void createClasspathInternal(IJavaProject javaProject, List<IPath> cp, boolean dependentProject, Set<IProject> processedProjects) throws JavaModelException {
        IProject proj = javaProject.getProject();
        processedProjects.add(proj);
        IWorkspaceRoot root = proj.getWorkspace().getRoot();
        IClasspathEntry[] classpath = javaProject.getResolvedClasspath(true);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            switch (entry.getEntryKind()) {
                case 1: {
                    if (dependentProject && !entry.isExported()) break;
                    IPath libPath = entry.getPath();
                    IResource wsResource = root.findMember(libPath);
                    if (wsResource != null) {
                        ClasspathUtil.addCPEntry(cp, wsResource.getLocation());
                        break;
                    }
                    ClasspathUtil.addCPEntry(cp, libPath);
                    break;
                }
                case 3: {
                    IResource wsResource;
                    IPath outputLocation = entry.getOutputLocation();
                    if (outputLocation == null) {
                        outputLocation = javaProject.getOutputLocation();
                    }
                    if ((wsResource = root.findMember(outputLocation)) != null) {
                        ClasspathUtil.addCPEntry(cp, wsResource.getLocation());
                        break;
                    }
                    ClasspathUtil.addCPEntry(cp, root.getLocation().append(outputLocation.makeRelative()));
                    break;
                }
                case 2: {
                    IPath path = entry.getPath();
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                    if (project == null || !project.isAccessible() || processedProjects.contains(project)) break;
                    ClasspathUtil.createClasspathInternal(JavaCore.create((IProject)project), cp, true, processedProjects);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
    }

    private static void addCPEntry(List<IPath> cp, IPath entry) {
        if (!cp.contains(entry)) {
            cp.add(entry);
        }
    }

    public static Pair<JavaUtil.ClassPathContainment, IPath> getContainerClasspathContainment(IContainer selectedContainer) {
        List<IPath> rootPaths;
        Pair<JavaUtil.ClassPathContainment, Object> containmentPair = new Pair<JavaUtil.ClassPathContainment, Object>(JavaUtil.ClassPathContainment.NONE, null);
        if (selectedContainer != null && !(rootPaths = JavaUtil.getFullSourcePaths(selectedContainer)).isEmpty()) {
            containmentPair = JavaUtil.isOnClasspathTree(selectedContainer, rootPaths);
        }
        return containmentPair;
    }

    public static List<IPath> getPluginClasspath(String bundleId) throws CoreException {
        assert (bundleId != null) : "Bundle ID cannot be null";
        Bundle bundle = Platform.getBundle((String)bundleId);
        assert (bundle != null) : "Bundle cannot be null: <" + bundleId + ">";
        return ClasspathUtil.getPluginClasspath(bundle);
    }

    public static List<IPath> getPluginClasspath(Bundle bundle) throws CoreException {
        assert (bundle != null) : "Bundle cannot be null";
        ArrayList<IPath> libs = new ArrayList<IPath>();
        try {
            ClasspathUtil.getPluginClasspath(bundle, libs);
        }
        catch (MalformedURLException mulre) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common", 0, mulre.getLocalizedMessage(), (Throwable)mulre));
        }
        catch (IOException ioe) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common", 0, ioe.getLocalizedMessage(), (Throwable)ioe));
        }
        catch (BundleException be) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common", 0, be.getLocalizedMessage(), (Throwable)be));
        }
        return libs;
    }

    private static void getPluginClasspath(Bundle bundle, List<IPath> libs) throws MalformedURLException, IOException, BundleException {
        String requires;
        int n;
        URL installURL = FileLocator.toFileURL((URL)bundle.getEntry("/"));
        Path installPath = new Path(new File(installURL.getPath()).getAbsolutePath());
        Dictionary headers = bundle.getHeaders();
        String classpath = (String)headers.get("Bundle-ClassPath");
        if (classpath != null) {
            ManifestElement[] elements;
            ManifestElement[] manifestElementArray = elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpath);
            n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                IPath libPath = installPath.append(element.getValue());
                if (!libs.contains(libPath)) {
                    libs.add(libPath);
                }
                ++n2;
            }
        }
        if ((requires = (String)headers.get("Require-Bundle")) != null) {
            ManifestElement[] requiresElements;
            ManifestElement[] manifestElementArray = requiresElements = ManifestElement.parseHeader((String)"Require-Bundle", (String)requires);
            int n3 = requiresElements.length;
            n = 0;
            while (n < n3) {
                Bundle depBundle;
                ManifestElement element = manifestElementArray[n];
                String visibility = element.getDirective("visibility");
                if (visibility != null && visibility.equals("reexport") && (depBundle = Platform.getBundle((String)element.getValue())) != null) {
                    ClasspathUtil.getPluginClasspath(depBundle, libs);
                }
                ++n;
            }
        }
    }

    public static void createUserLibrary(final String libName, final List<File> libraryJars) {
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)"org.eclipse.jdt.USER_LIBRARY");
        IJavaProject jproject = ClasspathUtil.createPlaceholderProject();
        final IPath containerPath = new Path("org.eclipse.jdt.USER_LIBRARY").append(libName);
        try {
            initializer.requestClasspathContainerUpdate(containerPath, jproject, new IClasspathContainer(){

                public IClasspathEntry[] getClasspathEntries() {
                    IClasspathEntry[] ret = new IClasspathEntry[libraryJars.size()];
                    int i = 0;
                    while (i < libraryJars.size()) {
                        String path = ((File)libraryJars.get(i)).getAbsolutePath();
                        ret[i] = JavaCore.newLibraryEntry((IPath)new Path(path), null, null, (boolean)false);
                        ++i;
                    }
                    return ret;
                }

                public String getDescription() {
                    return libName;
                }

                public int getKind() {
                    return 1;
                }

                public IPath getPath() {
                    return containerPath;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static IJavaProject createPlaceholderProject() {
        StringBuilder name = new StringBuilder("####internal");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name.toString())).exists()) {
            name.append('1');
        }
        return JavaCore.create((IProject)project);
    }
}

