/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.fileio.virtualfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.eclipse.tools.common.util.fileio.virtualfs.ConflictingPathsException;

public final class VirtualFileSystem {
    public static final String PAT_DIRECT_DESC = "*";
    public static final String PAT_DIRECT_DESC_OR_SELF = ".*";
    public static final String PAT_ALL_DESC = "**";
    public static final String PAT_ALL_DESC_OR_SELF = ".**";
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Win");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final ArrayList<Link> links = new ArrayList();

    public void link(String source, String target) throws ConflictingPathsException {
        Link link = new Link(source, target);
        if (!this.links.contains(link)) {
            this.links.add(link);
        }
    }

    public void unlink(String sourcePattern, String targetPattern) {
        Link[] res = this.search(sourcePattern, targetPattern);
        int i = 0;
        while (i < res.length) {
            this.links.remove(res[i]);
            ++i;
        }
    }

    public Link[] search(String sourcePattern, String targetPattern) {
        ArrayList<Link> res = new ArrayList<Link>();
        String[] splitSourcePattern = VirtualFileSystem.split(sourcePattern);
        String[] splitTargetPattern = VirtualFileSystem.split(targetPattern);
        for (Link link : this.links) {
            String[] splitSource = VirtualFileSystem.split(link.getSourcePath());
            String[] splitTarget = VirtualFileSystem.split(link.getTargetPath());
            if (!VirtualFileSystem.match(splitSource, splitSourcePattern) || !VirtualFileSystem.match(splitTarget, splitTargetPattern)) continue;
            res.add(link);
        }
        return res.toArray(new Link[res.size()]);
    }

    private static boolean match(String[] path, String[] pattern) {
        if (pattern == null) {
            return true;
        }
        int i = 0;
        while (i < path.length && i < pattern.length) {
            String x = path[i];
            String y = pattern[i];
            if (IS_WINDOWS && !x.equalsIgnoreCase(y) || !IS_WINDOWS && !x.equals(y)) {
                boolean isLast;
                boolean bl = isLast = i + 1 == path.length;
                return y.equals(PAT_ALL_DESC) || y.equals(PAT_ALL_DESC_OR_SELF) || y.equals(PAT_DIRECT_DESC) && isLast || y.equals(PAT_DIRECT_DESC_OR_SELF) && isLast;
            }
            ++i;
        }
        if (i < path.length) {
            return false;
        }
        if (i < pattern.length) {
            String y = pattern[i];
            return i + 1 == pattern.length && (y.equals(PAT_DIRECT_DESC_OR_SELF) || y.equals(PAT_ALL_DESC_OR_SELF));
        }
        return true;
    }

    public String[] list(String dir) {
        HashSet<String> res = new HashSet<String>();
        String normalized = VirtualFileSystem.normalize(dir);
        File[] fileArray = this.resolve(dir);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                String[] children = f.list();
                int j = 0;
                while (j < children.length) {
                    res.add(String.valueOf(normalized) + "/" + children[j]);
                    ++j;
                }
            } else {
                throw new IllegalArgumentException("not a directory");
            }
            ++n2;
        }
        return res.toArray(new String[res.size()]);
    }

    public File[] resolve(String path) {
        String[] splitPath = VirtualFileSystem.split(path);
        ArrayList<File> res = new ArrayList<File>();
        for (Link link : this.links) {
            String[] splitTarget = VirtualFileSystem.split(link.getTargetPath());
            int j = 0;
            while (j < splitPath.length && j < splitTarget.length) {
                String x = splitPath[j];
                String y = splitTarget[j];
                if (IS_WINDOWS && !x.equalsIgnoreCase(y) || !IS_WINDOWS && !x.equals(y)) break;
                ++j;
            }
            if (j != splitTarget.length) continue;
            if (j == splitPath.length) {
                res.add(new File(link.getSourcePath()));
                continue;
            }
            String p = String.valueOf(link.getSourcePath()) + "/" + VirtualFileSystem.merge(splitPath, j, splitPath.length - j);
            res.add(new File(p));
        }
        Iterator itr = res.iterator();
        while (itr.hasNext()) {
            if (((File)itr.next()).exists()) continue;
            itr.remove();
        }
        return res.toArray(new File[res.size()]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Link link : this.links) {
            link.toString(buf);
            buf.append(LINE_SEPARATOR);
        }
        return buf.toString();
    }

    private static String[] split(String str) {
        if (str == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(str, "/\\");
        String[] res = new String[tokens.countTokens()];
        int i = 0;
        while (i < res.length) {
            res[i] = tokens.nextToken();
            ++i;
        }
        return res;
    }

    private static String merge(String[] strs, int start, int count) {
        StringBuffer buf = new StringBuffer();
        int i = start;
        int n = start + count;
        while (i < n) {
            if (i != start) {
                buf.append('/');
            }
            buf.append(strs[i]);
            ++i;
        }
        return buf.toString();
    }

    private static String normalize(String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            try {
                path = f.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((path = path.replace(File.separatorChar, '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static final class Link {
        private String source;
        private String target;

        private Link(String source, String target) {
            if (!new File(source).isAbsolute()) {
                throw new IllegalArgumentException("Source should be absolute.");
            }
            this.source = VirtualFileSystem.normalize(source);
            String t = target;
            if (t.startsWith("/")) {
                String string = t = t.length() == 1 ? "" : t.substring(1);
            }
            if (new File(t).isAbsolute()) {
                throw new IllegalArgumentException("Target should be relative.");
            }
            this.target = VirtualFileSystem.normalize(t);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Link) {
                Link link = (Link)obj;
                return this.getSourceFile().equals(link.getSourceFile()) && this.getTargetFile().equals(link.getTargetFile());
            }
            return false;
        }

        public int hashCode() {
            return this.getSourceFile().hashCode() ^ this.getTargetFile().hashCode();
        }

        public String getSourcePath() {
            return this.source;
        }

        public File getSourceFile() {
            return new File(this.source);
        }

        public String getTargetPath() {
            return this.target;
        }

        public File getTargetFile() {
            return new File(this.target);
        }

        public String toString() {
            return this.toString(new StringBuffer()).toString();
        }

        private StringBuffer toString(StringBuffer buf) {
            buf.append(this.source);
            buf.append(" = ");
            buf.append(this.target);
            return buf;
        }
    }
}

