/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.fileio.virtualfs;

import java.text.MessageFormat;
import java.util.List;

public final class ConflictingPathsException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE_TEMPLATE = "\nCould not create a link due to conflicting paths.\n\n  Link:         {0} -> {1}\n  Conflict(s):  {2}\n\n";
    private final String source;
    private final String target;
    private final List<String> conflicts;

    public ConflictingPathsException(String source, String target, List<String> conflicts) {
        this.source = source;
        this.target = target;
        this.conflicts = conflicts;
    }

    @Override
    public String getMessage() {
        StringBuilder buf = new StringBuilder();
        for (String path : this.conflicts) {
            if (buf.length() > 0) {
                buf.append("\n                ");
            }
            buf.append(path);
        }
        return MessageFormat.format(MESSAGE_TEMPLATE, this.source, this.target, buf.toString());
    }
}

