/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.fileio;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.eclipse.tools.common.util.fileio.FolderUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ZipFileExtractor {
    private static final String ARCHIVE_FILE_SEPARATOR = "/";
    private final IProject _project;
    private IPath _parentFolder;
    private FileFilter _fileFilter = null;
    private File _file;

    public ZipFileExtractor(IProject proj, URI zipFileUri) throws IOException {
        this(proj, zipFileUri, null);
    }

    public ZipFileExtractor(IProject proj, URI zipFileUri, IPath parentFolder) throws IOException {
        assert (proj != null);
        assert (zipFileUri != null);
        this._project = proj;
        this._file = new File(zipFileUri);
        if (!this._file.exists() || !this._file.canRead()) {
            throw new IOException("Either the file " + zipFileUri + " doesn't exist, or it can't be read.");
        }
        this._parentFolder = parentFolder != null ? parentFolder : this._project.getFullPath();
    }

    public void setFileFilter(FileFilter filter) {
        this._fileFilter = filter;
    }

    public void extractAllFiles() throws IOException, CoreException {
        this.extractAllFiles(false);
    }

    public void extractAllFiles(boolean override) throws IOException, CoreException {
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(this._file);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                if (zipEntry.isDirectory() || this._fileFilter != null && !this._fileFilter.accept(new File(zipEntry.getName()))) continue;
                this.writeFile(zipFile, zipEntry, override);
            }
        }
    }

    private void writeFile(ZipFile zipFile, ZipEntry entry, boolean override) throws CoreException, IOException {
        IFile file;
        InputStream inputStream;
        block11: {
            block12: {
                inputStream = null;
                try {
                    String name = entry.getName();
                    this.createFoldersForEntry(name);
                    file = this._project.getFile(String.valueOf(this._parentFolder.toOSString()) + name);
                    if (!file.exists() || override) break block11;
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return;
        }
        inputStream = zipFile.getInputStream(entry);
        file.create(inputStream, true, null);
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void createFoldersForEntry(String name) throws CoreException {
        int lastIndex = name.lastIndexOf(ARCHIVE_FILE_SEPARATOR);
        String fileFolderPath = lastIndex == -1 ? name : name.substring(0, lastIndex + 1);
        IPath folderPath = this._project.getFullPath().append(this._parentFolder).append((IPath)new Path(fileFolderPath));
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(folderPath);
        FolderUtil.createFolder(this._project, folder);
    }
}

