/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.fileio;

import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class FolderUtil {
    public static final IFolder createFolder(IProject project, IFolder folder) throws CoreException {
        if (folder.exists()) {
            return folder;
        }
        IPath folderPath = folder.getProjectRelativePath();
        int count = folderPath.segmentCount();
        if (count <= 0) {
            folder = null;
        } else {
            String[] segments = folderPath.segments();
            folder = project.getFolder(segments[0]);
            if (!folder.exists()) {
                folder.create(false, true, null);
            }
            int i = 1;
            while (i < segments.length) {
                IFolder previous = folder;
                if (!(folder = previous.getFolder(segments[i])).exists()) {
                    folder.create(false, true, null);
                }
                ++i;
            }
        }
        return folder;
    }

    public static void ensureDerivedFolderExists(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (folder != null) {
            if (!folder.exists()) {
                if (folder.getLocation().toFile().exists()) {
                    folder.refreshLocal(0, monitor);
                } else {
                    folder.create(true, true, monitor);
                }
            }
            if (folder.exists()) {
                folder.setDerived(true);
            }
        }
    }

    public static final IFolder createFolder(IProject project, String folderRelPath) throws CoreException {
        IPath rootPath = project.getFullPath();
        IPath fqPath = rootPath.append(folderRelPath);
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(fqPath);
        return FolderUtil.createFolder(project, folder);
    }

    public static void ensureFolder(IFile file, boolean isDerived, IProgressMonitor monitor) throws CoreException {
        IPath folderPath = file.getProjectRelativePath().removeLastSegments(1);
        IProject root = file.getProject();
        FolderUtil.ensureFolder(folderPath, root, isDerived, monitor);
    }

    public static void ensureFolder(IPath folderPath, IProject root, boolean isDerived, IProgressMonitor monitor) throws CoreException {
        if (folderPath.isEmpty() || folderPath.isRoot()) {
            return;
        }
        IFolder folder = root.getFolder(folderPath);
        if (folder.exists()) {
            return;
        }
        if (folderPath.toString().indexOf("/") != -1) {
            FolderUtil.ensureFolder(folderPath.removeLastSegments(1), root, isDerived, monitor);
        }
        folder.create(true, true, monitor);
        folder.setDerived(isDerived);
    }

    public static IFolder ensureFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        return FolderUtil.ensureFolder(folder, false, monitor);
    }

    public static IFolder ensureFolder(IFolder folder, boolean isDerived, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                FolderUtil.ensureFolder((IFolder)parent, isDerived, monitor);
            }
            folder.create(true, true, monitor);
        }
        folder.setDerived(isDerived);
        return folder;
    }

    public static IFolder ensureEmptyFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (folder.exists()) {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member.getType() == 2) {
                    FolderUtil.ensureEmptyFolder((IFolder)member, monitor);
                }
                member.delete(true, monitor);
                ++n2;
            }
        }
        return folder;
    }

    public static final boolean validFolderPathVariant(IFolder f) {
        if (f != null) {
            IResource variant;
            if (f.exists()) {
                return true;
            }
            if (EclipseFileUtil.caseSensitive) {
                return true;
            }
            if (f instanceof Resource && (variant = ((Resource)f).findExistingResourceVariant(f.getFullPath())) != null) {
                return false;
            }
        }
        return true;
    }
}

