/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public final class MultiParentClassLoader
extends ClassLoader {
    private final List<ClassLoader> _parents;

    public MultiParentClassLoader(ClassLoader ... parents) {
        super(parents[0]);
        this._parents = new ArrayList<ClassLoader>(parents.length);
        int i = 0;
        while (i < parents.length) {
            this._parents.add(parents[i]);
            ++i;
        }
    }

    public MultiParentClassLoader(ClassLoader parent) {
        super(parent);
        this._parents = new ArrayList<ClassLoader>();
        if (parent != null) {
            this._parents.add(parent);
        }
    }

    public ClassLoader[] getAllParents() {
        return this._parents.toArray(new ClassLoader[this._parents.size()]);
    }

    @Override
    public URL findResource(String name) {
        for (ClassLoader p : this._parents) {
            URL resource = p.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (ClassLoader p : this._parents) {
            Enumeration<URL> rsrcs = p.getResources(name);
            while (rsrcs.hasMoreElements()) {
                resources.add(rsrcs.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            for (ClassLoader p : this._parents) {
                try {
                    if (p == null) continue;
                    c = p.loadClass(name);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\n");
        ClassLoader[] classLoaderArray = this.getAllParents();
        int n = classLoaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader cl = classLoaderArray[n2];
            if (cl instanceof URLClassLoader) {
                URLClassLoader rcl = (URLClassLoader)cl;
                URL[] uRLArray = rcl.getURLs();
                int n3 = uRLArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    URL url = uRLArray[n4];
                    sb.append(url.getFile());
                    sb.append("\n");
                    ++n4;
                }
            } else {
                sb.append(cl.toString());
                sb.append("\n");
            }
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }
}

