/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.classloader;

import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.util.classloader.ClosableClassLoader;
import oracle.eclipse.tools.common.util.classloader.JarClassLoader;
import oracle.eclipse.tools.common.util.classloader.MultiParentClassLoader;

public abstract class CloseableRuntime {
    public void close() {
        CloseableRuntime.closeClassLoader(this.getClass().getClassLoader(), new HashSet<ClassLoader>());
    }

    private static void closeClassLoader(ClassLoader classLoader, Set<ClassLoader> cyclicCheck) {
        if (classLoader == null) {
            return;
        }
        if (cyclicCheck.contains(classLoader)) {
            return;
        }
        cyclicCheck.add(classLoader);
        if (classLoader instanceof ClosableClassLoader) {
            ((ClosableClassLoader)classLoader).close();
            CloseableRuntime.closeClassLoader(classLoader.getParent(), cyclicCheck);
        } else if (classLoader instanceof JarClassLoader) {
            ((JarClassLoader)classLoader).close();
            CloseableRuntime.closeClassLoader(classLoader.getParent(), cyclicCheck);
        } else if (classLoader instanceof MultiParentClassLoader) {
            ClassLoader[] parents;
            ClassLoader[] classLoaderArray = parents = ((MultiParentClassLoader)classLoader).getAllParents();
            int n = parents.length;
            int n2 = 0;
            while (n2 < n) {
                ClassLoader parent = classLoaderArray[n2];
                CloseableRuntime.closeClassLoader(parent, cyclicCheck);
                ++n2;
            }
        } else {
            CloseableRuntime.closeClassLoader(classLoader.getParent(), cyclicCheck);
        }
    }
}

