/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.classloader;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.util.classloader.JarClassLoader;
import oracle.eclipse.tools.common.util.classloader.MultiParentClassLoader;
import oracle.eclipse.tools.common.util.jdt.ClasspathUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public abstract class AbstractClassLoaderAdapterFactory
implements IAdapterFactory {
    private final Map<Key, SoftReference<ClassLoader>> _cache = new HashMap<Key, SoftReference<ClassLoader>>();
    private final Map<CompoundKey, Object> _objectCache = new HashMap<CompoundKey, Object>();

    public synchronized Object getAdapter(Object adaptableObject, Class adapterType) {
        assert (adapterType != null);
        ClassLoader loader = null;
        Key key = this.getCacheKey(adaptableObject, adapterType);
        CompoundKey ck = new CompoundKey(key, adapterType);
        Object object = this._objectCache.get(ck);
        if (object != null && !key.hasExpired()) {
            return object;
        }
        SoftReference<ClassLoader> ref = this._cache.get(key);
        if (ref != null) {
            loader = ref.get();
        }
        if (loader == null || key.hasExpired()) {
            loader = this.instantiateClassLoader(adaptableObject, adapterType);
            if (loader == null) {
                LoggingService.logWarning("oracle.eclipse.tools.common", "unable to instantiate a classloader for " + adaptableObject);
                return null;
            }
            LoggingService.logDebug("oracle.eclipse.tools.common", "refreshing classloader cache for: " + adaptableObject);
            this._cache.put(key, new SoftReference<ClassLoader>(loader));
        }
        assert (loader != null);
        if (ClassLoader.class.isAssignableFrom(adapterType)) {
            return loader;
        }
        String implementation = this.getImplementationType(adapterType.getName());
        if (implementation != null) {
            object = this.getAdapterInstance(loader, adapterType, implementation, adaptableObject);
            this._objectCache.put(ck, object);
        }
        return object;
    }

    protected Key getCacheKey(Object adaptableObject, Class adapterType) {
        return new Key(adapterType, false, adaptableObject);
    }

    protected ClassLoader instantiateClassLoader(Object adaptableObject, Class adapterType) {
        ClassLoader parentLoader = this.getClassLoaderFor(adaptableObject);
        String implementation = this.getImplementationType(adapterType.getName());
        if (implementation != null && parentLoader == null) {
            return null;
        }
        ClassLoader bundleLoader = adapterType.getClassLoader();
        ClassLoader parent = parentLoader != null ? new MultiParentClassLoader(parentLoader, bundleLoader) : bundleLoader;
        URL[] urls = this.getClasspathURLsForAdapter(adaptableObject);
        if (urls.length == 0) {
            return parent;
        }
        ArrayList<File> files = new ArrayList<File>(urls.length);
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            files.add(new File(url.getFile()));
            ++n2;
        }
        return new JarClassLoader(files, parent);
    }

    protected abstract URL[] getClasspathURLsForAdapter(Object var1);

    protected abstract ClassLoader getClassLoaderFor(Object var1);

    protected abstract String getImplementationType(String var1);

    public Class[] getAdapterList() {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".getAdapterList is unsupported");
    }

    protected Object getAdapterInstance(ClassLoader loader, Class adapterType, String implementation, Object constructorArg) {
        Class<?> clazz;
        block13: {
            assert (adapterType != null);
            assert (loader != null);
            assert (implementation != null);
            String type = adapterType.getName();
            clazz = loader.loadClass(implementation);
            if (clazz == null) {
                throw new ClassNotFoundException("Unable to find implementation type: " + implementation + "  mapped from: " + type);
            }
            if (adapterType.isAssignableFrom(clazz)) break block13;
            LoggingService.logError("oracle.eclipse.tools.common", String.valueOf(this.getClass().getName()) + ": incorrect implementation mapping, " + implementation + " is not assignable to " + type);
            return null;
        }
        try {
            Class<?> argumentType = constructorArg.getClass();
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length == 1 && parameterTypes[0].isAssignableFrom(argumentType)) {
                    try {
                        return constructor.newInstance(constructorArg);
                    }
                    catch (InvocationTargetException ite) {
                        LoggingService.logWarning("oracle.eclipse.tools.common", ite.getLocalizedMessage());
                    }
                }
                ++n2;
            }
            return clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            LoggingService.logException("oracle.eclipse.tools.common", (Throwable)cnfe, "Unable to instantiate class: " + implementation + "\nfrom classloader: " + loader);
        }
        catch (InstantiationException ie) {
            LoggingService.logException("oracle.eclipse.tools.common", (Throwable)ie, "Unable to instantiate class: " + implementation + "\nfrom classloader: " + loader);
        }
        catch (IllegalAccessException iae) {
            LoggingService.logException("oracle.eclipse.tools.common", (Throwable)iae, "Unable to instantiate class: " + implementation + "\nfrom classloader: " + loader);
        }
        return null;
    }

    protected URL fileToURL(File file) {
        if (!file.exists()) {
            LoggingService.logError("oracle.eclipse.tools.common", "attempting to load non-existent file: " + file);
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException murle) {
            LoggingService.logException("oracle.eclipse.tools.common", (Throwable)murle);
            return null;
        }
    }

    protected URL[] getURLsForBundle(String bundleId) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            List<IPath> paths = ClasspathUtil.getPluginClasspath(bundleId);
            for (IPath path : paths) {
                URL url = this.fileToURL(new File(path.toString()));
                if (url == null) continue;
                urls.add(url);
            }
        }
        catch (CoreException ce) {
            LoggingService.logException("oracle.eclipse.tools.common", ce);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    protected URL getURLForBundlePath(String bundleId, String path) {
        assert (bundleId != null);
        assert (path != null);
        return this.getURLForBundlePath(bundleId, (IPath)new Path(path));
    }

    protected URL getURLForBundlePath(String bundleId, IPath path) {
        assert (bundleId != null);
        assert (path != null);
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            LoggingService.logException("oracle.eclipse.tools.common", (Throwable)new NullPointerException("Failed to locate bundle: " + bundleId));
            return null;
        }
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url == null) {
            LoggingService.logException("oracle.eclipse.tools.common", (Throwable)new Exception("File not found: " + path + " in bundle " + bundleId));
            return null;
        }
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException ioe) {
            LoggingService.logException("oracle.eclipse.tools.common", (Throwable)ioe);
        }
        return url;
    }

    protected static class CompoundKey {
        private Key _key;
        private Class<?> _adapterType;

        public CompoundKey(Key key, Class<?> adapterType) {
            this._key = key;
            this._adapterType = adapterType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompoundKey)) {
                return false;
            }
            CompoundKey anotherKey = (CompoundKey)o;
            return this._key.equals(anotherKey._key) && this._adapterType.equals(anotherKey._adapterType);
        }

        public int hashCode() {
            return this._key.hashCode() + this._adapterType.hashCode();
        }
    }

    protected static class Key {
        private final int _hashcode;
        private final boolean _expired;

        public Key(Class<?> type, boolean expired, Object ... args) {
            assert (type != null);
            this._hashcode = this.calculateHashCode(type, args);
            this._expired = expired;
        }

        public int hashCode() {
            return this._hashcode;
        }

        protected int calculateHashCode(Class<?> type, Object ... args) {
            int result = 17;
            result = 37 * result + type.hashCode();
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                result = 37 * result + obj.hashCode();
                ++n2;
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            return this._hashcode == ((Key)o)._hashcode;
        }

        public String toString() {
            return "Key: " + this._hashcode + " expired: " + this._expired;
        }

        public boolean hasExpired() {
            return this._expired;
        }
    }
}

