/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

public class ReaderUtil {
    public static CompilationUnit parse(ICompilationUnit cu, boolean resolveBindings) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu);
        parser.setResolveBindings(resolveBindings);
        CompilationUnit cuNode = (CompilationUnit)parser.createAST(null);
        return cuNode;
    }

    public static TypeDeclaration getPrimaryType(CompilationUnit cuNode) {
        TypeDeclaration type;
        List types = cuNode.types();
        for (Object obj : types) {
            if (!(obj instanceof TypeDeclaration) || !Modifier.isPublic((int)(type = (TypeDeclaration)obj).getModifiers())) continue;
            return type;
        }
        for (Object obj : types) {
            if (!(obj instanceof TypeDeclaration) || (type = (TypeDeclaration)obj).getModifiers() != 0 || type.modifiers().isEmpty()) continue;
            return type;
        }
        return null;
    }

    public static TypeDeclaration findInnerType(TypeDeclaration outerType, String name) {
        TypeDeclaration type;
        TypeDeclaration[] typeDeclarationArray = outerType.getTypes();
        int n = typeDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            type = typeDeclarationArray[n2];
            if (type.getName().getIdentifier().equals(name)) {
                return type;
            }
            ++n2;
        }
        typeDeclarationArray = outerType.getTypes();
        n = typeDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            type = typeDeclarationArray[n2];
            TypeDeclaration innerType = ReaderUtil.findInnerType(type, name);
            if (innerType != null) {
                return innerType;
            }
            ++n2;
        }
        return null;
    }

    public static IAnnotationBinding findAnnotationMatch(IBinding parent, String type) {
        IAnnotationBinding[] annotations;
        IAnnotationBinding[] iAnnotationBindingArray = annotations = parent.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding ann = iAnnotationBindingArray[n2];
            ITypeBinding typeBinding = ann.getAnnotationType();
            if (typeBinding != null && type.equals(typeBinding.getQualifiedName())) {
                return ann;
            }
            ++n2;
        }
        return null;
    }

    public static Annotation findAnnotationMatch(BodyDeclaration parent, String type) {
        List modifiers = parent.modifiers();
        int i = 0;
        while (i < modifiers.size()) {
            IExtendedModifier modifier = (IExtendedModifier)modifiers.get(i);
            if (modifier instanceof Annotation && ReaderUtil.isAnnotationOfType((Annotation)modifier, type)) {
                return (Annotation)modifier;
            }
            ++i;
        }
        return null;
    }

    public static List<IAnnotationBinding> getAnnotationArrayMembers(IAnnotationBinding parent, String attrName, String memberType) {
        Class<?> c;
        Object o;
        ArrayList<IAnnotationBinding> members = new ArrayList<IAnnotationBinding>();
        IMemberValuePairBinding mvp = ReaderUtil.getExpression(parent, attrName);
        if (mvp != null && (o = mvp.getValue()) != null && (c = o.getClass().getComponentType()) != null) {
            Object[] objArray;
            Object[] objectArray = objArray = (Object[])o;
            int n = objArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IAnnotationBinding) {
                    IAnnotationBinding member = (IAnnotationBinding)obj;
                    if (memberType == null) {
                        members.add(member);
                    } else {
                        ITypeBinding memberTypeBinding = member.getAnnotationType();
                        if (memberTypeBinding != null && memberTypeBinding.getQualifiedName().equals(memberType)) {
                            members.add(member);
                        }
                    }
                }
                ++n2;
            }
        }
        return members;
    }

    public static String getResolvedAnnotationType(Annotation annotation) {
        IAnnotationBinding resolvedAnnotation = annotation.resolveAnnotationBinding();
        if (resolvedAnnotation == null) {
            return null;
        }
        ITypeBinding annotationType = resolvedAnnotation.getAnnotationType();
        if (annotationType == null) {
            return null;
        }
        return annotationType.getQualifiedName();
    }

    public static boolean isAnnotationOfType(Annotation annotation, String type) {
        assert (type != null);
        assert (annotation != null);
        String fqType = ReaderUtil.getResolvedAnnotationType(annotation);
        if (fqType != null) {
            return fqType.equals(type);
        }
        return annotation.getTypeName().getFullyQualifiedName().equals(type);
    }

    public static List<Expression> getExpressionArray(NormalAnnotation anno, String name) {
        Expression annExpr = ReaderUtil.getExpression(anno, name);
        if (annExpr == null) {
            return Collections.emptyList();
        }
        ArrayList<Expression> exprs = null;
        if (annExpr.getNodeType() == 4) {
            exprs = ((ArrayInitializer)annExpr).expressions();
        } else {
            exprs = new ArrayList<Expression>(1);
            exprs.add(annExpr);
        }
        return exprs;
    }

    public static Expression getExpression(NormalAnnotation anno, String name) {
        return ReaderUtil.getExpression(anno.values(), name);
    }

    public static Expression getExpression(List<MemberValuePair> exprs, String name) {
        for (MemberValuePair pair : exprs) {
            if (!pair.getName().getIdentifier().equals(name)) continue;
            return pair.getValue();
        }
        return null;
    }

    public static String getExpressionValue(IAnnotationBinding anno, String name) {
        IMemberValuePairBinding mvp = ReaderUtil.getExpression(anno, name);
        if (mvp != null) {
            Object value = mvp.getValue();
            return value.toString();
        }
        return null;
    }

    public static IMemberValuePairBinding getExpression(IAnnotationBinding anno, String name) {
        IMemberValuePairBinding[] mvps;
        IMemberValuePairBinding[] iMemberValuePairBindingArray = mvps = anno.getDeclaredMemberValuePairs();
        int n = mvps.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePairBinding mvp = iMemberValuePairBindingArray[n2];
            if (name.equals(mvp.getName())) {
                return mvp;
            }
            ++n2;
        }
        return null;
    }

    public static String getExpressionValue(NormalAnnotation anno, String name) {
        return ReaderUtil.getExpressionValue(anno.values(), name);
    }

    public static String getExpressionValue(List<MemberValuePair> exprs, String name) {
        Expression value = ReaderUtil.getExpression(exprs, name);
        return ReaderUtil.getExpressionValue(value);
    }

    public static String getExpressionValue(Expression expr) {
        if (expr instanceof StringLiteral) {
            try {
                return ((StringLiteral)expr).getLiteralValue();
            }
            catch (IllegalArgumentException e) {
                LoggingService.logFatal("oracle.eclipse.tools.common", (Throwable)e, "Got IllegalArgumentException with StringLiteral (CR271412): (" + expr + "); full AST:\n" + expr.getAST().toString() + "\n----- end ast log -----");
            }
        } else {
            Type t;
            ITypeBinding binding;
            if (expr instanceof BooleanLiteral) {
                return Boolean.toString(((BooleanLiteral)expr).booleanValue());
            }
            if (expr instanceof NumberLiteral) {
                return ((NumberLiteral)expr).getToken();
            }
            if (expr instanceof Name) {
                return ((Name)expr).getFullyQualifiedName();
            }
            if (expr instanceof TypeLiteral && (binding = (t = ((TypeLiteral)expr).getType()).resolveBinding()) != null) {
                return binding.getQualifiedName();
            }
        }
        return null;
    }

    public static boolean getBooleanExpressionValue(Annotation annotation, String name, boolean defaultValue) {
        if (!(annotation instanceof NormalAnnotation)) {
            return defaultValue;
        }
        String s = ReaderUtil.getExpressionValue(((NormalAnnotation)annotation).values(), name);
        return s == null ? defaultValue : Boolean.valueOf(s);
    }

    public static boolean getBooleanExpressionValue(List<MemberValuePair> exprs, String name, boolean defaultValue) {
        String s = ReaderUtil.getExpressionValue(exprs, name);
        return s == null ? defaultValue : Boolean.valueOf(s);
    }

    public static List<String> getStringValues(Annotation ann, String attrName) {
        if (!(ann instanceof NormalAnnotation)) {
            return Collections.emptyList();
        }
        Expression expr = ReaderUtil.getExpression((NormalAnnotation)ann, attrName);
        if (expr == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        if (expr instanceof ArrayInitializer) {
            List values = ((ArrayInitializer)expr).expressions();
            int i = 0;
            while (i < values.size()) {
                Object o = values.get(i);
                if (o instanceof StringLiteral) {
                    stringValues.add(((StringLiteral)o).getLiteralValue());
                }
                ++i;
            }
        } else if (expr instanceof StringLiteral) {
            stringValues.add(((StringLiteral)expr).getLiteralValue());
        }
        return stringValues;
    }

    public static String getFullyQualifiedType(SimpleType type, ICompilationUnit icu) {
        ITypeBinding typeBinding = type.resolveBinding();
        if (typeBinding != null) {
            return typeBinding.getQualifiedName();
        }
        String typeName = type.getName().getFullyQualifiedName();
        try {
            return ClassUtil.resolveType(typeName, icu);
        }
        catch (JavaModelException e) {
            LoggingService.logException("oracle.eclipse.tools.common", (Throwable)e, "Error resolving type: " + typeName);
            assert (false) : "Error resolving type: " + typeName;
            return null;
        }
    }

    public static String getFullyQualifiedMethodArgumentType(MethodDeclaration method, int position) {
        SingleVariableDeclaration param;
        Type t;
        ITypeBinding typeBinding;
        List params = method.parameters();
        if (params.size() > position && (typeBinding = (t = (param = (SingleVariableDeclaration)params.get(position)).getType()).resolveBinding()) != null) {
            return typeBinding.getQualifiedName();
        }
        return null;
    }

    public static ASTNode getASTNodeForJavaElement(IJavaElement element, ListRewrite rewrite) {
        List list = rewrite.getRewrittenList();
        ITypeBinding binding = null;
        ASTNode node = null;
        for (ASTNode n : list) {
            IJavaElement e;
            if (!(n instanceof BodyDeclaration)) continue;
            if (n instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration atd = (AbstractTypeDeclaration)n;
                binding = atd.resolveBinding();
            } else if (n instanceof AnnotationTypeMemberDeclaration) {
                AnnotationTypeMemberDeclaration atmd = (AnnotationTypeMemberDeclaration)n;
                binding = atmd.resolveBinding();
            } else if (n instanceof EnumConstantDeclaration) {
                EnumConstantDeclaration ecd = (EnumConstantDeclaration)n;
                binding = ecd.resolveVariable();
            } else if (n instanceof FieldDeclaration) {
                FieldDeclaration fd = (FieldDeclaration)n;
                List fragments = fd.fragments();
                for (VariableDeclarationFragment fragment : fragments) {
                    binding = fragment.resolveBinding();
                    if (binding == null) {
                        continue;
                    }
                    break;
                }
            } else if (!(n instanceof Initializer)) {
                if (n instanceof MethodDeclaration) {
                    MethodDeclaration md = (MethodDeclaration)n;
                    binding = md.resolveBinding();
                } else assert (false) : "There is an instance of BodyDeclaration we're not handling: " + n.getClass().getName();
            }
            if (binding == null || !element.equals(e = binding.getJavaElement())) continue;
            node = n;
            break;
        }
        return node;
    }

    public static String getVariableType(TypeDeclaration mainType, String fieldName) {
        ITypeBinding typeBinding = mainType.resolveBinding();
        if (typeBinding == null) {
            return null;
        }
        ITypeBinding mainTypeBinding = typeBinding;
        IPackageBinding mainPkgBinding = typeBinding.getPackage();
        String mainPkg = mainPkgBinding.getName();
        ITypeBinding objectTypeBinding = mainType.getAST().resolveWellKnownType(Object.class.getName());
        while (typeBinding != null && !typeBinding.equals((Object)objectTypeBinding)) {
            IVariableBinding[] vars;
            IPackageBinding pkgBinding = typeBinding.getPackage();
            String pkg = pkgBinding.getName();
            IVariableBinding[] iVariableBindingArray = vars = typeBinding.getDeclaredFields();
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableBinding var = iVariableBindingArray[n2];
                String name = var.getName();
                int modifiers = var.getModifiers();
                if (fieldName.equals(name)) {
                    ITypeBinding varType;
                    if (typeBinding != mainTypeBinding) {
                        boolean visible = false;
                        if (mainPkg.equals(pkg)) {
                            visible = !Modifier.isPrivate((int)modifiers);
                        } else {
                            boolean bl = visible = Modifier.isProtected((int)modifiers) || Modifier.isPublic((int)modifiers);
                        }
                        if (!visible) {
                            return null;
                        }
                    }
                    return (varType = var.getType()) == null ? null : varType.getQualifiedName();
                }
                ++n2;
            }
            typeBinding = typeBinding.getSuperclass();
        }
        return null;
    }

    public static boolean isFieldDeclared(String fieldIdentifier, ITypeBinding type) {
        assert (fieldIdentifier != null);
        if (type == null) {
            return false;
        }
        IVariableBinding[] iVariableBindingArray = type.getDeclaredFields();
        int n = iVariableBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding declaration = iVariableBindingArray[n2];
            if (fieldIdentifier.equals(declaration.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isInterfaceImplemented(String interfaceName, ITypeBinding type) {
        assert (interfaceName != null);
        if (type == null) {
            return false;
        }
        ITypeBinding[] iTypeBindingArray = type.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding binding = iTypeBindingArray[n2];
            if (interfaceName.equals(binding.getQualifiedName())) {
                return true;
            }
            if (ReaderUtil.isInterfaceImplemented(interfaceName, binding)) {
                return true;
            }
            ++n2;
        }
        return ReaderUtil.isInterfaceImplemented(interfaceName, type.getSuperclass());
    }

    public static IMethod findMethod(IType type, String name, List<String> paramTypes) {
        IMethod method = null;
        try {
            IMethod[] meths;
            IMethod[] iMethodArray = meths = type.getMethods();
            int n = meths.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod imeth = iMethodArray[n2];
                if (imeth.getElementName().equals(name) && ReaderUtil.doesMethodHaveParamTypes(type, imeth, paramTypes)) {
                    method = imeth;
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            LoggingService.logException("oracle.eclipse.tools.common", (CoreException)((Object)jme));
        }
        return method;
    }

    public static IField findField(IType type, String name) {
        IField field = null;
        try {
            IField[] fields;
            IField[] iFieldArray = fields = type.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField ifield = iFieldArray[n2];
                if (ifield.getElementName().equals(name)) {
                    field = ifield;
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            LoggingService.logException("oracle.eclipse.tools.common", (CoreException)((Object)jme));
        }
        return field;
    }

    private static boolean doesMethodHaveParamTypes(IType type, IMethod method, List<String> ctrlMethParamTypes) {
        String[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != ctrlMethParamTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < paramTypes.length) {
            String typeName = Signature.toString((String)paramTypes[i]);
            String controlTypeName = ctrlMethParamTypes.get(i);
            if (!ClassUtil.isPrimitiveType(typeName)) {
                String resolvedTypeName = ClassUtil.resolveType(typeName, type);
                if (resolvedTypeName == null) {
                    int dot = controlTypeName.lastIndexOf(46);
                    if (dot > -1) {
                        controlTypeName = controlTypeName.substring(dot);
                    }
                } else {
                    typeName = resolvedTypeName;
                }
            }
            if (!typeName.equals(controlTypeName)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

