/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.ast;

import java.util.List;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

public interface IBodyDeclarationInserter {
    public void insert(ListRewrite var1, ASTNode var2);

    public static abstract class AbstractASTNodeInserter
    implements IBodyDeclarationInserter {
        protected ASTNode findLastNode(List<ASTNode> list, int type) {
            ASTNode last = null;
            for (ASTNode node : list) {
                if (node.getNodeType() != type) continue;
                last = node;
            }
            return last;
        }

        protected ASTNode findFirstNode(List<ASTNode> list, int type) {
            for (ASTNode node : list) {
                if (node.getNodeType() != type) continue;
                return node;
            }
            return null;
        }
    }

    public static class DefaultNodeInserter
    extends AbstractASTNodeInserter {
        @Override
        public void insert(ListRewrite rewrite, ASTNode node) {
            List list = rewrite.getRewrittenList();
            ASTNode refNode = this.findLastNode(list, node.getNodeType());
            if (refNode != null) {
                rewrite.insertAfter(node, refNode, null);
            } else {
                rewrite.insertLast(node, null);
            }
        }
    }

    public static class FieldInserter
    extends AbstractASTNodeInserter {
        @Override
        public void insert(ListRewrite rewrite, ASTNode node) {
            List list = rewrite.getRewrittenList();
            ASTNode lastField = this.findLastNode(list, 23);
            if (lastField != null) {
                rewrite.insertAfter(node, lastField, null);
            } else {
                rewrite.insertFirst(node, null);
            }
        }
    }

    public static class MethodInserter
    extends AbstractASTNodeInserter {
        @Override
        public void insert(ListRewrite rewrite, ASTNode node) {
            List list = rewrite.getRewrittenList();
            ASTNode lastMethod = this.findLastNode(list, 31);
            if (lastMethod != null) {
                rewrite.insertAfter(node, lastMethod, null);
            } else {
                ASTNode firstType = this.findFirstNode(list, 55);
                if (firstType != null) {
                    rewrite.insertBefore(node, firstType, null);
                } else {
                    rewrite.insertLast(node, null);
                }
            }
        }
    }

    public static class ReferenceElementInserter
    extends ReferenceNodeInserter {
        private IJavaElement _javaElementSibling;

        public ReferenceElementInserter(IJavaElement sibling, ReferenceNodeInserter.RelativeLocation location) {
            this._javaElementSibling = sibling;
            this._location = location;
        }

        @Override
        public void insert(ListRewrite rewrite, ASTNode node) {
            this._astNodeSibling = ReaderUtil.getASTNodeForJavaElement(this._javaElementSibling, rewrite);
            if (this._astNodeSibling != null && !rewrite.getRewrittenList().contains(this._astNodeSibling)) {
                this._astNodeSibling = null;
            }
            super.insert(rewrite, node);
        }
    }

    public static class ReferenceNodeInserter
    implements IBodyDeclarationInserter {
        protected ASTNode _astNodeSibling;
        protected RelativeLocation _location;

        protected ReferenceNodeInserter() {
        }

        public ReferenceNodeInserter(ASTNode sibling, RelativeLocation location) {
            this._astNodeSibling = sibling;
            this._location = location;
        }

        @Override
        public void insert(ListRewrite rewrite, ASTNode node) {
            if (this._astNodeSibling == null) {
                if (this._location == RelativeLocation.BEFORE) {
                    rewrite.insertFirst(node, null);
                } else if (this._location == RelativeLocation.AFTER) {
                    rewrite.insertLast(node, null);
                }
            } else if (this._location == RelativeLocation.BEFORE) {
                rewrite.insertBefore(node, this._astNodeSibling, null);
            } else if (this._location == RelativeLocation.AFTER) {
                rewrite.insertAfter(node, this._astNodeSibling, null);
            }
        }

        public static enum RelativeLocation {
            BEFORE,
            AFTER;

        }
    }
}

