/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.awt.Component;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.common.util.ResourceLoader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;

public class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String PLATFORM_LINE_SEPARATOR = System.getProperty("line.separator");
    private static ResourceLoader _resourceLoader = new ResourceLoader(StringUtil.class);

    public static String capitalizeFirstLetter(String name) {
        if (name == null || name.length() == 0) {
            return EMPTY_STRING;
        }
        if (name.length() == 1) {
            return EMPTY_STRING + Character.toUpperCase(name.charAt(0));
        }
        return String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
    }

    public static boolean doesStringContainPattern(String source, String pattern, boolean exactMatch, boolean caseSensitive) {
        if (StringUtil.isEmpty(pattern) || StringUtil.isEmpty(source)) {
            return false;
        }
        if (exactMatch) {
            return caseSensitive ? source.equals(pattern) : source.equalsIgnoreCase(pattern);
        }
        return caseSensitive ? source.contains(pattern) : StringUtil.indexOfIgnoreCase(source, pattern) >= 0;
    }

    public static boolean doesStringContainWhitespace(String source) {
        char[] chars;
        assert (source != null && source.length() > 0) : "null or empty source string";
        char[] cArray = chars = source.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isWhitespace(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean endsWith(StringBuffer buf, String strSuffix) {
        if (buf.length() < strSuffix.length()) {
            return false;
        }
        int offset = buf.length() - strSuffix.length();
        int i = 0;
        while (i < strSuffix.length()) {
            if (strSuffix.charAt(i) != buf.charAt(offset + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        if (str.length() < suffix.length()) {
            return false;
        }
        String end = str.substring(str.length() - suffix.length(), str.length());
        return end.equalsIgnoreCase(suffix);
    }

    public static String escapeHTML(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    break;
                }
                case '\n': {
                    sb.append("\b");
                    break;
                }
                case '\r': {
                    sb.append("\b");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String escapeJava(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String escapeXMLText(String input) {
        return input.replaceAll("\\&", "&amp;").replaceAll("\\<", "&lt;").replaceAll("\\>", "&gt;");
    }

    public static int indexOfIgnoreCase(String source, String pattern) {
        return StringUtil.indexOfIgnoreCase(source, pattern, 0);
    }

    public static int indexOfIgnoreCase(String source, String pattern, int start) {
        int iLength = pattern.length();
        int iLastStart = source.length() - iLength + 1;
        int i = start;
        while (i < iLastStart) {
            if (pattern.regionMatches(true, 0, source, i, iLength)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String join(List parts, char delim) {
        StringBuffer buf = new StringBuffer(128);
        Iterator iter = parts.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next()).append(delim);
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String join(String[] parts, char delim) {
        StringBuffer buf = new StringBuffer(128);
        int i = 0;
        while (i < parts.length) {
            buf.append(parts[i]).append(delim);
            ++i;
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String lowerCaseFirstLetter(String name) {
        if (name == null || name.length() == 0) {
            return EMPTY_STRING;
        }
        if (name.length() == 1) {
            return EMPTY_STRING + Character.toLowerCase(name.charAt(0));
        }
        return String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
    }

    public static String replaceAll(String str, String strPattern, String strReplace) {
        int ichNext;
        StringBuffer ret = null;
        int ichLast = 0;
        while ((ichNext = str.indexOf(strPattern, ichLast)) != -1) {
            if (ret == null) {
                ret = new StringBuffer(str.length() + strReplace.length());
            }
            ret.append(str.substring(ichLast, ichNext));
            ret.append(strReplace);
            ichLast = ichNext + strPattern.length();
        }
        if (ret == null) {
            return str;
        }
        ret.append(str.substring(ichLast));
        return ret.toString();
    }

    public static List<String> split(String str, char delim) {
        ArrayList<String> parts = new ArrayList<String>();
        if (str == null) {
            return parts;
        }
        StringTokenizer tokens = new StringTokenizer(str, String.valueOf(delim));
        while (tokens.hasMoreTokens()) {
            parts.add(tokens.nextToken());
        }
        return parts;
    }

    public static List<String> split(String str, char delim, boolean fTrim, List<String> parts) {
        StringTokenizer tokens = new StringTokenizer(str, String.valueOf(delim));
        while (tokens.hasMoreTokens()) {
            String s = tokens.nextToken();
            if (fTrim && (s = s.trim()).length() == 0) continue;
            parts.add(s);
        }
        return parts;
    }

    public static String stripPackage(String str) {
        assert (str != null);
        int lastDot = str.lastIndexOf(".");
        return lastDot == -1 ? str : str.substring(lastDot + 1);
    }

    public static String stripExtension(String str) {
        assert (str != null);
        int lastDot = str.lastIndexOf(46);
        return lastDot == -1 ? str : str.substring(0, lastDot);
    }

    public static String getPackage(String str) {
        assert (str != null);
        int lastDot = str.lastIndexOf(".");
        return lastDot == -1 ? null : str.substring(0, lastDot);
    }

    public static String trimQuotes(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] chars = string.toCharArray();
        int l = 0;
        int r = chars.length - 1;
        if (chars[l] == '\"' || chars[l] == '\'' && chars[l] == chars[r]) {
            return new String(chars, ++l, --r);
        }
        return string;
    }

    public static String truncate(String str, int len) {
        return str.substring(0, str.length() - len);
    }

    public static String truncateString(String input, int width, Component c) {
        return StringUtil.truncateString(input, width, c.getFontMetrics(c.getFont()));
    }

    public static String truncateString(String input, int width, FontMetrics fm) {
        int mid;
        if (input == null) {
            return null;
        }
        if (fm.stringWidth(input) <= width) {
            return input;
        }
        String ellipsis = "\u2026";
        if (fm.stringWidth(ellipsis) > width) {
            return EMPTY_STRING;
        }
        int high = input.length();
        int low = 0;
        while (true) {
            if (fm.stringWidth(String.valueOf(input.substring(0, mid = low + (high - low) / 2)) + ellipsis) > width) {
                high = mid - 1;
                continue;
            }
            if (fm.stringWidth(String.valueOf(input.substring(0, mid + 1)) + ellipsis) >= width) break;
            low = mid + 1;
        }
        return String.valueOf(input.substring(0, mid)) + ellipsis;
    }

    public static boolean validateJavaIdentifier(String id, StringBuffer message) {
        boolean validID = true;
        IStatus result = JavaConventions.validateIdentifier((String)id);
        if (!result.isOK()) {
            message.append(result.getMessage());
            validID = false;
        } else if (id.equals("enum")) {
            message.append(_resourceLoader.resource("enum-not-valid", new Object[0]));
            validID = false;
        } else if (id.equals("assert")) {
            message.append(_resourceLoader.resource("assert-not-valid", new Object[0]));
            validID = false;
        }
        return validID;
    }

    /*
     * Unable to fully structure code
     */
    public static String wrapText(String s, int desiredLength, int maxLength) {
        if (s.length() < maxLength) {
            return StringUtil.escapeHTML(s);
        }
        lineIterator = BreakIterator.getLineInstance();
        lineIterator.setText(s);
        sb = new StringBuffer();
        lastBreak = 0;
        position = lineIterator.next();
        lineCount = 0;
        ** GOTO lbl33
        {
            position = lineIterator.following(position);
            do {
                if (position < s.length() && position < lastBreak + desiredLength) continue block0;
                if (position == s.length() && position - lastBreak < maxLength) break block0;
                if (position - lastBreak > maxLength) {
                    while (position - lastBreak > maxLength) {
                        position = lineIterator.previous();
                    }
                    if (position <= lastBreak) {
                        position = lastBreak + maxLength;
                    }
                }
                sb.append(StringUtil.escapeHTML(s.substring(lastBreak, position)));
                sb.append("<br>");
                lastBreak = position;
                if (++lineCount != 30) continue;
                sb.append("<b>Truncated ");
                sb.append(s.length() - position);
                sb.append(" characters.");
                return sb.toString();
lbl33:
                // 2 sources

            } while (position != s.length() || position - lastBreak > maxLength);
        }
        sb.append(StringUtil.escapeHTML(s.substring(lastBreak)));
        return sb.toString();
    }

    public static String toStringStackTrace(Throwable t) {
        String string;
        PrintWriter pw;
        block7: {
            assert (t != null) : "Throwable was null.";
            StringWriter sw = new StringWriter();
            pw = new PrintWriter(sw);
            try {
                t.printStackTrace(pw);
                pw.flush();
                sw.flush();
                string = sw.toString();
            }
            catch (Throwable throwable) {
                block8: {
                    try {
                        sw.close();
                    }
                    catch (IOException iOException) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                pw.close();
                throw throwable;
            }
            try {
                sw.close();
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        pw.close();
        return string;
    }

    public static boolean onlyDiffersByExtension(String path1, String path2) {
        assert (path1 != null) : "Can't compare a null path";
        assert (path2 != null) : "Can't compare a null path";
        String subPath1 = path1;
        String subPath2 = path2;
        int i = path1.lastIndexOf(46);
        if (i > -1) {
            subPath1 = path1.substring(0, i);
        }
        if ((i = path2.lastIndexOf(46)) > -1) {
            subPath2 = path2.substring(0, i);
        }
        return ObjectUtil.areEqual(subPath1, subPath2);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String toStringNullable(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }
}

