/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class StatusCollector {
    private String pluginId;
    private String multiStatusMessage;
    private List<IStatus> statuses = null;

    public StatusCollector(String pluginId) {
        this(pluginId, Resources.defaultMultiStatusMessage);
    }

    public StatusCollector(String pluginId, String multiStatusMessage) {
        this.pluginId = pluginId;
        this.multiStatusMessage = multiStatusMessage;
    }

    public void add(IStatus st) {
        if (!st.isOK()) {
            if (this.statuses == null) {
                this.statuses = Collections.singletonList(st);
            } else if (this.statuses.size() == 1) {
                this.statuses = new ArrayList<IStatus>(this.statuses);
                this.statuses.add(st);
            } else {
                this.statuses.add(st);
            }
        }
    }

    public void merge(IStatus st) {
        if (st instanceof MultiStatus) {
            IStatus[] iStatusArray = ((MultiStatus)st).getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.add(child);
                ++n2;
            }
        } else {
            this.add(st);
        }
    }

    public int getSeverity() {
        if (this.statuses == null) {
            return 0;
        }
        int severity = 0;
        for (IStatus st : this.statuses) {
            int s = st.getSeverity();
            if (s > severity && (severity = s) == 4) break;
        }
        return severity;
    }

    public IStatus getStatus() {
        if (this.statuses == null) {
            return Status.OK_STATUS;
        }
        if (this.statuses.size() == 1) {
            return this.statuses.get(0);
        }
        IStatus[] array = this.statuses.toArray(new IStatus[this.statuses.size()]);
        return new MultiStatus(this.pluginId, -1, array, this.multiStatusMessage, null);
    }

    private static final class Resources
    extends NLS {
        public static String defaultMultiStatusMessage;

        static {
            Resources.initializeMessages((String)StatusCollector.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

