/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ResourceLoader {
    private final Class<?> cl;
    private List<ResourceBundle> bundles = null;

    public ResourceLoader(Class<?> cl) {
        this.cl = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resource(String key, Object ... args) {
        List<ResourceBundle> bundles;
        ResourceLoader resourceLoader = this;
        synchronized (resourceLoader) {
            if (this.bundles == null) {
                this.bundles = new ArrayList<ResourceBundle>();
                Class<?> c = this.cl;
                while (c != Object.class && c.getClassLoader() != null) {
                    try {
                        String name = c.getName();
                        ResourceBundle b = ResourceBundle.getBundle(name, Locale.getDefault(), c.getClassLoader());
                        this.bundles.add(b);
                    }
                    catch (MissingResourceException missingResourceException) {}
                    c = c.getSuperclass();
                }
            }
            bundles = this.bundles;
        }
        for (ResourceBundle b : bundles) {
            String str = null;
            try {
                str = b.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
            if (str == null) continue;
            return MessageFormat.format(str, args);
        }
        throw new IllegalArgumentException("Resource not found: " + key);
    }

    public static final class Static {
        private static final HashMap<Class<?>, ResourceLoader> cache = new HashMap();

        public static String resource(Object obj, String key, Object ... args) {
            return Static.resource(obj.getClass(), key, args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String resource(Class<?> cl, String key, Object ... args) {
            ResourceLoader rl;
            HashMap<Class<?>, ResourceLoader> hashMap = cache;
            synchronized (hashMap) {
                rl = cache.get(cl);
                if (rl == null) {
                    rl = new ResourceLoader(cl);
                    cache.put(cl, rl);
                }
            }
            return rl.resource(key, args);
        }
    }
}

